/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.netxms.client.datacollection.PerfTabDci;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="config", strict=false)
public class PerfTabGraphSettings {
    @Element(required=false)
    private boolean enabled = false;
    @Element(required=false)
    private boolean autoScale = true;
    @Element(required=false)
    private boolean logScaleEnabled = false;
    @Element(required=false)
    private int minYScaleValue = 1;
    @Element(required=false)
    private int maxYScaleValue = 100;
    @Element(required=false)
    private int timeRange = 1;
    @Element(required=false)
    private int timeUnits = 1;
    @Element(required=false)
    private int type = 0;
    @Element(required=false)
    private String color = "0x00C000";
    @Element(required=false)
    private String title = "";
    @Element(required=false)
    private String name = "";
    @Element(required=false)
    private boolean showThresholds = false;
    @Element(required=false)
    private long parentDciId = 0L;
    @Element(required=false)
    private String parentDciName = null;
    @Element(required=false)
    private int order = 100;
    private PerfTabDci runtimeDciInfo = null;

    public static PerfTabGraphSettings createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (PerfTabGraphSettings)serializer.read(PerfTabGraphSettings.class, xml);
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getType() {
        return this.type;
    }

    public String getColor() {
        return this.color;
    }

    public int getColorAsInt() {
        try {
            if (this.color.startsWith("0x")) {
                return Integer.parseInt(this.color.substring(2), 16);
            }
            return Integer.parseInt(this.color, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getRuntimeTitle() {
        String t = this.title == null || this.title.isEmpty() ? (this.runtimeDciInfo != null ? this.runtimeDciInfo.getDescription() : "") : this.title;
        return t.replace("{instance}", this.runtimeDciInfo != null ? this.runtimeDciInfo.getInstance() : "");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setColor(int color) {
        this.color = Integer.toString(color);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isShowThresholds() {
        return this.showThresholds;
    }

    public void setShowThresholds(boolean showThresholds) {
        this.showThresholds = showThresholds;
    }

    public final long getParentDciId() {
        return this.parentDciId;
    }

    public final void setParentDciId(long parentDciId) {
        this.parentDciId = parentDciId;
    }

    public final String getParentDciName() {
        return this.parentDciName;
    }

    public final void setParentDciName(String parentDciName) {
        this.parentDciName = parentDciName;
    }

    public final PerfTabDci getRuntimeDciInfo() {
        return this.runtimeDciInfo;
    }

    public final void setRuntimeDciInfo(PerfTabDci runtimeDciInfo) {
        this.runtimeDciInfo = runtimeDciInfo;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getRuntimeName() {
        String n = this.name == null || this.name.isEmpty() ? (this.runtimeDciInfo != null ? this.runtimeDciInfo.getDescription() : "") : this.name;
        return n.replace("{instance}", this.runtimeDciInfo != null ? this.runtimeDciInfo.getInstance() : "");
    }

    public final void fixParentDciId(List<PerfTabGraphSettings> settings) {
        if (this.parentDciId == 0L) {
            return;
        }
        for (PerfTabGraphSettings s : settings) {
            if (this.parentDciId == s.getRuntimeDciInfo().getId()) {
                return;
            }
            if (this.parentDciId != s.getRuntimeDciInfo().getTemplateDciId() || !s.getRuntimeDciInfo().getInstance().equals(this.runtimeDciInfo.getInstance())) continue;
            this.parentDciId = s.getRuntimeDciInfo().getId();
            return;
        }
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public int getMinYScaleValue() {
        return this.minYScaleValue;
    }

    public void setMinYScaleValue(int minYScaleValue) {
        this.minYScaleValue = minYScaleValue;
    }

    public int getMaxYScaleValue() {
        return this.maxYScaleValue;
    }

    public void setMaxYScaleValue(int maxYScaleValue) {
        this.maxYScaleValue = maxYScaleValue;
    }

    public int getTimeRange() {
        return this.timeRange;
    }

    public long getTimeRangeMillis() {
        switch (this.timeUnits) {
            case 0: {
                return (long)this.timeRange * 60L * 1000L;
            }
            case 1: {
                return (long)this.timeRange * 60L * 60L * 1000L;
            }
            case 2: {
                return (long)this.timeRange * 24L * 60L * 60L * 1000L;
            }
        }
        return 0L;
    }

    public void setTimeRange(int timeInterval) {
        this.timeRange = timeInterval;
    }

    public int getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(int timeUnits) {
        this.timeUnits = timeUnits;
    }

    public boolean isLogScaleEnabled() {
        return this.logScaleEnabled;
    }

    public void setLogScaleEnabled(boolean logScaleEnabled) {
        this.logScaleEnabled = logScaleEnabled;
    }
}

