/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.SyslogRecord;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SyslogLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS = new Color[]{FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_LIGHT};
    private static final Severity[] severityMap = new Severity[]{Severity.CRITICAL, Severity.CRITICAL, Severity.MAJOR, Severity.MINOR, Severity.WARNING, Severity.WARNING, Severity.NORMAL, Severity.NORMAL};
    private static final String[] severityText;
    private static final String[] facilityText;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private boolean showColor = true;
    private boolean showIcons = false;

    static {
        String[] stringArray = new String[8];
        Messages.get();
        stringArray[0] = Messages.SyslogLabelProvider_SevEmergency;
        Messages.get();
        stringArray[1] = Messages.SyslogLabelProvider_SevAlert;
        Messages.get();
        stringArray[2] = Messages.SyslogLabelProvider_SevCritical;
        Messages.get();
        stringArray[3] = Messages.SyslogLabelProvider_SevError;
        Messages.get();
        stringArray[4] = Messages.SyslogLabelProvider_SevWarning;
        Messages.get();
        stringArray[5] = Messages.SyslogLabelProvider_SevNotice;
        Messages.get();
        stringArray[6] = Messages.SyslogLabelProvider_SevInfo;
        Messages.get();
        stringArray[7] = Messages.SyslogLabelProvider_SevDebug;
        severityText = stringArray;
        String[] stringArray2 = new String[24];
        Messages.get();
        stringArray2[0] = Messages.SyslogLabelProvider_FacKernel;
        Messages.get();
        stringArray2[1] = Messages.SyslogLabelProvider_FacUser;
        Messages.get();
        stringArray2[2] = Messages.SyslogLabelProvider_FacMail;
        Messages.get();
        stringArray2[3] = Messages.SyslogLabelProvider_FacSystem;
        Messages.get();
        stringArray2[4] = Messages.SyslogLabelProvider_FacAuth;
        Messages.get();
        stringArray2[5] = Messages.SyslogLabelProvider_FacSyslog;
        Messages.get();
        stringArray2[6] = Messages.SyslogLabelProvider_FacLpr;
        Messages.get();
        stringArray2[7] = Messages.SyslogLabelProvider_FacNews;
        Messages.get();
        stringArray2[8] = Messages.SyslogLabelProvider_FacUUCP;
        Messages.get();
        stringArray2[9] = Messages.SyslogLabelProvider_FacCron;
        Messages.get();
        stringArray2[10] = Messages.SyslogLabelProvider_FacSecurity;
        Messages.get();
        stringArray2[11] = Messages.SyslogLabelProvider_FacFTPD;
        Messages.get();
        stringArray2[12] = Messages.SyslogLabelProvider_FacNTP;
        Messages.get();
        stringArray2[13] = Messages.SyslogLabelProvider_FacLogAudit;
        Messages.get();
        stringArray2[14] = Messages.SyslogLabelProvider_FacLogAlert;
        Messages.get();
        stringArray2[15] = Messages.SyslogLabelProvider_FacClock;
        Messages.get();
        stringArray2[16] = Messages.SyslogLabelProvider_FacLocal0;
        Messages.get();
        stringArray2[17] = Messages.SyslogLabelProvider_FacLocal1;
        Messages.get();
        stringArray2[18] = Messages.SyslogLabelProvider_FacLocal2;
        Messages.get();
        stringArray2[19] = Messages.SyslogLabelProvider_FacLocal3;
        Messages.get();
        stringArray2[20] = Messages.SyslogLabelProvider_FacLocal4;
        Messages.get();
        stringArray2[21] = Messages.SyslogLabelProvider_FacLocal5;
        Messages.get();
        stringArray2[22] = Messages.SyslogLabelProvider_FacLocal6;
        Messages.get();
        stringArray2[23] = Messages.SyslogLabelProvider_FacLocal7;
        facilityText = stringArray2;
    }

    public Color getForeground(Object element) {
        return this.showColor ? FOREGROUND_COLORS[severityMap[((SyslogRecord)element).getSeverity()].getValue()] : null;
    }

    public Color getBackground(Object element) {
        return this.showColor ? StatusDisplayInfo.getStatusColor((Severity)severityMap[((SyslogRecord)element).getSeverity()]) : null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.showIcons && columnIndex == 0) {
            return StatusDisplayInfo.getStatusImage((Severity)severityMap[((SyslogRecord)element).getSeverity()]);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SyslogRecord record = (SyslogRecord)element;
        switch (columnIndex) {
            case 0: {
                return RegionalSettings.getDateTimeFormat().format(record.getTimestamp());
            }
            case 1: {
                String string;
                AbstractObject object = this.session.findObjectById(record.getSourceObjectId());
                if (object != null) {
                    string = object.getObjectName();
                } else {
                    Messages.get();
                    string = Messages.SyslogLabelProvider_Unknown;
                }
                return string;
            }
            case 2: {
                try {
                    return severityText[record.getSeverity()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "<" + Integer.toString(record.getSeverity()) + ">";
                }
            }
            case 3: {
                try {
                    return facilityText[record.getFacility()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "<" + Integer.toString(record.getFacility()) + ">";
                }
            }
            case 6: {
                return record.getMessage();
            }
            case 5: {
                return record.getTag();
            }
            case 4: {
                return record.getHostname();
            }
        }
        return null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
    }
}

