/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolTableColumn;

public class ObjectToolDetails
extends ObjectTool {
    private boolean modified = false;
    private List<Long> accessList;
    private List<ObjectToolTableColumn> columns;

    public ObjectToolDetails(long toolId, int type, String name) {
        this.id = toolId;
        this.type = type;
        this.name = name;
        this.data = "";
        this.flags = 0;
        this.description = "";
        this.snmpOid = "";
        this.confirmationText = "";
        this.accessList = new ArrayList<Long>(0);
        this.columns = new ArrayList<ObjectToolTableColumn>(0);
        this.commandName = "";
        this.commandShortName = "";
        this.imageData = null;
        this.createDisplayName();
    }

    public ObjectToolDetails(NXCPMessage msg) {
        this.id = msg.getVariableAsInt64(165L);
        this.name = msg.getVariableAsString(20L);
        this.type = msg.getVariableAsInteger(196L);
        this.data = msg.getVariableAsString(197L);
        this.flags = msg.getVariableAsInteger(13L);
        this.description = msg.getVariableAsString(27L);
        this.snmpOid = msg.getVariableAsString(199L);
        this.confirmationText = msg.getVariableAsString(250L);
        this.commandName = msg.getVariableAsString(474L);
        this.commandShortName = msg.getVariableAsString(475L);
        this.imageData = msg.getVariableAsBinary(369L);
        Long[] acl = msg.getVariableAsUInt32ArrayEx(198L);
        this.accessList = acl != null ? new ArrayList<Long>(Arrays.asList(acl)) : new ArrayList(0);
        int count2 = msg.getVariableAsInteger(166L);
        this.columns = new ArrayList<ObjectToolTableColumn>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            this.columns.add(new ObjectToolTableColumn(msg, varId));
            varId += 4L;
        }
        this.createDisplayName();
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariableInt32(165L, (int)this.id);
        msg.setVariable(20L, this.name);
        msg.setVariable(27L, this.description);
        msg.setVariable(199L, this.snmpOid);
        msg.setVariable(250L, this.confirmationText);
        msg.setVariable(197L, this.data);
        msg.setVariableInt16(196L, this.type);
        msg.setVariableInt32(13L, this.flags);
        msg.setVariable(474L, this.commandName);
        msg.setVariable(475L, this.commandShortName);
        if (this.imageData != null) {
            msg.setVariable(369L, this.imageData);
        }
        msg.setVariableInt32(32L, this.accessList.size());
        msg.setVariable(198L, this.accessList.toArray(new Long[this.accessList.size()]));
        msg.setVariableInt16(166L, this.columns.size());
        long varId = 0x10000000L;
        for (int i = 0; i < this.columns.size(); ++i) {
            ObjectToolTableColumn c = this.columns.get(i);
            msg.setVariable(varId++, c.getName());
            msg.setVariable(varId++, c.getSnmpOid());
            msg.setVariableInt16(varId++, c.getFormat());
            msg.setVariableInt16(varId++, c.getSubstringIndex());
        }
    }

    public List<Long> getAccessList() {
        return this.accessList;
    }

    public List<ObjectToolTableColumn> getColumns() {
        return this.columns;
    }

    public void setId(long id) {
        this.id = id;
        this.modified = true;
    }

    public void setName(String name) {
        this.name = name;
        this.createDisplayName();
        this.modified = true;
    }

    public void setType(int type) {
        this.type = type;
        this.modified = true;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.modified = true;
    }

    public void setDescription(String description) {
        this.description = description;
        this.modified = true;
    }

    public void setSnmpOid(String snmpOid) {
        this.snmpOid = snmpOid;
        this.modified = true;
    }

    public void setData(String data) {
        this.data = data;
        this.modified = true;
    }

    public void setConfirmationText(String confirmationText) {
        this.confirmationText = confirmationText;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setAccessList(List<Long> accessList) {
        this.accessList = accessList;
        this.modified = true;
    }

    public void setColumns(List<ObjectToolTableColumn> columns) {
        this.columns = columns;
        this.modified = true;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
        this.modified = true;
    }

    public void setCommandShortName(String commandShortName) {
        this.commandShortName = commandShortName;
        this.modified = true;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
        this.modified = true;
    }
}

