/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.AccessListElement;
import org.netxms.client.GeoLocation;
import org.netxms.client.NXCSession;

public class GenericObject {
    public static final int OBJECT_GENERIC = 0;
    public static final int OBJECT_SUBNET = 1;
    public static final int OBJECT_NODE = 2;
    public static final int OBJECT_INTERFACE = 3;
    public static final int OBJECT_NETWORK = 4;
    public static final int OBJECT_CONTAINER = 5;
    public static final int OBJECT_ZONE = 6;
    public static final int OBJECT_SERVICEROOT = 7;
    public static final int OBJECT_TEMPLATE = 8;
    public static final int OBJECT_TEMPLATEGROUP = 9;
    public static final int OBJECT_TEMPLATEROOT = 10;
    public static final int OBJECT_NETWORKSERVICE = 11;
    public static final int OBJECT_VPNCONNECTOR = 12;
    public static final int OBJECT_CONDITION = 13;
    public static final int OBJECT_CLUSTER = 14;
    public static final int OBJECT_POLICYGROUP = 15;
    public static final int OBJECT_POLICYROOT = 16;
    public static final int OBJECT_AGENTPOLICY = 17;
    public static final int OBJECT_AGENTPOLICY_CONFIG = 18;
    public static final int OBJECT_NETWORKMAPROOT = 19;
    public static final int OBJECT_NETWORKMAPGROUP = 20;
    public static final int OBJECT_NETWORKMAP = 21;
    public static final int OBJECT_DASHBOARDROOT = 22;
    public static final int OBJECT_DASHBOARD = 23;
    public static final int OBJECT_REPORTROOT = 24;
    public static final int OBJECT_REPORTGROUP = 25;
    public static final int OBJECT_REPORT = 26;
    public static final int OBJECT_BUSINESSSERVICEROOT = 27;
    public static final int OBJECT_BUSINESSSERVICE = 28;
    public static final int OBJECT_NODELINK = 29;
    public static final int OBJECT_SLMCHECK = 30;
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_WARNING = 1;
    public static final int STATUS_MINOR = 2;
    public static final int STATUS_MAJOR = 3;
    public static final int STATUS_CRITICAL = 4;
    public static final int STATUS_UNKNOWN = 5;
    public static final int STATUS_UNMANAGED = 6;
    public static final int STATUS_DISABLED = 7;
    public static final int STATUS_TESTING = 8;
    public static final int CALCULATE_DEFAULT = 0;
    public static final int CALCULATE_MOST_CRITICAL = 1;
    public static final int CALCULATE_SINGLE_THRESHOLD = 2;
    public static final int CALCULATE_MULTIPLE_THRESHOLDS = 3;
    public static final int PROPAGATE_DEFAULT = 0;
    public static final int PROPAGATE_UNCHANGED = 1;
    public static final int PROPAGATE_FIXED = 2;
    public static final int PROPAGATE_RELATIVE = 3;
    public static final int PROPAGATE_TRANSLATED = 4;
    protected NXCSession session = null;
    private long objectId = 0L;
    private UUID guid;
    private String objectName;
    private int objectClass;
    private int status = 5;
    private boolean isDeleted = false;
    private InetAddress primaryIP;
    private String comments;
    private GeoLocation geolocation;
    private UUID image;
    private long submapId;
    private HashSet<Long> trustedNodes = new HashSet(0);
    private boolean inheritAccessRights = true;
    private HashSet<AccessListElement> accessList = new HashSet(0);
    private int statusCalculationMethod;
    private int statusPropagationMethod;
    private int fixedPropagatedStatus;
    private int statusShift;
    private int[] statusTransformation;
    private int statusSingleThreshold;
    private int[] statusThresholds;
    protected HashSet<Long> parents = new HashSet(0);
    protected HashSet<Long> childs = new HashSet(0);
    protected Map<String, String> customAttributes = new HashMap<String, String>(0);

    protected GenericObject(long id, NXCSession session) {
        this.objectId = id;
        this.session = session;
        this.guid = UUID.randomUUID();
        this.objectName = "unknown";
        this.objectClass = 0;
        try {
            this.primaryIP = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.comments = "";
        this.geolocation = new GeoLocation(false);
        this.image = NXCommon.EMPTY_GUID;
        this.statusCalculationMethod = 0;
        this.statusPropagationMethod = 0;
        this.fixedPropagatedStatus = 0;
        this.statusShift = 0;
        this.statusTransformation = new int[4];
        this.statusTransformation[0] = 1;
        this.statusTransformation[1] = 2;
        this.statusTransformation[2] = 3;
        this.statusTransformation[3] = 4;
        this.statusSingleThreshold = 75;
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = 75;
        this.statusThresholds[1] = 75;
        this.statusThresholds[2] = 75;
        this.statusThresholds[3] = 75;
    }

    public GenericObject(NXCPMessage msg, NXCSession session) {
        this.session = session;
        this.objectId = msg.getVariableAsInteger(3L);
        this.guid = msg.getVariableAsUUID(222L);
        this.objectName = msg.getVariableAsString(4L);
        this.objectClass = msg.getVariableAsInteger(5L);
        this.primaryIP = msg.getVariableAsInetAddress(8L);
        this.isDeleted = msg.getVariableAsBoolean(30L);
        this.status = msg.getVariableAsInteger(10L);
        this.comments = msg.getVariableAsString(82L);
        this.geolocation = new GeoLocation(msg);
        this.image = msg.getVariableAsUUID(379L);
        this.submapId = msg.getVariableAsInt64(389L);
        if (this.image == null) {
            this.image = NXCommon.EMPTY_GUID;
        }
        this.statusCalculationMethod = msg.getVariableAsInteger(160L);
        this.statusPropagationMethod = msg.getVariableAsInteger(183L);
        this.fixedPropagatedStatus = msg.getVariableAsInteger(184L);
        this.statusShift = msg.getVariableAsInteger(185L);
        this.statusTransformation = new int[4];
        this.statusTransformation[0] = msg.getVariableAsInteger(186L);
        this.statusTransformation[1] = msg.getVariableAsInteger(187L);
        this.statusTransformation[2] = msg.getVariableAsInteger(188L);
        this.statusTransformation[3] = msg.getVariableAsInteger(189L);
        this.statusSingleThreshold = msg.getVariableAsInteger(190L);
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = msg.getVariableAsInteger(191L);
        this.statusThresholds[1] = msg.getVariableAsInteger(192L);
        this.statusThresholds[2] = msg.getVariableAsInteger(193L);
        this.statusThresholds[3] = msg.getVariableAsInteger(194L);
        if (this.statusShift > Short.MAX_VALUE) {
            this.statusShift -= 65536;
        }
        int count = msg.getVariableAsInteger(7L);
        int i = 0;
        long id = 12288L;
        while (i < count) {
            this.parents.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getVariableAsInteger(31L);
        i = 0;
        id = 0x80000000L;
        while (i < count) {
            this.childs.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getVariableAsInteger(306L);
        if (count > 0) {
            Long[] nodes = msg.getVariableAsUInt32ArrayEx(307L);
            this.trustedNodes.addAll(Arrays.asList(nodes));
        }
        i = 0;
        id = 0x80000000L;
        while (i < count) {
            this.childs.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getVariableAsInteger(309L);
        i = 0;
        id = 0x70000000L;
        while (i < count) {
            this.customAttributes.put(msg.getVariableAsString(id), msg.getVariableAsString(id + 1L));
            ++i;
            id += 2L;
        }
        this.inheritAccessRights = msg.getVariableAsBoolean(33L);
        count = msg.getVariableAsInteger(32L);
        i = 0;
        id = 4096L;
        long id2 = 8192L;
        while (i < count) {
            this.accessList.add(new AccessListElement(msg.getVariableAsInt64(id), msg.getVariableAsInteger(id2)));
            ++i;
            ++id;
            ++id2;
        }
    }

    public boolean isDefaultImage() {
        return this.image.equals(NXCommon.EMPTY_GUID);
    }

    public Iterator<Long> getParents() {
        return this.parents.iterator();
    }

    public Iterator<Long> getChilds() {
        return this.childs.iterator();
    }

    public AccessListElement[] getAccessList() {
        return this.accessList.toArray(new AccessListElement[this.accessList.size()]);
    }

    public String getComments() {
        return this.comments;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public InetAddress getPrimaryIP() {
        return this.primaryIP;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isInheritAccessRights() {
        return this.inheritAccessRights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChildOf(long objectId) {
        boolean rc = false;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            for (long id : this.parents) {
                if (id == objectId) {
                    rc = true;
                    break;
                }
                GenericObject object = this.session.findObjectById(id);
                if (object == null || !object.isChildOf(objectId)) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    public boolean isChildOf(long[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (!this.isChildOf(objects[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectChildOf(long objectId) {
        boolean rc = false;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            for (long id : this.parents) {
                if (id != objectId) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject[] getParentsAsArray() {
        HashSet<GenericObject> list;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            list = new HashSet<GenericObject>(this.childs.size());
            Iterator<Long> it = this.parents.iterator();
            while (it.hasNext()) {
                GenericObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                list.add(obj);
            }
        }
        return list.toArray(new GenericObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject[] getChildsAsArray() {
        HashSet<GenericObject> list;
        HashSet<Long> hashSet = this.childs;
        synchronized (hashSet) {
            list = new HashSet<GenericObject>(this.childs.size());
            Iterator<Long> it = this.childs.iterator();
            while (it.hasNext()) {
                GenericObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                list.add(obj);
            }
        }
        return list.toArray(new GenericObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getChildIdList() {
        long[] list;
        HashSet<Long> hashSet = this.childs;
        synchronized (hashSet) {
            list = new long[this.childs.size()];
            int i = 0;
            for (Long id : this.childs) {
                list[i++] = id;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getParentIdList() {
        long[] list;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            list = new long[this.parents.size()];
            int i = 0;
            for (Long id : this.parents) {
                list[i++] = id;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllChildsInternal(int classFilter, Set<GenericObject> set) {
        HashSet<Long> hashSet = this.childs;
        synchronized (hashSet) {
            Iterator<Long> it = this.childs.iterator();
            while (it.hasNext()) {
                GenericObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                if (classFilter == -1 || obj.getObjectClass() == classFilter) {
                    set.add(obj);
                }
                obj.getAllChildsInternal(classFilter, set);
            }
        }
    }

    public Set<GenericObject> getAllChilds(int classFilter) {
        HashSet<GenericObject> result = new HashSet<GenericObject>();
        this.getAllChildsInternal(classFilter, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject[] getTrustedNodes() {
        GenericObject[] list;
        HashSet<Long> hashSet = this.trustedNodes;
        synchronized (hashSet) {
            list = new GenericObject[this.trustedNodes.size()];
            Iterator<Long> it = this.trustedNodes.iterator();
            int i = 0;
            while (it.hasNext()) {
                list[i] = this.session.findObjectById(it.next());
                ++i;
            }
        }
        return list;
    }

    public int getNumberOfParents() {
        return this.parents.size();
    }

    public int getNumberOfChilds() {
        return this.childs.size();
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        return "Class " + Integer.toString(this.objectClass);
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public GeoLocation getGeolocation() {
        return this.geolocation;
    }

    public int hashCode() {
        return (int)this.objectId;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public UUID getImage() {
        return this.image;
    }

    public long getSubmapId() {
        return this.submapId;
    }

    public int getStatusCalculationMethod() {
        return this.statusCalculationMethod;
    }

    public int getStatusPropagationMethod() {
        return this.statusPropagationMethod;
    }

    public int getFixedPropagatedStatus() {
        return this.fixedPropagatedStatus;
    }

    public int getStatusShift() {
        return this.statusShift;
    }

    public int[] getStatusTransformation() {
        return this.statusTransformation;
    }

    public int getStatusSingleThreshold() {
        return this.statusSingleThreshold;
    }

    public int[] getStatusThresholds() {
        return this.statusThresholds;
    }
}

