/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.net.InetAddress;
import java.util.Date;
import org.netxms.base.NXCPMessage;

public class SnmpTrapLogRecord {
    private long id;
    private Date timestamp;
    private InetAddress sourceAddress;
    private long sourceNode;
    private String trapObjectId;
    private String varbinds;

    public SnmpTrapLogRecord(NXCPMessage msg, long baseId) {
        this.id = msg.getVariableAsInt64(baseId);
        this.timestamp = msg.getVariableAsDate(baseId + 1L);
        this.sourceAddress = msg.getVariableAsInetAddress(baseId + 2L);
        this.sourceNode = msg.getVariableAsInt64(baseId + 3L);
        this.trapObjectId = msg.getVariableAsString(baseId + 4L);
        this.varbinds = msg.getVariableAsString(baseId + 5L);
    }

    public long getId() {
        return this.id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public long getSourceNode() {
        return this.sourceNode;
    }

    public String getTrapObjectId() {
        return this.trapObjectId;
    }

    public String getVarbinds() {
        return this.varbinds;
    }
}

