/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.widgets.DciList;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;

public class SelectDciDialog
extends Dialog {
    private SashForm splitter;
    private ObjectTree objectTree;
    private DciList dciList;
    private DciValue selection;
    private int dcObjectType = -1;

    public SelectDciDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select DCI");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectDciDialog.cx"), settings.getInt("SelectDciDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            newShell.setSize(600, 350);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        this.splitter = new SashForm(dialogArea, 256);
        this.objectTree = new ObjectTree((Composite)this.splitter, 2048, 0, null, ObjectSelectionDialog.createNodeSelectionFilter());
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        String text = settings.get("SelectDciDialog.Filter");
        if (text != null) {
            this.objectTree.setFilter(text);
        }
        this.dciList = new DciList(null, (Composite)this.splitter, 2048, null, "SelectDciDialog.dciList", this.dcObjectType);
        this.dciList.setDcObjectType(this.dcObjectType);
        this.dciList.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectDciDialog.this.okPressed();
            }
        });
        try {
            int[] weights = new int[]{settings.getInt("SelectDciDialog.weight1"), settings.getInt("SelectDciDialog.weight2")};
            this.splitter.setWeights(weights);
        }
        catch (NumberFormatException numberFormatException) {
            this.splitter.setWeights(new int[]{30, 70});
        }
        this.objectTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenericObject object = SelectDciDialog.this.objectTree.getFirstSelectedObject2();
                if (object != null && object instanceof Node) {
                    SelectDciDialog.this.dciList.setNode((Node)object);
                } else {
                    SelectDciDialog.this.dciList.setNode(null);
                }
            }
        });
        return dialogArea;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectDciDialog.cx", size.x);
        settings.put("SelectDciDialog.cy", size.y);
        settings.put("SelectDciDialog.Filter", this.objectTree.getFilter());
        int[] weights = this.splitter.getWeights();
        settings.put("SelectDciDialog.weight1", weights[0]);
        settings.put("SelectDciDialog.weight2", weights[1]);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selection = this.dciList.getSelection();
        if (this.selection == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select DCI fro the list and then press OK");
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    public DciValue getSelection() {
        return this.selection;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        if (this.dciList != null) {
            this.dciList.setDcObjectType(dcObjectType);
        }
    }
}

