/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.filemanager.widgets.LocalFileSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ImportDashboardDialog
extends Dialog {
    private String objectName;
    private File importFile;
    private LabeledText textName;
    private LocalFileSelector importFileSelector;

    public ImportDashboardDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import Dashboard");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel("Object name");
        this.textName.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.textName.setLayoutData((Object)gd);
        this.importFileSelector = new LocalFileSelector(dialogArea, 0, false);
        this.importFileSelector.setLabel("Import file");
        this.importFileSelector.setFilterExtensions(new String[]{"*.xml", "*.*"});
        this.importFileSelector.setFilterNames(new String[]{"XML files", "All files"});
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.importFileSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.objectName = this.textName.getText().trim();
        if (this.objectName.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter valid object name");
            return;
        }
        this.importFile = this.importFileSelector.getFile();
        if (this.importFile == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select import file");
            return;
        }
        super.okPressed();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public File getImportFile() {
        return this.importFile;
    }
}

