/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.api.client.servermanager.ServerManager;
import org.netxms.api.client.servermanager.ServerVariable;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.dialogs.VariableEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.ServerConfigurationEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EditVariable
implements IObjectActionDelegate {
    private IWorkbenchPart wbPart;
    private Object[] currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }

    public void run(IAction action) {
        if (this.currentSelection.length == 1) {
            ServerVariable var = (ServerVariable)this.currentSelection[0];
            final VariableEditDialog dlg = new VariableEditDialog(this.wbPart.getSite().getShell(), var.getName(), var.getValue());
            if (dlg.open() == 0) {
                final ServerManager sm = (ServerManager)ConsoleSharedData.getSession();
                new ConsoleJob("Modify configuration variable", this.wbPart, "org.netxms.ui.eclipse.serverconfig", "ServerConfigJob"){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        sm.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                        if (EditVariable.this.wbPart instanceof ServerConfigurationEditor) {
                            ((ServerConfigurationEditor)EditVariable.this.wbPart).refreshViewer();
                        }
                    }

                    protected String getErrorMessage() {
                        return "Cannot modify configuration variable";
                    }
                }.start();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentSelection = ((IStructuredSelection)selection).toArray();
        }
    }
}

