/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.widgets.LogParserEditor;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserModifyListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class SyslogParserConfigurator
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.SyslogParserConfigurator";
    private NXCSession session;
    private LogParserEditor editor;
    private boolean modified = false;
    private String content;
    private Action actionRefresh;
    private Action actionSave;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        this.editor = new LogParserEditor(parent, 0);
        this.editor.addModifyListener(new LogParserModifyListener(){

            @Override
            public void modifyParser() {
                SyslogParserConfigurator.this.setModified(true);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                SyslogParserConfigurator.this.refresh();
            }
        };
        this.actionSave = new Action("&Save", SharedIcons.SAVE){

            public void run() {
                SyslogParserConfigurator.this.save();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        this.editor.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SyslogParserConfigurator.this.content = SyslogParserConfigurator.this.editor.getParserXml();
            }
        });
        try {
            this.session.setServerConfigClob("SyslogParser", this.content);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Cannot save syslog parser configuration: " + e.getLocalizedMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void refresh() {
        if (this.modified && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Confirm Refresh", (String)"This will destroy all unsaved changes. Are you sure?")) {
            return;
        }
        this.actionSave.setEnabled(false);
        new ConsoleJob("Load syslog parser configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    SyslogParserConfigurator.this.content = SyslogParserConfigurator.this.session.getServerConfigClob("SyslogParser");
                }
                catch (NXCException e) {
                    if (e.getErrorCode() != 81) {
                        throw e;
                    }
                    SyslogParserConfigurator.this.content = "<parser>\n</parser>\n";
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SyslogParserConfigurator.this.editor.setParserXml(SyslogParserConfigurator.this.content);
                        SyslogParserConfigurator.this.setModified(false);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load syslog parser configuration";
            }
        }.start();
    }

    private void save() {
        final String xml = this.editor.getParserXml();
        System.out.println(xml);
        this.actionSave.setEnabled(false);
        new ConsoleJob("Save syslog parser configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SyslogParserConfigurator.this.session.setServerConfigClob("SyslogParser", xml);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SyslogParserConfigurator.this.setModified(false);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot save syslog parser configuration";
            }
        }.start();
    }

    private void setModified(boolean b) {
        if (b != this.modified) {
            this.modified = b;
            this.firePropertyChange(257);
            this.actionSave.setEnabled(this.modified);
        }
    }
}

