/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.model.ContributionComparator;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.BrandingManager;
import org.netxms.ui.eclipse.console.ExtendedContributionComparator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.NXMCWorkbenchWindowAdvisor;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class NXMCWorkbenchAdvisor
extends WorkbenchAdvisor {
    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new NXMCWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        String p = BrandingManager.getInstance().getDefaultPerspective();
        if (p != null) {
            return p;
        }
        return Activator.getDefault().getPreferenceStore().getString("INITIAL_PERSPECTIVE");
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        TweakletManager.initTweaklets();
        BrandingManager.create();
        final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        configurer.setSaveAndRestore(ps.getBoolean("SAVE_AND_RESTORE"));
        if (ps.getBoolean("HTTP_PROXY_ENABLED")) {
            System.setProperty("http.proxyHost", ps.getString("HTTP_PROXY_SERVER"));
            System.setProperty("http.proxyPort", ps.getString("HTTP_PROXY_PORT"));
            System.setProperty("http.noProxyHosts", ps.getString("HTTP_PROXY_EXCLUSIONS"));
            if (ps.getBoolean("HTTP_PROXY_AUTH")) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ps.getString("HTTP_PROXY_LOGIN"), ps.getString("HTTP_PROXY_PASSWORD").toCharArray());
                    }
                });
            }
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("http.noProxyHosts");
        }
    }

    public ContributionComparator getComparatorFor(String contributionType) {
        if (contributionType.equals("property")) {
            return new ExtendedContributionComparator();
        }
        return super.getComparatorFor(contributionType);
    }

    public void postStartup() {
        super.postStartup();
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellIconified(ShellEvent e) {
                if (Activator.getDefault().getPreferenceStore().getBoolean("HIDE_WHEN_MINIMIZED")) {
                    shell.setVisible(false);
                }
            }
        });
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        session.addListener(new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 1 || n.getCode() == 1001) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("NXMCWorkbenchAdvisor.CommunicationError"), (String)(String.valueOf(n.getCode() == 1 ? Messages.getString("NXMCWorkbenchAdvisor.ConnectionLostMessage") : Messages.getString("NXMCWorkbenchAdvisor.ServerShutdownMessage")) + Messages.getString("NXMCWorkbenchAdvisor.OKToCloseMessage")));
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().close();
                        }
                    });
                }
            }
        });
    }
}

