/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.tools.NumericTextFieldValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class EditThresholdDialog
extends Dialog {
    private Threshold threshold;
    private Combo function;
    private Combo operation;
    private Text samples;
    private Text value;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private Text repeatInterval;
    private Button repeatDefault;
    private Button repeatNever;
    private Button repeatCustom;

    public EditThresholdDialog(Shell parentShell, Threshold threshold) {
        super(parentShell);
        this.threshold = threshold;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        RowLayout dialogLayout = new RowLayout();
        dialogLayout.type = 512;
        dialogLayout.fill = true;
        dialogArea.setLayout((Layout)dialogLayout);
        Group condGroup = new Group(dialogArea, 0);
        condGroup.setText("Condition");
        GridLayout condLayout = new GridLayout();
        condLayout.numColumns = 2;
        condGroup.setLayout((Layout)condLayout);
        this.function = WidgetHelper.createLabeledCombo((Composite)condGroup, (int)2060, (String)"Function", (Object)"WidgetHelper::default_layout_data");
        this.function.add("Last polled value");
        this.function.add("Average value");
        this.function.add("Mean deviation");
        this.function.add("Diff with previous value");
        this.function.add("Data collection error");
        this.function.add("Sum of values");
        this.function.select(this.threshold.getFunction());
        this.samples = WidgetHelper.createLabeledText((Composite)condGroup, (int)2048, (int)60, (String)"Samples", (String)Integer.toString(this.threshold.getArg1()), (Object)"WidgetHelper::default_layout_data");
        this.samples.setTextLimit(5);
        this.operation = WidgetHelper.createLabeledCombo((Composite)condGroup, (int)2060, (String)"Function", (Object)"WidgetHelper::default_layout_data");
        this.operation.add("<  : less then");
        this.operation.add("<= : less then or equal to");
        this.operation.add("== : equal to");
        this.operation.add(">= : great then or equal to");
        this.operation.add(">  : greater then");
        this.operation.add("!= : not equal to");
        this.operation.add("like");
        this.operation.add("not like");
        this.operation.select(this.threshold.getOperation());
        this.value = WidgetHelper.createLabeledText((Composite)condGroup, (int)2048, (int)120, (String)"Value", (String)this.threshold.getValue(), (Object)"WidgetHelper::default_layout_data");
        Group eventGroup = new Group(dialogArea, 0);
        eventGroup.setText("Event");
        GridLayout eventLayout = new GridLayout();
        eventGroup.setLayout((Layout)eventLayout);
        this.activationEvent = new EventSelector((Composite)eventGroup, 0);
        this.activationEvent.setLabel("Activation event");
        this.activationEvent.setEventCode((long)this.threshold.getFireEvent());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.activationEvent.setLayoutData((Object)gd);
        this.deactivationEvent = new EventSelector((Composite)eventGroup, 0);
        this.deactivationEvent.setLabel("Deactivation event");
        this.deactivationEvent.setEventCode((long)this.threshold.getRearmEvent());
        this.deactivationEvent.setLayoutData((Object)gd);
        Group repeatGroup = new Group(dialogArea, 0);
        repeatGroup.setText("Repeat event");
        GridLayout repeatLayout = new GridLayout();
        repeatLayout.numColumns = 3;
        repeatGroup.setLayout((Layout)repeatLayout);
        this.repeatDefault = new Button((Composite)repeatGroup, 16);
        this.repeatDefault.setText("Use &default settings");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatDefault.setLayoutData((Object)gd);
        this.repeatDefault.setSelection(this.threshold.getRepeatInterval() == -1);
        this.repeatNever = new Button((Composite)repeatGroup, 16);
        this.repeatNever.setText("&Never");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatNever.setLayoutData((Object)gd);
        this.repeatNever.setSelection(this.threshold.getRepeatInterval() == 0);
        this.repeatCustom = new Button((Composite)repeatGroup, 16);
        this.repeatCustom.setText("&Every");
        this.repeatCustom.setSelection(this.threshold.getRepeatInterval() > 0);
        this.repeatCustom.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                EditThresholdDialog.this.repeatInterval.setEnabled(EditThresholdDialog.this.repeatCustom.getSelection());
            }
        });
        this.repeatInterval = new Text((Composite)repeatGroup, 2048);
        this.repeatInterval.setTextLimit(5);
        this.repeatInterval.setText(this.threshold.getRepeatInterval() > 0 ? Integer.toString(this.threshold.getRepeatInterval()) : "3600");
        this.repeatInterval.setEnabled(this.threshold.getRepeatInterval() > 0);
        new Label((Composite)repeatGroup, 0).setText("seconds");
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Threshold");
    }

    protected void okPressed() {
        int rpt;
        if (!WidgetHelper.validateTextInput((Text)this.samples, (String)"Samples", (TextFieldValidator)new NumericTextFieldValidator(1L, 1000L), null)) {
            return;
        }
        if (this.repeatDefault.getSelection()) {
            rpt = -1;
        } else if (this.repeatNever.getSelection()) {
            rpt = 0;
        } else {
            if (!WidgetHelper.validateTextInput((Text)this.repeatInterval, (String)"Repeat Interval", (TextFieldValidator)new NumericTextFieldValidator(1L, 1000000L), null)) {
                return;
            }
            rpt = Integer.parseInt(this.repeatInterval.getText());
        }
        this.threshold.setFunction(this.function.getSelectionIndex());
        this.threshold.setOperation(this.operation.getSelectionIndex());
        this.threshold.setValue(this.value.getText());
        this.threshold.setArg1(Integer.parseInt(this.samples.getText()));
        this.threshold.setRepeatInterval(rpt);
        this.threshold.setFireEvent((int)this.activationEvent.getEventCode());
        this.threshold.setRearmEvent((int)this.deactivationEvent.getEventCode());
        super.okPressed();
    }
}

