/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.NumericTextFieldValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class GeneralTable
extends PropertyPage {
    private DataCollectionTable dci;
    private GenericObject owner;
    private Cluster cluster = null;
    private Map<Integer, Long> clusterResourceMap;
    private Text description;
    private LabeledText parameter;
    private Button selectButton;
    private Combo origin;
    private Button checkUseCustomSnmpPort;
    private Text customSnmpPort;
    private ObjectSelector proxyNode;
    private Combo schedulingMode;
    private LabeledText pollingInterval;
    private LabeledText retentionTime;
    private Combo clusterResource;
    private Button statusActive;
    private Button statusDisabled;
    private Button statusUnsupported;

    protected Control createContents(Composite parent) {
        this.dci = (DataCollectionTable)this.getElement().getAdapter(DataCollectionTable.class);
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        this.owner = session.findObjectById(this.dci.getNodeId());
        if (this.owner instanceof Cluster) {
            this.cluster = (Cluster)this.owner;
        } else if (this.owner instanceof Node) {
            GenericObject[] genericObjectArray = this.owner.getParentsAsArray();
            int n = genericObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericObject o = genericObjectArray[n2];
                if (o instanceof Cluster) {
                    this.cluster = (Cluster)o;
                    break;
                }
                ++n2;
            }
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group groupDescription = new Group(dialogArea, 0);
        groupDescription.setText("Description");
        FillLayout descriptionLayout = new FillLayout();
        descriptionLayout.marginWidth = 4;
        descriptionLayout.marginHeight = 4;
        groupDescription.setLayout((Layout)descriptionLayout);
        this.description = new Text((Composite)groupDescription, 2048);
        this.description.setTextLimit(255);
        this.description.setText(this.dci.getDescription());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupDescription.setLayoutData((Object)gd);
        Group groupData = new Group(dialogArea, 0);
        groupData.setText("Data");
        FormLayout dataLayout = new FormLayout();
        dataLayout.marginHeight = 4;
        dataLayout.marginWidth = 4;
        groupData.setLayout((Layout)dataLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupData.setLayoutData((Object)gd);
        this.parameter = new LabeledText((Composite)groupData, 0);
        this.parameter.setLabel("Parameter");
        this.parameter.getTextControl().setTextLimit(255);
        this.parameter.setText(this.dci.getName());
        this.selectButton = new Button((Composite)groupData, 8);
        this.selectButton.setText("&Select...");
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.selectParameter();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.selectButton, -2, 16384);
        this.parameter.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.parameter, 0, 1024);
        fd.width = 90;
        this.selectButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(50, -2);
        this.origin = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)"Origin", (Object)fd);
        this.origin.add("Internal");
        this.origin.add("NetXMS Agent");
        this.origin.add("SNMP");
        this.origin.add("Check Point SNMP");
        this.origin.add("Push");
        this.origin.select(this.dci.getOrigin());
        this.origin.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.onOriginChange();
            }
        });
        this.checkUseCustomSnmpPort = new Button((Composite)groupData, 32);
        this.checkUseCustomSnmpPort.setText("Use custom SNMP port:");
        this.checkUseCustomSnmpPort.setSelection(this.dci.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.customSnmpPort.setEnabled(GeneralTable.this.checkUseCustomSnmpPort.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        this.checkUseCustomSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort.setEnabled(this.dci.getOrigin() == 2);
        this.customSnmpPort = new Text((Composite)groupData, 2048);
        if (this.dci.getOrigin() == 2 && this.dci.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setText(Integer.toString(this.dci.getSnmpPort()));
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 1024);
        this.customSnmpPort.setLayoutData((Object)fd);
        this.proxyNode = new ObjectSelector((Composite)groupData, 0);
        this.proxyNode.setLabel("Proxy node");
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.origin.getParent(), 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.proxyNode.setLayoutData((Object)fd);
        this.proxyNode.setObjectClass(Node.class);
        this.proxyNode.setObjectId(this.dci.getProxyNode());
        this.proxyNode.setEnabled(this.dci.getOrigin() != 4);
        Group groupPolling = new Group(dialogArea, 0);
        groupPolling.setText("Polling");
        FormLayout pollingLayout = new FormLayout();
        pollingLayout.marginHeight = 4;
        pollingLayout.marginWidth = 4;
        groupPolling.setLayout((Layout)pollingLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupPolling.setLayoutData((Object)gd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(50, -2);
        fd.top = new FormAttachment(0, 0);
        this.schedulingMode = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)"Polling mode", (Object)fd);
        this.schedulingMode.add("Fixed intervals");
        this.schedulingMode.add("Custom schedule");
        this.schedulingMode.select(this.dci.isUseAdvancedSchedule() ? 1 : 0);
        this.schedulingMode.setEnabled(this.dci.getOrigin() != 4);
        this.schedulingMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.pollingInterval.getTextControl().setEnabled(GeneralTable.this.schedulingMode.getSelectionIndex() == 0);
            }
        });
        this.pollingInterval = new LabeledText((Composite)groupPolling, 0);
        this.pollingInterval.getTextControl().setTextLimit(5);
        this.pollingInterval.setLabel("Polling interval (seconds)");
        this.pollingInterval.setText(Integer.toString(this.dci.getPollingInterval()));
        this.pollingInterval.setEnabled(!this.dci.isUseAdvancedSchedule() && this.dci.getOrigin() != 4);
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.pollingInterval.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.schedulingMode.getParent(), 4, 1024);
        this.clusterResource = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)"Associate with cluster resource", (Object)fd);
        if (this.cluster != null) {
            this.clusterResourceMap = new HashMap<Integer, Long>();
            this.clusterResourceMap.put(0, 0L);
            this.clusterResource.add("<none>");
            if (this.dci.getResourceId() == 0L) {
                this.clusterResource.select(0);
            }
            int index = 1;
            for (ClusterResource r : this.cluster.getResources()) {
                this.clusterResource.add(r.getName());
                this.clusterResourceMap.put(index, r.getId());
                if (this.dci.getResourceId() == r.getId()) {
                    this.clusterResource.select(index);
                }
                ++index;
            }
        } else {
            this.clusterResource.add("<none>");
            this.clusterResource.select(0);
            this.clusterResource.setEnabled(false);
        }
        Group groupStatus = new Group(dialogArea, 0);
        groupStatus.setText("Status");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupStatus.setLayoutData((Object)gd);
        RowLayout statusLayout = new RowLayout();
        statusLayout.type = 512;
        groupStatus.setLayout((Layout)statusLayout);
        this.statusActive = new Button((Composite)groupStatus, 16);
        this.statusActive.setText("&Active");
        this.statusActive.setSelection(this.dci.getStatus() == 0);
        this.statusDisabled = new Button((Composite)groupStatus, 16);
        this.statusDisabled.setText("&Disabled");
        this.statusDisabled.setSelection(this.dci.getStatus() == 1);
        this.statusUnsupported = new Button((Composite)groupStatus, 16);
        this.statusUnsupported.setText("&Not supported");
        this.statusUnsupported.setSelection(this.dci.getStatus() == 2);
        Group groupStorage = new Group(dialogArea, 0);
        groupStorage.setText("Storage");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        groupStorage.setLayoutData((Object)gd);
        FillLayout storageLayout = new FillLayout();
        storageLayout.marginWidth = 4;
        storageLayout.marginHeight = 4;
        groupStorage.setLayout((Layout)storageLayout);
        this.retentionTime = new LabeledText((Composite)groupStorage, 0);
        this.retentionTime.setLabel("Retention time (days)");
        this.retentionTime.getTextControl().setTextLimit(5);
        this.retentionTime.setText(Integer.toString(this.dci.getRetentionTime()));
        return dialogArea;
    }

    private void onOriginChange() {
        int index = this.origin.getSelectionIndex();
        this.proxyNode.setEnabled(index != 4);
        this.schedulingMode.setEnabled(index != 4);
        this.pollingInterval.getTextControl().setEnabled(index != 4 && this.schedulingMode.getSelectionIndex() == 0);
        this.checkUseCustomSnmpPort.setEnabled(index == 2);
        this.customSnmpPort.setEnabled(index == 2 && this.checkUseCustomSnmpPort.getSelection());
    }

    private void selectParameter() {
    }

    protected boolean applyChanges(boolean isApply) {
        if (!(WidgetHelper.validateTextInput((Text)this.customSnmpPort, (String)"Custom SNMP port", (TextFieldValidator)new NumericTextFieldValidator(1L, 65535L), (PropertyPage)this) && WidgetHelper.validateTextInput((LabeledText)this.pollingInterval, (TextFieldValidator)new NumericTextFieldValidator(1L, 1000000L), (PropertyPage)this) && WidgetHelper.validateTextInput((LabeledText)this.retentionTime, (TextFieldValidator)new NumericTextFieldValidator(1L, 65535L), (PropertyPage)this))) {
            return false;
        }
        if (isApply) {
            this.setValid(false);
        }
        this.dci.setDescription(this.description.getText().trim());
        this.dci.setName(this.parameter.getText().trim());
        this.dci.setOrigin(this.origin.getSelectionIndex());
        this.dci.setProxyNode(this.proxyNode.getObjectId());
        this.dci.setUseAdvancedSchedule(this.schedulingMode.getSelectionIndex() == 1);
        this.dci.setPollingInterval(Integer.parseInt(this.pollingInterval.getText()));
        this.dci.setRetentionTime(Integer.parseInt(this.retentionTime.getText()));
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dci.setSnmpPort(Integer.parseInt(this.customSnmpPort.getText()));
        } else {
            this.dci.setSnmpPort(0);
        }
        if (this.statusActive.getSelection()) {
            this.dci.setStatus(0);
        } else if (this.statusDisabled.getSelection()) {
            this.dci.setStatus(1);
        } else if (this.statusUnsupported.getSelection()) {
            this.dci.setStatus(2);
        }
        if (this.cluster != null) {
            this.dci.setResourceId(this.clusterResourceMap.get(this.clusterResource.getSelectionIndex()).longValue());
        }
        new ConsoleJob("Update general settings for DCI " + this.dci.getId(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                GeneralTable.this.dci.getOwner().modifyObject((DataCollectionObject)GeneralTable.this.dci);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GeneralTable.this.setValid(true);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot update general DCI settings";
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.schedulingMode.select(0);
        this.pollingInterval.setText("60");
        this.statusActive.setSelection(true);
        this.statusDisabled.setSelection(false);
        this.statusUnsupported.setSelection(false);
        this.retentionTime.setText("30");
        this.checkUseCustomSnmpPort.setSelection(false);
    }
}

