/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import java.text.DateFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.snmp.SnmpTrapLogRecord;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SnmpTrapMonitorLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SnmpTrapLogRecord record = (SnmpTrapLogRecord)element;
        switch (columnIndex) {
            case 0: {
                return DateFormat.getDateTimeInstance(3, 1).format(record.getTimestamp());
            }
            case 1: {
                return record.getSourceAddress().getHostAddress();
            }
            case 2: {
                GenericObject object = this.session.findObjectById(record.getSourceNode());
                return object != null ? object.getObjectName() : "<unknown>";
            }
            case 3: {
                return record.getTrapObjectId();
            }
            case 4: {
                return record.getVarbinds();
            }
        }
        return null;
    }
}

