/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views.helpers;

import java.util.ArrayList;
import java.util.List;
import org.netxms.client.datacollection.GraphSettings;

public class GraphFolder {
    private String name;
    private GraphFolder parent;
    private List<GraphFolder> subfolders;
    private List<GraphSettings> graphs;

    public GraphFolder(String name, GraphFolder parent) {
        this.name = name;
        this.parent = parent;
        this.subfolders = new ArrayList<GraphFolder>();
        this.graphs = new ArrayList<GraphSettings>();
    }

    public String getName() {
        return this.name;
    }

    public GraphFolder getParent() {
        return this.parent;
    }

    public Object[] getChildObjects() {
        Object[] objects = new Object[this.subfolders.size() + this.graphs.size()];
        int index = 0;
        int i = 0;
        while (i < this.subfolders.size()) {
            objects[index++] = this.subfolders.get(i);
            ++i;
        }
        i = 0;
        while (i < this.graphs.size()) {
            objects[index++] = this.graphs.get(i);
            ++i;
        }
        return objects;
    }

    public boolean hasChildren() {
        return this.subfolders.size() > 0 || this.graphs.size() > 0;
    }

    public void addGraph(GraphSettings g) {
        this.graphs.add(g);
    }

    public void addFolder(GraphFolder f) {
        this.subfolders.add(f);
    }
}

