/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.switchmanager.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.switchmanager.views.helpers.Dot1xPortComparator;
import org.netxms.ui.eclipse.switchmanager.views.helpers.Dot1xPortListLabelProvider;
import org.netxms.ui.eclipse.switchmanager.views.helpers.Dot1xPortSummary;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class Dot1xStatusView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.switchmanager.views.Dot1xStatusView";
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_PORT = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_PAE_STATE = 3;
    public static final int COLUMN_BACKEND_STATE = 4;
    private NXCSession session;
    private long rootObject;
    private SortableTableViewer viewer;
    private Action actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.rootObject = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException numberFormatException) {
            this.rootObject = 0L;
        }
        this.session = (NXCSession)ConsoleSharedData.getSession();
        GenericObject object = this.session.findObjectById(this.rootObject);
        this.setPartName("802.1x Port State - " + (object != null ? object.getObjectName() : "<" + this.rootObject + ">"));
    }

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"Device", "Slot/Port", "Interface", "PAE State", "Backend State"};
        int[] widths = new int[]{250, 60, 180, 150, 150};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new Dot1xPortListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new Dot1xPortComparator());
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                Dot1xStatusView.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void refresh() {
        ArrayList<Dot1xPortSummary> portList = new ArrayList<Dot1xPortSummary>();
        HashSet<Long> nodeList = new HashSet<Long>();
        this.fillPortList(portList, nodeList, this.rootObject);
        this.viewer.setInput((Object)portList.toArray());
    }

    private void fillPortList(List<Dot1xPortSummary> portList, Set<Long> nodeList, long root) {
        GenericObject object = this.session.findObjectById(root);
        if (object == null) {
            return;
        }
        if (object instanceof Node && !nodeList.contains(object.getObjectId())) {
            for (GenericObject o : object.getAllChilds(3)) {
                if ((((Interface)o).getFlags() & 2) == 0) continue;
                portList.add(new Dot1xPortSummary((Node)object, (Interface)o));
            }
            nodeList.add(object.getObjectId());
        } else {
            long[] lArray = object.getChildIdList();
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long id = lArray[n2];
                this.fillPortList(portList, nodeList, id);
                ++n2;
            }
        }
    }
}

