/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.dialogs.EditEventTemplateDialog;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateComparator;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class EventConfigurator
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.eventmanager.view.event_configurator";
    public static final String JOB_FAMILY = "EventConfiguratorJob";
    private static final String TABLE_CONFIG_PREFIX = "EventTemplateList";
    public static final int COLUMN_CODE = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_FLAGS = 3;
    public static final int COLUMN_MESSAGE = 4;
    public static final int COLUMN_DESCRIPTION = 5;
    private HashMap<Long, EventTemplate> eventTemplates;
    private SortableTableViewer viewer;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private RefreshAction actionRefresh;
    private NXCSession session;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] names = new String[]{"Code", "Name", "Severity", "Flags", "Message", "Description"};
        int[] widths = new int[]{70, 200, 90, 50, 400, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EventTemplateLabelProvider());
        this.viewer.setComparator((ViewerComparator)new EventTemplateComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    EventConfigurator.this.actionEdit.setEnabled(selection.size() == 1);
                    EventConfigurator.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EventConfigurator.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)EventConfigurator.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)EventConfigurator.TABLE_CONFIG_PREFIX);
            }
        });
        this.makeActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refreshView();
        this.session.addListener((SessionListener)this);
    }

    private void refreshView() {
        new ConsoleJob("Open event configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot open event configuration";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = EventConfigurator.this.session.getEventTemplates();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventConfigurator.this.eventTemplates = new HashMap(list.size());
                        for (EventTemplate t : list) {
                            EventConfigurator.this.eventTemplates.put(t.getCode(), t);
                        }
                        EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                    }
                });
            }
        }.start();
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1013: {
                new UIJob(this.viewer.getControl().getDisplay(), "Update event template list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        EventTemplate oldTmpl = (EventTemplate)EventConfigurator.this.eventTemplates.get(n.getSubCode());
                        if (oldTmpl != null) {
                            oldTmpl.setAll((EventTemplate)n.getObject());
                            EventConfigurator.this.viewer.update((Object)oldTmpl, null);
                        } else {
                            EventConfigurator.this.eventTemplates.put(n.getSubCode(), (EventTemplate)n.getObject());
                            EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                break;
            }
            case 1014: {
                new UIJob(this.viewer.getControl().getDisplay(), "Remove event template from list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        EventConfigurator.this.eventTemplates.remove(n.getSubCode());
                        EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void makeActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                EventConfigurator.this.refreshView();
            }
        };
        this.actionNew = new Action(){

            public void run() {
                EventConfigurator.this.createNewEventTemplate();
            }
        };
        this.actionNew.setText("&New event template...");
        this.actionNew.setImageDescriptor(Activator.getImageDescriptor("icons/new.png"));
        this.actionEdit = new Action(){

            public void run() {
                EventConfigurator.this.editEventTemplate();
            }
        };
        this.actionEdit.setText("&Properties...");
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionEdit.setEnabled(false);
        this.actionDelete = new Action(){

            public void run() {
                EventConfigurator.this.deleteEventTemplate();
            }
        };
        this.actionDelete.setText("&Delete");
        this.actionDelete.setImageDescriptor(Activator.getImageDescriptor("icons/delete.png"));
        this.actionDelete.setEnabled(false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EventConfigurator.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEdit);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void createNewEventTemplate() {
        final EventTemplate etmpl = new EventTemplate(0L);
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getSite().getShell(), etmpl, false);
        if (dlg.open() == 0) {
            new ConsoleJob("Create new event template", (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

                protected String getErrorMessage() {
                    return "Cannot create new event template";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long code = EventConfigurator.this.session.generateEventCode();
                    etmpl.setCode(code);
                    EventConfigurator.this.session.modifyEventTemplate(etmpl);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            EventConfigurator.this.eventTemplates.put(etmpl.getCode(), etmpl);
                            EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                            EventConfigurator.this.viewer.setSelection((ISelection)new StructuredSelection((Object)etmpl), true);
                        }
                    });
                }
            }.start();
        }
    }

    protected void editEventTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final EventTemplate etmpl = new EventTemplate((EventTemplate)selection.getFirstElement());
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getSite().getShell(), etmpl, false);
        if (dlg.open() == 0) {
            new ConsoleJob("Update event template", (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

                protected String getErrorMessage() {
                    return "Cannot update event template";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    EventConfigurator.this.session.modifyEventTemplate(etmpl);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            EventConfigurator.this.eventTemplates.put(etmpl.getCode(), etmpl);
                            EventConfigurator.this.viewer.setInput(EventConfigurator.this.eventTemplates.values());
                            EventConfigurator.this.viewer.setSelection((ISelection)new StructuredSelection((Object)etmpl));
                        }
                    });
                }
            }.start();
        }
    }

    protected void deleteEventTemplate() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        String message = "Do you really wish to delete selected event template" + (selection.size() > 1 ? "s?" : "?");
        Shell shell = this.getViewSite().getShell();
        if (!MessageDialog.openQuestion((Shell)shell, (String)"Confirm event template deletion", (String)message)) {
            return;
        }
        new ConsoleJob("Delete event templates", (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot delete event template";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    EventConfigurator.this.session.deleteEventTemplate(((EventTemplate)it.next()).getCode());
                }
            }
        }.start();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }
}

