/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.views.helpers;

import java.text.DateFormat;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.events.SyslogRecord;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SyslogLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS = new Color[]{FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_LIGHT};
    private static final int[] severityMap;
    private static final String[] severityText;
    private static final String[] facilityText;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private boolean showColor = true;
    private boolean showIcons = false;

    static {
        int[] nArray = new int[8];
        nArray[0] = 4;
        nArray[1] = 4;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 1;
        severityMap = nArray;
        severityText = new String[]{"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Informational", "Debug"};
        facilityText = new String[]{"Kernel", "User", "Mail", "System", "Auth", "Syslog", "Lpr", "News", "UUCP", "Cron", "Security", "FTPD", "NTP", "Log Audit", "Log Alert", "Clock", "Local0", "Local1", "Local2", "Local3", "Local4", "Local5", "Local6", "Local7"};
    }

    public Color getForeground(Object element) {
        return this.showColor ? FOREGROUND_COLORS[severityMap[((SyslogRecord)element).getSeverity()]] : null;
    }

    public Color getBackground(Object element) {
        return this.showColor ? StatusDisplayInfo.getStatusColor((int)severityMap[((SyslogRecord)element).getSeverity()]) : null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.showIcons && columnIndex == 0) {
            return StatusDisplayInfo.getStatusImage((int)severityMap[((SyslogRecord)element).getSeverity()]);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SyslogRecord record = (SyslogRecord)element;
        switch (columnIndex) {
            case 0: {
                return DateFormat.getDateTimeInstance(3, 1).format(record.getTimestamp());
            }
            case 1: {
                GenericObject object = this.session.findObjectById(record.getSourceObjectId());
                return object != null ? object.getObjectName() : "<unknown>";
            }
            case 2: {
                try {
                    return severityText[record.getSeverity()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "<" + Integer.toString(record.getSeverity()) + ">";
                }
            }
            case 3: {
                try {
                    return facilityText[record.getFacility()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "<" + Integer.toString(record.getFacility()) + ">";
                }
            }
            case 6: {
                return record.getMessage();
            }
            case 5: {
                return record.getTag();
            }
            case 4: {
                return record.getHostname();
            }
        }
        return null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
    }
}

