/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.SetInterfaceExpStateDlg;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ChangeInterfaceExpectedState
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private List<Interface> objects = new ArrayList<Interface>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        if (this.objects.size() == 0) {
            return;
        }
        SetInterfaceExpStateDlg dlg = new SetInterfaceExpStateDlg(this.shell);
        if (dlg.open() != 0) {
            return;
        }
        final long[] idList = new long[this.objects.size()];
        int i = 0;
        while (i < idList.length) {
            idList[i] = this.objects.get(i).getObjectId();
            ++i;
        }
        final int newState = dlg.getExpectedState();
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update expected state for interfaces", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < idList.length) {
                    NXCObjectModificationData md = new NXCObjectModificationData(idList[i]);
                    md.setExpectedState(newState);
                    session.modifyObject(md);
                    ++i;
                }
            }

            protected String getErrorMessage() {
                return "Cannot update expected state for interface object";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.objects.clear();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof Interface)) continue;
                this.objects.add((Interface)o);
            }
            action.setEnabled(this.objects.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }
}

