/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.net.Inet4Address;
import java.net.InetAddress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateNodeDialog
extends Dialog {
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private LabeledText objectNameField;
    private LabeledText hostNameField;
    private Spinner agentPortField;
    private Spinner snmpPortField;
    private Button checkUnmanaged;
    private Button checkDisableAgent;
    private Button checkDisableSNMP;
    private Button checkDisablePing;
    private ObjectSelector agentProxySelector;
    private ObjectSelector snmpProxySelector;
    private ObjectSelector zoneSelector;
    private String objectName;
    private String hostName;
    private int creationFlags;
    private long agentProxy;
    private long snmpProxy;
    private long zoneId = 0L;
    private int agentPort;
    private int snmpPort;

    public CreateNodeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Node Object");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectNameField = new LabeledText(dialogArea, 0);
        this.objectNameField.setLabel("Name");
        this.objectNameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.objectNameField.setLayoutData((Object)gd);
        Composite ipAddrGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        ipAddrGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        ipAddrGroup.setLayoutData((Object)gd);
        this.hostNameField = new LabeledText(ipAddrGroup, 0);
        this.hostNameField.setLabel("Primary host name or IP address");
        this.hostNameField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.hostNameField.setLayoutData((Object)gd);
        Button resolve = new Button(ipAddrGroup, 8);
        resolve.setText("&Resolve");
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 1024;
        resolve.setLayoutData((Object)gd);
        resolve.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateNodeDialog.this.resolveName();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.agentPortField = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)"NetXMS agent port", (int)1, (int)65535, (Object)"WidgetHelper::default_layout_data");
        this.agentPortField.setSelection(4700);
        this.snmpPortField = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)"SNMP agent port", (int)1, (int)65535, (Object)"WidgetHelper::default_layout_data");
        this.snmpPortField.setSelection(161);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText("Options");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        optionsGroup.setLayout((Layout)new RowLayout(512));
        this.checkUnmanaged = new Button((Composite)optionsGroup, 32);
        this.checkUnmanaged.setText("Create as &unmanaged object");
        this.checkDisableAgent = new Button((Composite)optionsGroup, 32);
        this.checkDisableAgent.setText("Disable usage of NetXMS &agent for all polls");
        this.checkDisableSNMP = new Button((Composite)optionsGroup, 32);
        this.checkDisableSNMP.setText("Disable usage of &SNMP for all polls");
        this.checkDisablePing = new Button((Composite)optionsGroup, 32);
        this.checkDisablePing.setText("Disable usage of &ICMP ping for all polls");
        this.agentProxySelector = new ObjectSelector(dialogArea, 0);
        this.agentProxySelector.setLabel("Proxy for NetXMS agent");
        this.agentProxySelector.setObjectClass(Node.class);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.agentProxySelector.setLayoutData((Object)gd);
        this.snmpProxySelector = new ObjectSelector(dialogArea, 0);
        this.snmpProxySelector.setLabel("Proxy for SNMP");
        this.snmpProxySelector.setObjectClass(Node.class);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.snmpProxySelector.setLayoutData((Object)gd);
        if (this.session.isZoningEnabled()) {
            this.zoneSelector = new ObjectSelector(dialogArea, 0);
            this.zoneSelector.setLabel("Zone");
            this.zoneSelector.setObjectClass(Zone.class);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.zoneSelector.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void okPressed() {
        long zoneObjectId;
        GenericObject object;
        this.hostName = this.hostNameField.getText().trim();
        if (this.hostName.isEmpty()) {
            this.hostName = this.objectNameField.getText().trim();
        }
        if (!this.hostName.matches("^([A-Za-z0-9\\-]+\\.)*[A-Za-z0-9\\-]+$")) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)("String \"" + this.hostName + "\" is not a valid host name or IP address. Please enter valid host name or IP address as primary host name"));
            return;
        }
        this.objectName = this.objectNameField.getText().trim();
        if (this.objectName.isEmpty()) {
            this.objectName = this.hostName;
        }
        this.creationFlags = 0;
        if (this.checkUnmanaged.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_CREATE_UNMANAGED;
        }
        if (this.checkDisableAgent.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_NXCP;
        }
        if (this.checkDisablePing.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_ICMP;
        }
        if (this.checkDisableSNMP.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_SNMP;
        }
        this.agentPort = this.agentPortField.getSelection();
        this.snmpPort = this.snmpPortField.getSelection();
        this.agentProxy = this.agentProxySelector.getObjectId();
        this.snmpProxy = this.snmpProxySelector.getObjectId();
        if (this.session.isZoningEnabled() && (object = this.session.findObjectById(zoneObjectId = this.zoneSelector.getObjectId())) != null && object instanceof Zone) {
            this.zoneId = ((Zone)object).getZoneId();
        }
        super.okPressed();
    }

    private void resolveName() {
        final String name = this.objectNameField.getText();
        new ConsoleJob("Resolve host name", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final InetAddress addr = Inet4Address.getByName(name);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CreateNodeDialog.this.hostNameField.setText(addr.getHostAddress());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot resolve host name " + name + " to IP address";
            }
        }.start();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getCreationFlags() {
        return this.creationFlags;
    }

    public long getAgentProxy() {
        return this.agentProxy;
    }

    public long getSnmpProxy() {
        return this.snmpProxy;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }
}

