/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AutoApply
extends PropertyPage {
    private Template object;
    private Button checkboxEnableApply;
    private Button checkboxEnableRemove;
    private ScriptEditor filterSource;
    private int initialFlags;
    private String initialApplyFilter;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Template)this.getElement().getAdapter(Template.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.initialFlags = this.object.getFlags();
        this.initialApplyFilter = this.object.getAutoApplyFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableApply = new Button(dialogArea, 32);
        this.checkboxEnableApply.setText("Apply this template automatically to nodes selected by filter");
        this.checkboxEnableApply.setSelection(this.object.isAutoApplyEnabled());
        this.checkboxEnableApply.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (AutoApply.this.checkboxEnableApply.getSelection()) {
                    AutoApply.this.filterSource.setEnabled(true);
                    AutoApply.this.filterSource.setFocus();
                    AutoApply.this.checkboxEnableRemove.setEnabled(true);
                } else {
                    AutoApply.this.filterSource.setEnabled(false);
                    AutoApply.this.checkboxEnableRemove.setEnabled(false);
                }
            }
        });
        this.checkboxEnableRemove = new Button(dialogArea, 32);
        this.checkboxEnableRemove.setText("Remove this template automatically when node no longer passes through filter");
        this.checkboxEnableRemove.setSelection(this.object.isAutoRemoveEnabled());
        this.checkboxEnableRemove.setEnabled(this.object.isAutoApplyEnabled());
        Label label = new Label(dialogArea, 0);
        label.setText("Filtering script");
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768);
        this.filterSource.setText(this.object.getAutoApplyFilter());
        this.filterSource.setEnabled(this.object.isAutoApplyEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        int flags = this.object.getFlags();
        flags = this.checkboxEnableApply.getSelection() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        flags = this.checkboxEnableRemove.getSelection() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        if (flags == this.initialFlags && this.initialApplyFilter.equals(this.filterSource.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setAutoBindFilter(this.filterSource.getText());
        md.setObjectFlags(flags);
        new ConsoleJob("Update auto-apply filter", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                AutoApply.this.initialFlags = md.getObjectFlags();
                AutoApply.this.initialApplyFilter = md.getAutoBindFilter();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AutoApply.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot change template automatic apply options";
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

