/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.views;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.NodePollListener;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class NodePollerView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectmanager.views.NodePollerView";
    private static final String[] POLL_NAME = new String[]{"", "Status Poll", "Configuration Poll", "Interface Poll", "Topology Poll"};
    private static final Color COLOR_ERROR = new Color((Device)Display.getCurrent(), 192, 0, 0);
    private static final Color COLOR_WARNING = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private static final Color COLOR_INFO = new Color((Device)Display.getCurrent(), 0, 128, 0);
    private static final Color COLOR_LOCAL = new Color((Device)Display.getCurrent(), 0, 0, 192);
    private NXCSession session;
    private Node node;
    private int pollType;
    private StyledText textArea;
    private boolean pollActive = false;
    private Action actionRestart;
    private Action actionClearOutput;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        GenericObject obj = this.session.findObjectById(Long.parseLong(parts[0]));
        Node node = this.node = obj != null && obj instanceof Node ? (Node)obj : null;
        if (this.node == null) {
            throw new PartInitException("Invalid object ID");
        }
        this.pollType = Integer.parseInt(parts[1]);
        this.setPartName(String.valueOf(POLL_NAME[this.pollType]) + " - " + this.node.getObjectName());
    }

    public void createPartControl(Composite parent) {
        this.textArea = new StyledText(parent, 770);
        this.textArea.setEditable(false);
        this.textArea.setFont(JFaceResources.getTextFont());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionRestart = new Action("&Restart poll", SharedIcons.RESTART){

            public void run() {
                NodePollerView.this.startPoll();
            }
        };
        this.actionClearOutput = new Action("&Clear output", SharedIcons.CLEAR_LOG){

            public void run() {
                NodePollerView.this.textArea.setText("");
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionClearOutput);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionClearOutput);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                NodePollerView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.textArea);
        this.textArea.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        WidgetHelper.addStyledTextEditorActions((IMenuManager)manager, (StyledText)this.textArea, (boolean)true);
        manager.add((IAction)this.actionClearOutput);
    }

    private void addPollerMessage(String message) {
        Date now = new Date();
        this.textArea.append("[" + DateFormat.getDateTimeInstance(3, 2).format(now) + "] ");
        int index = message.indexOf(127);
        if (index != -1) {
            this.textArea.append(message.substring(0, index));
            char code = message.charAt(index + 1);
            int lastPos = this.textArea.getCharCount();
            String msgPart = message.substring(index + 2);
            this.textArea.append(msgPart);
            StyleRange style = new StyleRange();
            style.start = lastPos;
            style.length = msgPart.length();
            style.foreground = this.getTextColor(code);
            this.textArea.setStyleRange(style);
        } else {
            this.textArea.append(message);
        }
        this.textArea.setCaretOffset(this.textArea.getCharCount());
        this.textArea.setTopIndex(this.textArea.getLineCount() - 1);
    }

    private Color getTextColor(char code) {
        switch (code) {
            case 'e': {
                return COLOR_ERROR;
            }
            case 'w': {
                return COLOR_WARNING;
            }
            case 'i': {
                return COLOR_INFO;
            }
            case 'l': {
                return COLOR_LOCAL;
            }
        }
        return null;
    }

    public void setFocus() {
        this.textArea.setFocus();
    }

    public void startPoll() {
        if (this.pollActive) {
            return;
        }
        this.pollActive = true;
        this.actionRestart.setEnabled(false);
        this.addPollerMessage("\u007fl**** Poll request sent to server ****\r\n");
        final NodePollListener listener = new NodePollListener(){

            public void onPollerMessage(final String message) {
                new UIJob(NodePollerView.this.textArea.getDisplay(), "Update poller window"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!NodePollerView.this.textArea.isDisposed()) {
                            NodePollerView.this.addPollerMessage(message);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
        Job job = new Job("Node poll: " + this.node.getObjectName() + " [" + this.node.getObjectId() + "]"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    NodePollerView.this.session.pollNode(NodePollerView.this.node.getObjectId(), NodePollerView.this.pollType, listener);
                    NodePollerView.this.onPollComplete(true, null);
                }
                catch (Exception e) {
                    NodePollerView.this.onPollComplete(false, e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void onPollComplete(final boolean success, final String errorMessage) {
        if (this.textArea.isDisposed()) {
            return;
        }
        new UIJob(this.textArea.getDisplay(), "Update poller window"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!NodePollerView.this.textArea.isDisposed()) {
                    if (success) {
                        NodePollerView.this.addPollerMessage("\u007fl**** Poll completed successfully ****\r\n\r\n");
                    } else {
                        NodePollerView.this.addPollerMessage("\u007fePOLL ERROR: " + errorMessage);
                        NodePollerView.this.addPollerMessage("\u007fl**** Poll failed ****\r\n\r\n");
                    }
                    NodePollerView.this.pollActive = false;
                    NodePollerView.this.actionRestart.setEnabled(true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

