/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.Iterator;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.networkmaps.views.NetworkMap;

public class IPNeighbors
extends NetworkMap {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.view.ip_neighbors";

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setPartName("IP Neighbors - " + this.rootObject.getObjectName());
    }

    @Override
    protected void buildMapPage() {
        this.mapPage = new NetworkMapPage();
        long rootElementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(rootElementId, this.rootObject.getObjectId()));
        Iterator it = this.rootObject.getParents();
        while (it.hasNext()) {
            long objectId = (Long)it.next();
            GenericObject object = this.session.findObjectById(objectId);
            if (object == null || !(object instanceof Subnet)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(0, rootElementId, elementId));
            this.addNodesFromSubnet((Subnet)object, elementId, this.rootObject.getObjectId());
        }
    }

    private void addNodesFromSubnet(Subnet subnet, long subnetElementId, long rootNodeId) {
        Iterator it = subnet.getChilds();
        while (it.hasNext()) {
            GenericObject object;
            long objectId = (Long)it.next();
            if (objectId == rootNodeId || (object = this.session.findObjectById(objectId)) == null || !(object instanceof Node)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(0, subnetElementId, elementId));
        }
    }
}

