/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.ObjectToolsAdapterFactory;
import org.netxms.ui.eclipse.objecttools.dialogs.CreateNewToolDialog;
import org.netxms.ui.eclipse.objecttools.views.helpers.ObjectToolsComparator;
import org.netxms.ui.eclipse.objecttools.views.helpers.ObjectToolsLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectToolsEditor
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.ObjectToolsEditor";
    private static final String TABLE_CONFIG_PREFIX = "ObjectToolsEditor";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private Map<Long, ObjectTool> tools = new HashMap<Long, ObjectTool>();
    private SortableTableViewer viewer;
    private NXCSession session;
    private Action actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        try {
            Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0L, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
        parent.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{"ID", "Name", "Type", "Description"};
        int[] columnWidths = new int[]{90, 200, 100, 200};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 1, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectToolsLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectToolsComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ObjectToolsEditor.this.actionEdit.setEnabled(selection.size() == 1);
                    ObjectToolsEditor.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectToolsEditor.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ObjectToolsEditor.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ObjectToolsEditor.TABLE_CONFIG_PREFIX);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        this.refreshToolList();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ObjectToolsEditor.this.refreshToolList();
            }
        };
        this.actionNew = new Action("&New..."){

            public void run() {
                ObjectToolsEditor.this.createTool();
            }
        };
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEdit = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ObjectToolsEditor.this.viewer.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                long toolId = ((ObjectTool)selection.getFirstElement()).getId();
                if (Platform.getAdapterManager().getAdapter(selection.getFirstElement(), ObjectToolDetails.class) == null) {
                    return;
                }
                super.run();
                ObjectToolDetails details = ObjectToolsAdapterFactory.getDetailsFromCache(toolId);
                if (details != null && details.isModified()) {
                    ObjectToolsEditor.this.saveObjectTool(details);
                }
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        this.actionDelete = new Action("&Delete"){

            public void run() {
                ObjectToolsEditor.this.deleteTools();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectToolsEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEdit);
    }

    private void refreshToolList() {
        new ConsoleJob("Get object tools configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", "org.netxms.ui.eclipse.objecttools"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List tl = ObjectToolsEditor.this.session.getObjectTools();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ObjectToolsEditor.this.tools.clear();
                        for (ObjectTool t : tl) {
                            ObjectToolsEditor.this.tools.put(t.getId(), t);
                        }
                        ObjectToolsEditor.this.viewer.setInput((Object)ObjectToolsEditor.this.tools.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get object tools configuration";
            }
        }.start();
    }

    private void createTool() {
        final CreateNewToolDialog dlg = new CreateNewToolDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            new ConsoleJob("Generate new object tool ID", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", "org.netxms.ui.eclipse.objecttools"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long toolId = ObjectToolsEditor.this.session.generateObjectToolId();
                    final ObjectToolDetails details = new ObjectToolDetails(toolId, dlg.getType(), dlg.getName());
                    ObjectToolsEditor.this.session.modifyObjectTool(details);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)ObjectToolsEditor.this.getSite().getShell(), null, (Object)details);
                            dlg.open();
                            if (details.isModified()) {
                                ObjectToolsEditor.this.saveObjectTool(details);
                            }
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot generate object tool ID";
                }
            }.start();
        }
    }

    private void deleteTools() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Confirmation", (String)"Do you really want to delete selected tools?")) {
            return;
        }
        final Object[] objects = selection.toArray();
        new ConsoleJob("Delete objecttools", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", "org.netxms.ui.eclipse.objecttools"){

            protected String getErrorMessage() {
                return "Cannot delete object tool";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    ObjectToolsEditor.this.session.deleteObjectTool(((ObjectTool)objects[i]).getId());
                    ++i;
                }
            }
        }.start();
    }

    private void saveObjectTool(final ObjectToolDetails details) {
        new ConsoleJob("Save object tool", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", "org.netxms.ui.eclipse.objecttools"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ObjectToolsEditor.this.session.modifyObjectTool(details);
            }

            protected String getErrorMessage() {
                return "Cannot save object tool configuration";
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ObjectToolsAdapterFactory.deleteFromCache(details.getId());
                    }
                });
            }
        }.schedule();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1009: {
                this.refreshToolList();
                break;
            }
            case 1015: {
                new UIJob(this.getSite().getShell().getDisplay(), "Delete object tool from list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ObjectToolsAdapterFactory.deleteFromCache(n.getSubCode());
                        ObjectToolsEditor.this.tools.remove(n.getSubCode());
                        ObjectToolsEditor.this.viewer.setInput((Object)ObjectToolsEditor.this.tools.values().toArray());
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        ObjectToolsAdapterFactory.clearCache();
        super.dispose();
    }
}

