/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LabelConfig;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LabelProperties
extends PropertyPage {
    private LabelConfig config;
    private LabeledText title;
    private ColorSelector foreground;
    private ColorSelector background;

    protected Control createContents(Composite parent) {
        this.config = (LabelConfig)this.getElement().getAdapter(LabelConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0, 2050);
        this.title.setLabel("Title");
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        Composite fgArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        fgArea.setLayoutData((Object)gd);
        RowLayout areaLayout = new RowLayout();
        areaLayout.type = 256;
        areaLayout.marginBottom = 0;
        areaLayout.marginTop = 0;
        areaLayout.marginLeft = 0;
        areaLayout.marginRight = 0;
        fgArea.setLayout((Layout)areaLayout);
        new Label(fgArea, 0).setText("Text color:");
        this.foreground = new ColorSelector(fgArea);
        this.foreground.setColorValue(ColorConverter.rgbFromInt((int)this.config.getForegroundColorAsInt()));
        Composite bgArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        bgArea.setLayoutData((Object)gd);
        areaLayout = new RowLayout();
        areaLayout.type = 256;
        areaLayout.marginBottom = 0;
        areaLayout.marginTop = 0;
        areaLayout.marginLeft = 0;
        areaLayout.marginRight = 0;
        bgArea.setLayout((Layout)areaLayout);
        new Label(bgArea, 0).setText("Background color:");
        this.background = new ColorSelector(bgArea);
        this.background.setColorValue(ColorConverter.rgbFromInt((int)this.config.getBackgroundColorAsInt()));
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setTitle(this.title.getText());
        this.config.setForeground("0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)this.foreground.getColorValue())));
        this.config.setBackground("0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)this.background.getColorValue())));
        return true;
    }
}

