/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.api.client.ProgressListener;
import org.netxms.api.client.Session;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.api.client.images.ImageLibraryManager;
import org.netxms.api.client.images.LibraryImage;
import org.netxms.api.client.scripts.Script;
import org.netxms.api.client.scripts.ScriptLibraryManager;
import org.netxms.api.client.servermanager.ServerManager;
import org.netxms.api.client.servermanager.ServerVariable;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.api.client.users.UserGroup;
import org.netxms.api.client.users.UserManager;
import org.netxms.base.CompatTools;
import org.netxms.base.EncryptionContext;
import org.netxms.base.Logger;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCPMessageReceiver;
import org.netxms.base.NXCPMsgWaitQueue;
import org.netxms.client.AccessListElement;
import org.netxms.client.AgentParameter;
import org.netxms.client.GeoLocation;
import org.netxms.client.IpAddressListElement;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCException;
import org.netxms.client.NXCNotification;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCReceivedFile;
import org.netxms.client.NXCServerJob;
import org.netxms.client.NodePollListener;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.ServerAction;
import org.netxms.client.ServerConsoleListener;
import org.netxms.client.ServerFile;
import org.netxms.client.Table;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ConditionDciInfo;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.DciPushData;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.datacollection.ThresholdViolationSummary;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmNote;
import org.netxms.client.events.Event;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.events.SyslogRecord;
import org.netxms.client.log.Log;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.client.objects.AgentPolicyConfig;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.ClusterSyncNetwork;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.NodeLink;
import org.netxms.client.objects.PolicyGroup;
import org.netxms.client.objects.PolicyRoot;
import org.netxms.client.objects.Report;
import org.netxms.client.objects.ReportGroup;
import org.netxms.client.objects.ReportRoot;
import org.netxms.client.objects.ServiceCheck;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.client.objects.UnknownObject;
import org.netxms.client.objects.Zone;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.packages.PackageDeploymentListener;
import org.netxms.client.packages.PackageInfo;
import org.netxms.client.reports.ReportRenderFormat;
import org.netxms.client.reports.ReportResult;
import org.netxms.client.situations.Situation;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.client.snmp.SnmpTrapLogRecord;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.client.topology.NetworkPath;
import org.netxms.client.topology.VlanInfo;

public class NXCSession
implements Session,
ScriptLibraryManager,
UserManager,
ServerManager,
ImageLibraryManager {
    public static final int DEFAULT_CONN_PORT = 4701;
    public static final int CLIENT_PROTOCOL_VERSION = 34;
    public static final int AUTH_TYPE_PASSWORD = 0;
    public static final int AUTH_TYPE_CERTIFICATE = 1;
    public static final int CHANNEL_EVENTS = 1;
    public static final int CHANNEL_SYSLOG = 2;
    public static final int CHANNEL_ALARMS = 4;
    public static final int CHANNEL_OBJECTS = 8;
    public static final int CHANNEL_SNMP_TRAPS = 16;
    public static final int CHANNEL_AUDIT_LOG = 32;
    public static final int CHANNEL_SITUATIONS = 64;
    public static final int OBJECT_SYNC_NOTIFY = 1;
    public static final int OBJECT_SYNC_WAIT = 2;
    public static final int CFG_IMPORT_REPLACE_EVENT_BY_CODE = 1;
    public static final int CFG_IMPORT_REPLACE_EVENT_BY_NAME = 2;
    public static final int ADDRESS_LIST_DISCOVERY_TARGETS = 1;
    public static final int ADDRESS_LIST_DISCOVERY_FILTER = 2;
    public static final int SERVER_COMPONENT_DISCOVERY_MANAGER = 1;
    public static final int DESKTOP_CLIENT = 0;
    public static final int WEB_CLIENT = 1;
    public static final int MOBILE_CLIENT = 2;
    public static final int TABLET_CLIENT = 3;
    public static final int APPLICATION_CLIENT = 4;
    private static final int CLIENT_CHALLENGE_SIZE = 256;
    private static final int MAX_DCI_DATA_ROWS = 200000;
    private static final int MAX_DCI_STRING_VALUE_LENGTH = 256;
    private static final int RECEIVED_FILE_TTL = 300000;
    private static final int FILE_BUFFER_SIZE = 131072;
    private final Semaphore syncObjects = new Semaphore(1);
    private final Semaphore syncUserDB = new Semaphore(1);
    private String connAddress;
    private int connPort;
    private String connLoginName;
    private String connPassword;
    private boolean connUseEncryption;
    private String connClientInfo = "nxjclient/1.2.3";
    private int clientType = 0;
    private int userId;
    private int userSystemRights;
    private boolean passwordExpired;
    private Socket connSocket = null;
    private NXCPMsgWaitQueue msgWaitQueue = null;
    private ReceiverThread recvThread = null;
    private HousekeeperThread housekeeperThread = null;
    private AtomicLong requestId = new AtomicLong(1L);
    private boolean isConnected = false;
    private boolean serverConsoleConnected = false;
    private EncryptionContext encryptionContext = null;
    private int recvBufferSize = 0x400000;
    private int commandTimeout = 30000;
    private Set<SessionListener> listeners = new HashSet<SessionListener>(0);
    private Set<ServerConsoleListener> consoleListeners = new HashSet<ServerConsoleListener>(0);
    private Map<Long, NXCReceivedFile> receivedFiles = new HashMap<Long, NXCReceivedFile>();
    private String serverVersion = "(unknown)";
    private byte[] serverId = new byte[8];
    private String serverTimeZone;
    private byte[] serverChallenge = new byte[256];
    private boolean zoningEnabled = false;
    private String tileServerURL;
    private String dateFormat;
    private String timeFormat;
    private Map<Long, GenericObject> objectList = new HashMap<Long, GenericObject>();
    private boolean objectsSynchronized = false;
    private Map<Long, AbstractUserObject> userDB = new HashMap<Long, AbstractUserObject>();
    private Map<Long, EventTemplate> eventTemplates = new HashMap<Long, EventTemplate>();
    private boolean eventTemplatesNeedSync = false;

    private long int32FromInetAddress(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        return (long)bytes[0] << 24 | (long)bytes[1] << 16 | (long)bytes[2] << 8 | (long)bytes[3];
    }

    private GenericObject createObjectFromMessage(NXCPMessage msg) {
        GenericObject object;
        int objectClass = msg.getVariableAsInteger(5L);
        switch (objectClass) {
            case 3: {
                object = new Interface(msg, this);
                break;
            }
            case 1: {
                object = new Subnet(msg, this);
                break;
            }
            case 5: {
                object = new Container(msg, this);
                break;
            }
            case 13: {
                object = new Condition(msg, this);
                break;
            }
            case 2: {
                object = new Node(msg, this);
                break;
            }
            case 14: {
                object = new Cluster(msg, this);
                break;
            }
            case 8: {
                object = new Template(msg, this);
                break;
            }
            case 10: {
                object = new TemplateRoot(msg, this);
                break;
            }
            case 9: {
                object = new TemplateGroup(msg, this);
                break;
            }
            case 4: {
                object = new EntireNetwork(msg, this);
                break;
            }
            case 7: {
                object = new ServiceRoot(msg, this);
                break;
            }
            case 16: {
                object = new PolicyRoot(msg, this);
                break;
            }
            case 15: {
                object = new PolicyGroup(msg, this);
                break;
            }
            case 17: {
                object = new AgentPolicy(msg, this);
                break;
            }
            case 18: {
                object = new AgentPolicyConfig(msg, this);
                break;
            }
            case 19: {
                object = new NetworkMapRoot(msg, this);
                break;
            }
            case 20: {
                object = new NetworkMapGroup(msg, this);
                break;
            }
            case 21: {
                object = new NetworkMap(msg, this);
                break;
            }
            case 22: {
                object = new DashboardRoot(msg, this);
                break;
            }
            case 23: {
                object = new Dashboard(msg, this);
                break;
            }
            case 6: {
                object = new Zone(msg, this);
                break;
            }
            case 11: {
                object = new NetworkService(msg, this);
                break;
            }
            case 24: {
                object = new ReportRoot(msg, this);
                break;
            }
            case 25: {
                object = new ReportGroup(msg, this);
                break;
            }
            case 26: {
                object = new Report(msg, this);
                break;
            }
            case 27: {
                object = new BusinessServiceRoot(msg, this);
                break;
            }
            case 28: {
                object = new BusinessService(msg, this);
                break;
            }
            case 29: {
                object = new NodeLink(msg, this);
                break;
            }
            case 30: {
                object = new ServiceCheck(msg, this);
                break;
            }
            default: {
                object = new GenericObject(msg, this);
            }
        }
        return object;
    }

    private void setupEncryption(NXCPMessage msg) throws IOException, NXCException {
        NXCPMessage response = new NXCPMessage(132, msg.getMessageId());
        response.setEncryptionDisabled(true);
        try {
            this.encryptionContext = EncryptionContext.createInstance((NXCPMessage)msg);
            response.setVariable(155L, this.encryptionContext.getEncryptedSessionKey(msg));
            response.setVariable(158L, this.encryptionContext.getEncryptedIv(msg));
            response.setVariableInt16(156L, this.encryptionContext.getCipher());
            response.setVariableInt16(157L, this.encryptionContext.getKeyLength());
            response.setVariableInt16(238L, this.encryptionContext.getIvLength());
            response.setVariableInt32(28L, 0);
        }
        catch (Exception e) {
            response.setVariableInt32(28L, 42);
        }
        this.sendMessage(response);
    }

    public NXCSession(String connAddress, String connLoginName, String connPassword) {
        this.connAddress = connAddress;
        this.connPort = 4701;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = false;
    }

    public NXCSession(String connAddress, int connPort, String connLoginName, String connPassword) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = false;
    }

    public NXCSession(String connAddress, int connPort, String connLoginName, String connPassword, boolean connUseEncryption) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = connUseEncryption;
    }

    protected void finalize() {
        this.disconnect();
    }

    private void waitForSync(Semaphore syncObject, int timeout) throws NXCException {
        if (timeout == 0) {
            syncObject.acquireUninterruptibly();
        } else {
            long startTime;
            boolean success = false;
            for (long actualTimeout = (long)timeout; actualTimeout > 0L; actualTimeout -= System.currentTimeMillis() - startTime) {
                startTime = System.currentTimeMillis();
                try {
                    if (!this.syncObjects.tryAcquire(actualTimeout, TimeUnit.MILLISECONDS)) continue;
                    success = true;
                    this.syncObjects.release();
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!success) {
                throw new NXCException(4);
            }
        }
    }

    private void completeSync(Semaphore syncObject) {
        syncObject.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SessionListener listener) {
        Set<SessionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SessionListener listener) {
        Set<SessionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsoleListener(ServerConsoleListener listener) {
        Set<ServerConsoleListener> set = this.consoleListeners;
        synchronized (set) {
            this.consoleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsoleListener(ServerConsoleListener listener) {
        Set<ServerConsoleListener> set = this.consoleListeners;
        synchronized (set) {
            this.consoleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNotification(NXCNotification n) {
        Set<SessionListener> set = this.listeners;
        synchronized (set) {
            Iterator<SessionListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().notificationHandler((SessionNotification)n);
            }
        }
    }

    public synchronized void sendMessage(NXCPMessage msg) throws IOException, NXCException {
        byte[] message;
        if (this.connSocket == null) {
            throw new IllegalStateException("Not connected to the server. Did you forgot to call connect() first?");
        }
        OutputStream outputStream = this.connSocket.getOutputStream();
        if (this.encryptionContext != null && !msg.isEncryptionDisabled()) {
            try {
                message = this.encryptionContext.encryptMessage(msg);
            }
            catch (GeneralSecurityException e) {
                throw new NXCException(98);
            }
        } else {
            message = msg.createNXCPMessage();
        }
        outputStream.write(message);
    }

    protected void sendFile(long requestId, File file, ProgressListener listener) throws IOException, NXCException {
        if (listener != null) {
            listener.setTotalWorkAmount(file.length());
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        this.sendFileStream(requestId, inputStream, listener);
        ((InputStream)inputStream).close();
    }

    protected void sendFile(long requestId, byte[] data, ProgressListener listener) throws IOException, NXCException {
        if (listener != null) {
            listener.setTotalWorkAmount((long)data.length);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        this.sendFileStream(requestId, inputStream, listener);
        ((InputStream)inputStream).close();
    }

    private void sendFileStream(long requestId, InputStream inputStream, ProgressListener listener) throws IOException, NXCException {
        int bytesRead;
        NXCPMessage msg = new NXCPMessage(105, requestId);
        msg.setBinaryMessage(true);
        boolean success = false;
        byte[] buffer = new byte[131072];
        long bytesSent = 0L;
        do {
            if ((bytesRead = inputStream.read(buffer)) < 131072) {
                msg.setEndOfFile(true);
            }
            msg.setBinaryData(CompatTools.arrayCopy((byte[])buffer, (int)bytesRead));
            this.sendMessage(msg);
            bytesSent += (long)bytesRead;
            if (listener == null) continue;
            listener.markProgress(bytesSent);
        } while (bytesRead >= 131072);
        success = true;
        if (!success) {
            NXCPMessage abortMessage = new NXCPMessage(114, requestId);
            abortMessage.setBinaryMessage(true);
            this.sendMessage(abortMessage);
            this.waitForRCC(abortMessage.getMessageId());
        }
    }

    public NXCPMessage waitForMessage(int code, long id, int timeout) throws NXCException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id, timeout);
        if (msg == null) {
            throw new NXCException(4);
        }
        return msg;
    }

    public NXCPMessage waitForMessage(int code, long id) throws NXCException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id);
        if (msg == null) {
            throw new NXCException(4);
        }
        return msg;
    }

    public NXCPMessage waitForRCC(long id) throws NXCException {
        return this.waitForRCC(id, this.msgWaitQueue.getDefaultTimeout());
    }

    public NXCPMessage waitForRCC(long id, int timeout) throws NXCException {
        NXCPMessage msg = this.waitForMessage(29, id, timeout);
        int rcc = msg.getVariableAsInteger(28L);
        if (rcc != 0) {
            if (rcc == 1 && msg.findVariable(29L) != null) {
                throw new NXCException(rcc, "locked by " + msg.getVariableAsString(29L));
            }
            if (msg.findVariable(259L) != null) {
                throw new NXCException(rcc, msg.getVariableAsString(259L));
            }
            throw new NXCException(rcc);
        }
        return msg;
    }

    public final NXCPMessage newMessage(int code) {
        return new NXCPMessage(code, this.requestId.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File waitForFile(long id, int timeout) {
        int timeRemaining = timeout;
        File file = null;
        while (timeRemaining > 0) {
            Map<Long, NXCReceivedFile> map = this.receivedFiles;
            synchronized (map) {
                NXCReceivedFile rf = this.receivedFiles.get(id);
                if (rf != null && rf.getStatus() != 0) {
                    if (rf.getStatus() == 1) {
                        file = rf.getFile();
                    }
                    break;
                }
                long startTime = System.currentTimeMillis();
                try {
                    this.receivedFiles.wait(timeRemaining);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                timeRemaining = (int)((long)timeRemaining - (System.currentTimeMillis() - startTime));
            }
        }
        return file;
    }

    protected void executeSimpleCommand(int command) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(command);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Table receiveTable(long requestId, int msgCode) throws NXCException {
        NXCPMessage msg = this.waitForMessage(msgCode, requestId);
        Table table = new Table(msg);
        while (!msg.isEndOfSequence()) {
            msg = this.waitForMessage(msgCode, requestId);
            table.addDataFromMessage(msg);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException, UnknownHostException, NetXMSClientException {
        Logger.info((String)"NXCSession.connect", (String)("Connecting to " + this.connAddress + ":" + this.connPort));
        try {
            this.connSocket = new Socket(this.connAddress, this.connPort);
            this.msgWaitQueue = new NXCPMsgWaitQueue(this.commandTimeout);
            this.recvThread = new ReceiverThread();
            this.housekeeperThread = new HousekeeperThread();
            Logger.debug((String)"NXCSession.connect", (String)"connection established, retrieving server info");
            NXCPMessage request = this.newMessage(103);
            this.sendMessage(request);
            NXCPMessage response = this.waitForMessage(29, request.getMessageId());
            if (response.getVariableAsInteger(146L) != 34) {
                Logger.warning((String)"NXCSession.connect", (String)("connection failed, server protocol version is " + response.getVariableAsInteger(146L)));
                throw new NXCException(40);
            }
            this.serverVersion = response.getVariableAsString(121L);
            this.serverId = response.getVariableAsBinary(142L);
            this.serverTimeZone = response.getVariableAsString(308L);
            this.serverChallenge = response.getVariableAsBinary(278L);
            this.tileServerURL = response.getVariableAsString(384L);
            if (this.tileServerURL != null) {
                if (!this.tileServerURL.endsWith("/")) {
                    this.tileServerURL = this.tileServerURL.concat("/");
                }
            } else {
                this.tileServerURL = "http://tile.openstreetmap.org/";
            }
            this.dateFormat = response.getVariableAsString(421L);
            if (this.dateFormat == null || this.dateFormat.length() == 0) {
                this.dateFormat = "dd.MM.yyyy";
            }
            this.timeFormat = response.getVariableAsString(422L);
            if (this.timeFormat == null || this.timeFormat.length() == 0) {
                this.dateFormat = "HH:mm:ss";
            }
            if (this.connUseEncryption) {
                request = this.newMessage(133);
                request.setVariableInt16(319L, 1);
                this.sendMessage(request);
                this.waitForRCC(request.getMessageId());
            }
            Logger.debug((String)"NXCSession.connect", (String)("Connected to server version " + this.serverVersion + ", trying to login"));
            request = this.newMessage(1);
            request.setVariable(1L, this.connLoginName);
            request.setVariable(2L, this.connPassword);
            request.setVariableInt16(275L, 0);
            request.setVariable(177L, "1.2.3");
            request.setVariable(175L, this.connClientInfo);
            request.setVariable(176L, System.getProperty("os.name") + " " + System.getProperty("os.version"));
            request.setVariableInt16(170L, this.clientType);
            this.sendMessage(request);
            response = this.waitForMessage(2, request.getMessageId());
            int rcc = response.getVariableAsInteger(28L);
            Logger.debug((String)"NXCSession.connect", (String)("CMD_LOGIN_RESP received, RCC=" + rcc));
            if (rcc != 0) {
                Logger.warning((String)"NXCSession.connect", (String)("Login failed, RCC=" + rcc));
                throw new NXCException(rcc);
            }
            this.userId = response.getVariableAsInteger(35L);
            this.userSystemRights = response.getVariableAsInteger(36L);
            this.passwordExpired = response.getVariableAsBoolean(221L);
            this.zoningEnabled = response.getVariableAsBoolean(148L);
            Logger.info((String)"NXCSession.connect", (String)("succesfully connected and logged in, userId=" + this.userId));
            this.isConnected = true;
        }
        finally {
            if (!this.isConnected) {
                this.disconnect();
            }
        }
    }

    public void disconnect() {
        if (this.connSocket != null) {
            try {
                this.connSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.recvThread != null) {
            while (this.recvThread.isAlive()) {
                try {
                    this.recvThread.join();
                }
                catch (InterruptedException e) {}
            }
            this.recvThread = null;
        }
        if (this.housekeeperThread != null) {
            this.housekeeperThread.setStopFlag(true);
            while (this.housekeeperThread.isAlive()) {
                try {
                    this.housekeeperThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.housekeeperThread = null;
        }
        this.connSocket = null;
        if (this.msgWaitQueue != null) {
            this.msgWaitQueue.shutdown();
            this.msgWaitQueue = null;
        }
        this.isConnected = false;
    }

    public int getRecvBufferSize() {
        return this.recvBufferSize;
    }

    public void setRecvBufferSize(int recvBufferSize) {
        this.recvBufferSize = recvBufferSize;
    }

    public String getServerAddress() {
        return this.connAddress;
    }

    public String getUserName() {
        return this.connLoginName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public String getTileServerURL() {
        return this.tileServerURL;
    }

    public boolean isZoningEnabled() {
        return this.zoningEnabled;
    }

    public String getConnClientInfo() {
        return this.connClientInfo;
    }

    public void setConnClientInfo(String connClientInfo) {
        this.connClientInfo = connClientInfo;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getUserSystemRights() {
        return this.userSystemRights;
    }

    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }

    public synchronized void syncObjects() throws IOException, NXCException {
        this.syncObjects.acquireUninterruptibly();
        NXCPMessage msg = this.newMessage(5);
        msg.setVariableInt16(254L, 1);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForSync(this.syncObjects, this.commandTimeout * 10);
        this.objectsSynchronized = true;
        this.sendNotification(new NXCNotification(2001));
        this.subscribe(8);
    }

    public void syncObjectSet(long[] objects, boolean syncComments) throws IOException, NXCException {
        this.syncObjectSet(objects, syncComments, 0);
    }

    public void syncObjectSet(long[] objects, boolean syncComments, int options) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(249);
        msg.setVariableInt16(254L, syncComments ? 1 : 0);
        msg.setVariableInt16(13L, options);
        msg.setVariableInt32(138L, objects.length);
        msg.setVariable(139L, objects);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        if ((options & 2) != 0) {
            this.waitForRCC(msg.getMessageId());
        }
    }

    public void syncMissingObjects(long[] objects, boolean syncComments) throws IOException, NXCException {
        this.syncMissingObjects(objects, syncComments, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMissingObjects(long[] objects, boolean syncComments, int options) throws IOException, NXCException {
        long[] syncList = CompatTools.arrayCopy((long[])objects, (int)objects.length);
        int count = syncList.length;
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            for (int i = 0; i < syncList.length; ++i) {
                if (!this.objectList.containsKey(syncList[i])) continue;
                syncList[i] = 0L;
                --count;
            }
        }
        if (count > 0) {
            this.syncObjectSet(syncList, syncComments, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject findObjectById(long id) {
        GenericObject obj;
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            obj = this.objectList.get(id);
        }
        return obj;
    }

    public GenericObject findObjectById(long id, Class<? extends GenericObject> requiredClass) {
        GenericObject object = this.findObjectById(id);
        return requiredClass.isInstance(object) ? object : null;
    }

    public List<GenericObject> findMultipleObjects(long[] idList, boolean returnUnknown) {
        return this.findMultipleObjects(idList, (Class<? extends GenericObject>)null, returnUnknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericObject> findMultipleObjects(long[] idList, Class<? extends GenericObject> classFilter, boolean returnUnknown) {
        ArrayList<GenericObject> result = new ArrayList<GenericObject>(idList.length);
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            for (int i = 0; i < idList.length; ++i) {
                GenericObject object = this.objectList.get(idList[i]);
                if (object != null && (classFilter == null || classFilter.isInstance(object))) {
                    result.add(object);
                    continue;
                }
                if (!returnUnknown) continue;
                result.add(new UnknownObject(idList[i], this));
            }
        }
        return result;
    }

    public List<GenericObject> findMultipleObjects(Long[] idList, boolean returnUnknown) {
        return this.findMultipleObjects(idList, (Class<? extends GenericObject>)null, returnUnknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericObject> findMultipleObjects(Long[] idList, Class<? extends GenericObject> classFilter, boolean returnUnknown) {
        ArrayList<GenericObject> result = new ArrayList<GenericObject>(idList.length);
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            for (int i = 0; i < idList.length; ++i) {
                GenericObject object = this.objectList.get(idList[i]);
                if (object != null && (classFilter == null || classFilter.isInstance(object))) {
                    result.add(object);
                    continue;
                }
                if (!returnUnknown) continue;
                result.add(new UnknownObject(idList[i], this));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject findObjectByName(String name) {
        GenericObject result = null;
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            for (GenericObject object : this.objectList.values()) {
                if (!object.getObjectName().equalsIgnoreCase(name)) continue;
                result = object;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject findObjectByNamePattern(String pattern) {
        GenericObject result = null;
        Matcher matcher = Pattern.compile(pattern).matcher("");
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            for (GenericObject object : this.objectList.values()) {
                matcher.reset(object.getObjectName());
                if (!matcher.matches()) continue;
                result = object;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject[] getTopLevelObjects(Set<Integer> classFilter) {
        HashSet<GenericObject> list = new HashSet<GenericObject>();
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            for (GenericObject object : this.objectList.values()) {
                if (classFilter != null && !classFilter.contains(object.getObjectClass())) continue;
                if (object.getNumberOfParents() == 0) {
                    list.add(object);
                    continue;
                }
                boolean hasParents = false;
                Iterator<Long> it = object.getParents();
                while (it.hasNext()) {
                    Long parent = it.next();
                    if (classFilter != null) {
                        GenericObject p = this.objectList.get(parent);
                        if (p == null || !classFilter.contains(p.getObjectClass())) continue;
                        hasParents = true;
                        break;
                    }
                    if (!this.objectList.containsKey(parent)) continue;
                    hasParents = true;
                    break;
                }
                if (hasParents) continue;
                list.add(object);
            }
        }
        return list.toArray(new GenericObject[list.size()]);
    }

    public GenericObject[] getTopLevelObjects() {
        return this.getTopLevelObjects(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericObject[] getAllObjects() {
        GenericObject[] list;
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            list = this.objectList.values().toArray(new GenericObject[this.objectList.size()]);
        }
        return list;
    }

    public String getObjectName(long objectId) {
        GenericObject object = this.findObjectById(objectId);
        return object != null ? object.getObjectName() : "[" + Long.toString(objectId) + "]";
    }

    public HashMap<Long, Alarm> getAlarms() throws IOException, NXCException {
        long alarmId;
        NXCPMessage msg = this.newMessage(70);
        long rqId = msg.getMessageId();
        this.sendMessage(msg);
        HashMap<Long, Alarm> alarmList = new HashMap<Long, Alarm>(0);
        while ((alarmId = (long)(msg = this.waitForMessage(74, rqId)).getVariableAsInteger(93L)) != 0L) {
            alarmList.put(alarmId, new Alarm(msg));
        }
        return alarmList;
    }

    public Alarm getAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(259);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Alarm(response);
    }

    public void acknowledgeAlarm(long alarmId, boolean sticky) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(72);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt16(320L, sticky ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void acknowledgeAlarm(long alarmId) throws IOException, NXCException {
        this.acknowledgeAlarm(alarmId, false);
    }

    public void resolveAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(263);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void terminateAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(181);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(75);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void openAlarm(long alarmId, String reference) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(4);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt16(246L, 1);
        msg.setVariable(247L, reference);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void closeAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(4);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt16(246L, 2);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<AlarmNote> getAlarmNotes(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(71);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(361L);
        ArrayList<AlarmNote> notes = new ArrayList<AlarmNote>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            notes.add(new AlarmNote(response, varId));
            varId += 10L;
        }
        return notes;
    }

    public void updateAlarmNote(long alarmId, long noteId, String text) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(258);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt32(410L, (int)noteId);
        msg.setVariable(82L, text);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Map<String, ServerVariable> getServerVariables() throws IOException, NXCException {
        NXCPMessage request = this.newMessage(13);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        int count = response.getVariableAsInteger(144L);
        HashMap<String, ServerVariable> varList = new HashMap<String, ServerVariable>(count);
        int i = 0;
        long id = 0x10000000L;
        while (i < count) {
            String name = response.getVariableAsString(id);
            varList.put(name, new ServerVariable(name, response.getVariableAsString(id + 1L), response.getVariableAsBoolean(id + 2L)));
            ++i;
            id += 3L;
        }
        return varList;
    }

    public void setServerVariable(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(14);
        msg.setVariable(20L, name);
        msg.setVariable(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteServerVariable(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(17);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public String getServerConfigClob(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(226);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsString(21L);
    }

    public void setServerConfigClob(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(225);
        msg.setVariable(20L, name);
        msg.setVariable(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void subscribe(int channels) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(138);
        msg.setVariableInt32(13L, channels);
        msg.setVariableInt16(172L, 1);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unsubscribe(int channels) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(138);
        msg.setVariableInt32(13L, channels);
        msg.setVariableInt16(172L, 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void syncUserDatabase() throws IOException, NXCException {
        this.syncUserDB.acquireUninterruptibly();
        NXCPMessage msg = this.newMessage(30);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForSync(this.syncUserDB, this.commandTimeout * 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUserObject findUserDBObjectById(long id) {
        AbstractUserObject object;
        Map<Long, AbstractUserObject> map = this.userDB;
        synchronized (map) {
            object = this.userDB.get(id);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUserObject[] getUserDatabaseObjects() {
        AbstractUserObject[] list;
        Map<Long, AbstractUserObject> map = this.userDB;
        synchronized (map) {
            Collection<AbstractUserObject> values = this.userDB.values();
            list = values.toArray(new AbstractUserObject[values.size()]);
        }
        return list;
    }

    private long createUserDBObject(String name, boolean isGroup) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(36);
        msg.setVariable(34L, name);
        msg.setVariableInt16(39L, isGroup ? 1 : 0);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(35L);
    }

    public long createUser(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, false);
    }

    public long createUserGroup(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, true);
    }

    public void deleteUserDBObject(long id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(35);
        msg.setVariableInt32(35L, (int)id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setUserPassword(long id, String newPassword, String oldPassword) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(40);
        msg.setVariableInt32(35L, (int)id);
        msg.setVariable(2L, newPassword);
        if (oldPassword != null) {
            msg.setVariable(349L, oldPassword);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyUserDBObject(AbstractUserObject object, int fields) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(34);
        msg.setVariableInt32(337L, fields);
        object.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyUserDBObject(AbstractUserObject object) throws IOException, NXCException {
        this.modifyUserDBObject(object, Integer.MAX_VALUE);
    }

    public void lockUserDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(37);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unlockUserDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(38);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setAttributeForCurrentUser(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(69);
        msg.setVariable(20L, name);
        msg.setVariable(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public String getAttributeForCurrentUser(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(68);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsString(21L);
    }

    public DciValue[] getLastValues(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(121);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(111L);
        DciValue[] list = new DciValue[count];
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            list[i] = DciValue.createFromMessage(nodeId, response, base);
            ++i;
            base += 50L;
        }
        return list;
    }

    public Table getTableLastValues(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(260);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariableInt32(43L, (int)dciId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Table(response);
    }

    public PerfTabDci[] getPerfTabItems(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(200);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(111L);
        PerfTabDci[] list = new PerfTabDci[count];
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            list[i] = new PerfTabDci(response, base);
            ++i;
            base += 10L;
        }
        return list;
    }

    public List<ThresholdViolationSummary> getThresholdSummary(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(262);
        msg.setVariableInt32(3L, (int)objectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ArrayList<ThresholdViolationSummary> list = new ArrayList<ThresholdViolationSummary>();
        long varId = 0x800000L;
        while (response.getVariableAsInt64(varId) != 0L) {
            ThresholdViolationSummary t = new ThresholdViolationSummary(response, varId);
            list.add(t);
            varId += (long)(50 * t.getDciList().size() + 2);
        }
        return list;
    }

    private int parseDataRows(byte[] input, DciData data) {
        NXCPDataInputStream inputStream = new NXCPDataInputStream(input);
        int rows = 0;
        try {
            inputStream.skipBytes(4);
            rows = inputStream.readInt();
            int dataType = inputStream.readInt();
            data.setDataType(dataType);
            block9: for (int i = 0; i < rows; ++i) {
                long timestamp = inputStream.readUnsignedInt() * 1000L;
                switch (dataType) {
                    case 0: {
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Long(inputStream.readInt())));
                        continue block9;
                    }
                    case 1: {
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Long(inputStream.readUnsignedInt())));
                        continue block9;
                    }
                    case 2: 
                    case 3: {
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Long(inputStream.readLong())));
                        continue block9;
                    }
                    case 5: {
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Double(inputStream.readDouble())));
                        continue block9;
                    }
                    case 4: {
                        int count;
                        StringBuilder sb = new StringBuilder(256);
                        for (count = 256; count > 0; --count) {
                            char ch = inputStream.readChar();
                            if (ch == '\u0000') {
                                --count;
                                break;
                            }
                            sb.append(ch);
                        }
                        inputStream.skipBytes(count * 2);
                        data.addDataRow(new DciDataRow(new Date(timestamp), sb.toString()));
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return rows;
    }

    private DciData getCollectedDataInternal(long nodeId, long dciId, String instance, String dataColumn, Date from, Date to, int maxRows) throws IOException, NXCException {
        int rowsReceived;
        NXCPMessage msg;
        if (instance != null) {
            msg = this.newMessage(261);
            msg.setVariable(116L, instance);
            msg.setVariable(413L, dataColumn);
        } else {
            msg = this.newMessage(49);
        }
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariableInt32(43L, (int)dciId);
        DciData data = new DciData(nodeId, dciId);
        int rowsRemaining = maxRows;
        int timeFrom = from != null ? (int)(from.getTime() / 1000L) : 0;
        int timeTo = to != null ? (int)(to.getTime() / 1000L) : 0;
        do {
            DciDataRow row;
            msg.setMessageId(this.requestId.getAndIncrement());
            msg.setVariableInt32(50L, maxRows);
            msg.setVariableInt32(51L, timeFrom);
            msg.setVariableInt32(52L, timeTo);
            this.sendMessage(msg);
            this.waitForRCC(msg.getMessageId());
            NXCPMessage response = this.waitForMessage(50, msg.getMessageId());
            if (!response.isBinaryMessage()) {
                throw new NXCException(46);
            }
            rowsReceived = this.parseDataRows(response.getBinaryData(), data);
            if (rowsRemaining != 0 && rowsRemaining <= 200000 || rowsReceived != 200000) continue;
            if (rowsRemaining > 0) {
                rowsRemaining -= rowsReceived;
            }
            if (to == null || (row = data.getLastValue()) == null) continue;
            timeTo = (int)(row.getTimestamp().getTime() / 1000L) - 1;
        } while (rowsReceived == 200000);
        return data;
    }

    public DciData getCollectedData(long nodeId, long dciId, Date from, Date to, int maxRows) throws IOException, NXCException {
        return this.getCollectedDataInternal(nodeId, dciId, null, null, from, to, maxRows);
    }

    public DciData getCollectedTableData(long nodeId, long dciId, String instance, String dataColumn, Date from, Date to, int maxRows) throws IOException, NXCException {
        if (instance == null || dataColumn == null) {
            throw new NXCException(12);
        }
        return this.getCollectedDataInternal(nodeId, dciId, instance, dataColumn, from, to, maxRows);
    }

    public void clearCollectedData(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(228);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariableInt32(43L, (int)dciId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Threshold[] getThresholds(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(238);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariableInt32(43L, (int)dciId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(54L);
        Threshold[] list = new Threshold[count];
        long varId = 0x20000000L;
        for (int i = 0; i < count; ++i) {
            list[i] = new Threshold(response, varId);
            varId += 20L;
        }
        return list;
    }

    public String[] resolveDciNames(long[] nodeIds, long[] dciIds) throws IOException, NXCException {
        if (nodeIds.length == 0) {
            return new String[0];
        }
        NXCPMessage msg = this.newMessage(174);
        msg.setVariableInt32(111L, nodeIds.length);
        msg.setVariable(229L, nodeIds);
        msg.setVariable(230L, dciIds);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        String[] result = new String[nodeIds.length];
        long varId = 0x40000000L;
        for (int i = 0; i < result.length; ++i) {
            result[i] = response.getVariableAsString(varId++);
        }
        return result;
    }

    public String[] resolveDciNames(Collection<ConditionDciInfo> dciList) throws IOException, NXCException {
        long[] nodeIds = new long[dciList.size()];
        long[] dciIds = new long[dciList.size()];
        int i = 0;
        for (ConditionDciInfo dci : dciList) {
            nodeIds[i] = dci.getNodeId();
            dciIds[i] = dci.getDciId();
            ++i;
        }
        return this.resolveDciNames(nodeIds, dciIds);
    }

    public String queryParameter(long nodeId, int origin, String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(102);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariableInt16(46L, origin);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsString(21L);
    }

    public Table queryAgentTable(long nodeId, String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(246);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Table(response);
    }

    public long createObject(NXCObjectCreationData data) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(55);
        msg.setVariableInt32(78L, (int)data.getParentId());
        msg.setVariableInt16(5L, data.getObjectClass());
        msg.setVariable(4L, data.getName());
        msg.setVariableInt32(147L, (int)data.getZoneId());
        if (data.getComments() != null) {
            msg.setVariable(82L, data.getComments());
        }
        switch (data.getObjectClass()) {
            case 2: {
                if (data.getPrimaryName() != null) {
                    msg.setVariable(397L, data.getPrimaryName());
                }
                msg.setVariable(8L, data.getIpAddress());
                msg.setVariable(9L, data.getIpNetMask());
                msg.setVariableInt16(15L, data.getAgentPort());
                msg.setVariableInt16(80L, data.getSnmpPort());
                msg.setVariableInt32(14L, data.getCreationFlags());
                msg.setVariableInt32(195L, (int)data.getAgentProxyId());
                msg.setVariableInt32(267L, (int)data.getSnmpProxyId());
                break;
            }
            case 21: {
                msg.setVariableInt16(357L, data.getMapType());
                msg.setVariableInt32(359L, (int)data.getSeedObjectId());
                break;
            }
            case 11: {
                msg.setVariableInt16(130L, data.getServiceType());
                msg.setVariableInt16(131L, data.getIpProtocol());
                msg.setVariableInt16(132L, data.getIpPort());
                msg.setVariable(133L, data.getRequest());
                msg.setVariable(134L, data.getResponse());
                msg.setVariableInt16(408L, data.isCreateStatusDci() ? 1 : 0);
                break;
            }
            case 29: {
                msg.setVariableInt32(393L, (int)data.getLinkedNodeId());
                break;
            }
            case 30: {
                msg.setVariableInt16(402L, data.isTemplate() ? 1 : 0);
                break;
            }
            case 3: {
                msg.setVariable(113L, data.getMacAddress().getValue());
                msg.setVariable(8L, data.getIpAddress());
                msg.setVariable(9L, data.getIpNetMask());
                msg.setVariableInt32(12L, data.getIfType());
                msg.setVariableInt32(11L, data.getIfIndex());
                msg.setVariableInt32(367L, data.getSlot());
                msg.setVariableInt32(368L, data.getPort());
                msg.setVariableInt16(407L, data.isPhysicalPort() ? 1 : 0);
            }
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(7);
        msg.setVariableInt32(3L, (int)objectId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        Map<Long, GenericObject> map = this.objectList;
        synchronized (map) {
            this.objectList.remove(objectId);
        }
        this.sendNotification(new NXCNotification(99, objectId));
    }

    public void modifyObject(NXCObjectModificationData data) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(8);
        msg.setVariableInt32(3L, (int)data.getObjectId());
        long flags = data.getFlags();
        if (flags == 0L) {
            return;
        }
        if ((flags & 1L) != 0L) {
            msg.setVariable(4L, data.getName());
        }
        if ((flags & 0x10000L) != 0L) {
            msg.setVariable(8L, data.getPrimaryIpAddress());
        }
        if ((flags & 2L) != 0L) {
            AccessListElement[] acl = data.getACL();
            msg.setVariableInt32(32L, acl.length);
            msg.setVariableInt16(33L, data.isInheritAccessRights() ? 1 : 0);
            long id1 = 4096L;
            long id2 = 8192L;
            for (int i = 0; i < acl.length; ++i) {
                msg.setVariableInt32(id1++, (int)acl[i].getUserId());
                msg.setVariableInt32(id2++, acl[i].getAccessRights());
            }
        }
        if ((flags & 4L) != 0L) {
            Map<String, String> attrList = data.getCustomAttributes();
            Iterator<String> it = attrList.keySet().iterator();
            long id = 0x70000000L;
            int count = 0;
            while (it.hasNext()) {
                String key = it.next();
                String value = attrList.get(key);
                msg.setVariable(id++, key);
                msg.setVariable(id++, value);
                ++count;
            }
            msg.setVariableInt32(309L, count);
        }
        if ((flags & 8L) != 0L) {
            msg.setVariable(321L, data.getAutoBindFilter());
        }
        if ((flags & 0x80L) != 0L) {
            msg.setVariable(27L, data.getDescription());
        }
        if ((flags & 0x40L) != 0L) {
            msg.setVariableInt32(178L, data.getVersion());
        }
        if ((flags & 0x20L) != 0L) {
            msg.setVariable(81L, data.getConfigFileContent());
        }
        if ((flags & 0x100L) != 0L) {
            msg.setVariableInt16(15L, data.getAgentPort());
        }
        if ((flags & 0x1000L) != 0L) {
            msg.setVariableInt32(195L, (int)data.getAgentProxy());
        }
        if ((flags & 0x200L) != 0L) {
            msg.setVariableInt16(16L, data.getAgentAuthMethod());
            msg.setVariable(17L, data.getAgentSecret());
        }
        if ((flags & 0x4000L) != 0L) {
            long[] nodes = data.getTrustedNodes();
            msg.setVariableInt32(306L, nodes.length);
            msg.setVariable(307L, nodes);
        }
        if ((flags & 0x400L) != 0L) {
            msg.setVariableInt16(6L, data.getSnmpVersion());
        }
        if ((flags & 0x800L) != 0L) {
            msg.setVariable(18L, data.getSnmpAuthName());
            msg.setVariable(89L, data.getSnmpAuthPassword());
            msg.setVariable(91L, data.getSnmpPrivPassword());
            int methods = data.getSnmpAuthMethod() | data.getSnmpPrivMethod() << 8;
            msg.setVariableInt16(84L, methods);
        }
        if ((flags & 0x2000L) != 0L) {
            msg.setVariableInt32(267L, (int)data.getSnmpProxy());
        }
        if ((flags & 0x20000L) != 0L) {
            msg.setVariableInt16(80L, data.getSnmpPort());
        }
        if ((flags & 0x400000L) != 0L) {
            msg.setVariableInt32(149L, (int)data.getIcmpProxy());
        }
        if ((flags & 0x8000L) != 0L) {
            GeoLocation gl = data.getGeolocation();
            msg.setVariableInt16(342L, gl.getType());
            msg.setVariable(343L, Double.valueOf(gl.getLatitude()));
            msg.setVariable(344L, Double.valueOf(gl.getLongitude()));
        }
        if ((flags & 0x40000L) != 0L) {
            msg.setVariableInt16(358L, data.getMapLayout());
        }
        if ((flags & 0x80000L) != 0L) {
            msg.setVariable(360L, data.getMapBackground());
            msg.setVariable(385L, Double.valueOf(data.getMapBackgroundLocation().getLatitude()));
            msg.setVariable(386L, Double.valueOf(data.getMapBackgroundLocation().getLongitude()));
            msg.setVariableInt16(387L, data.getMapBackgroundZoom());
            msg.setVariableInt32(424L, data.getMapBackgroundColor());
        }
        if ((flags & 0x200000L) != 0L) {
            msg.setVariable(379L, data.getImage());
        }
        if ((flags & 0x100000L) != 0L) {
            msg.setVariableInt32(361L, data.getMapElements().size());
            long varId = 0x10000000L;
            for (NetworkMapElement e : data.getMapElements()) {
                e.fillMessage(msg, varId);
                varId += 100L;
            }
            msg.setVariableInt32(214L, data.getMapLinks().size());
            varId = 0x40000000L;
            for (NetworkMapLink l : data.getMapLinks()) {
                l.fillMessage(msg, varId);
                varId += 10L;
            }
        }
        if ((flags & 0x800000L) != 0L) {
            msg.setVariableInt16(166L, data.getColumnCount());
        }
        if ((flags & 0x1000000L) != 0L) {
            msg.setVariableInt32(361L, data.getDashboardElements().size());
            long varId = 0x10000000L;
            for (DashboardElement e : data.getDashboardElements()) {
                e.fillMessage(msg, varId);
                varId += 10L;
            }
        }
        if ((flags & 0x2000000L) != 0L) {
            msg.setVariable(228L, data.getScript());
        }
        if ((flags & 0x4000000L) != 0L) {
            msg.setVariableInt32(223L, data.getActivationEvent());
        }
        if ((flags & 0x8000000L) != 0L) {
            msg.setVariableInt32(224L, data.getDeactivationEvent());
        }
        if ((flags & 0x10000000L) != 0L) {
            msg.setVariableInt32(225L, (int)data.getSourceObject());
        }
        if ((flags & 0x20000000L) != 0L) {
            msg.setVariableInt16(226L, data.getActiveStatus());
        }
        if ((flags & 0x40000000L) != 0L) {
            msg.setVariableInt16(227L, data.getInactiveStatus());
        }
        if ((flags & 0x80000000L) != 0L) {
            List<ConditionDciInfo> dciList = data.getDciList();
            msg.setVariableInt32(111L, dciList.size());
            long varId = 0x40000000L;
            for (ConditionDciInfo dci : dciList) {
                msg.setVariableInt32(varId++, (int)dci.getDciId());
                msg.setVariableInt32(varId++, (int)dci.getNodeId());
                msg.setVariableInt16(varId++, dci.getFunction());
                msg.setVariableInt16(varId++, dci.getPolls());
                varId += 6L;
            }
        }
        if ((flags & 0x100000000L) != 0L) {
            msg.setVariableInt32(389L, (int)data.getSubmapId());
        }
        if ((flags & 0x1000000000L) != 0L) {
            msg.setVariableInt16(130L, data.getServiceType());
        }
        if ((flags & 0x400000000L) != 0L) {
            msg.setVariableInt16(131L, data.getIpProtocol());
        }
        if ((flags & 0x800000000L) != 0L) {
            msg.setVariableInt16(132L, data.getIpPort());
        }
        if ((flags & 0x2000000000L) != 0L) {
            msg.setVariableInt32(135L, (int)data.getPollerNode());
        }
        if ((flags & 0x4000000000L) != 0L) {
            msg.setVariableInt16(299L, data.getRequiredPolls());
        }
        if ((flags & 0x8000000000L) != 0L) {
            msg.setVariable(133L, data.getRequest());
        }
        if ((flags & 0x10000000000L) != 0L) {
            msg.setVariable(134L, data.getResponse());
        }
        if ((flags & 0x20000000000L) != 0L) {
            msg.setVariableInt32(13L, data.getObjectFlags());
        }
        if ((flags & 0x40000000000L) != 0L) {
            msg.setVariableInt16(318L, data.getIfXTablePolicy());
        }
        if ((flags & 0x80000000000L) != 0L) {
            msg.setVariable(390L, data.getReportDefinition());
        }
        if ((flags & 0x100000000000L) != 0L) {
            msg.setVariableInt32(265L, data.getResourceList().size());
            long varId = 0x20000000L;
            for (ClusterResource r : data.getResourceList()) {
                msg.setVariableInt32(varId++, (int)r.getId());
                msg.setVariable(varId++, r.getName());
                msg.setVariable(varId++, r.getVirtualAddress());
                varId += 7L;
            }
        }
        if ((flags & 0x800000000000L) != 0L) {
            int count = data.getNetworkList().size();
            msg.setVariableInt32(263L, count);
            long[] subnets = new long[count * 2];
            int pos = 0;
            for (ClusterSyncNetwork n : data.getNetworkList()) {
                subnets[pos++] = this.int32FromInetAddress(n.getSubnetAddress());
                subnets[pos++] = this.int32FromInetAddress(n.getSubnetMask());
            }
            msg.setVariable(264L, subnets);
        }
        if ((flags & 0x200000000000L) != 0L) {
            msg.setVariable(397L, data.getPrimaryName());
        }
        if ((flags & 0x400000000000L) != 0L) {
            msg.setVariableInt16(160L, data.getStatusCalculationMethod());
            msg.setVariableInt16(183L, data.getStatusPropagationMethod());
            msg.setVariableInt16(184L, data.getFixedPropagatedStatus());
            msg.setVariableInt16(185L, data.getStatusShift());
            int[] transformation = data.getStatusTransformation();
            msg.setVariableInt16(186L, transformation[0]);
            msg.setVariableInt16(187L, transformation[1]);
            msg.setVariableInt16(188L, transformation[2]);
            msg.setVariableInt16(189L, transformation[3]);
            msg.setVariableInt16(190L, data.getStatusSingleThreshold());
            int[] thresholds = data.getStatusThresholds();
            msg.setVariableInt16(191L, thresholds[0]);
            msg.setVariableInt16(192L, thresholds[1]);
            msg.setVariableInt16(193L, thresholds[2]);
            msg.setVariableInt16(194L, thresholds[3]);
        }
        if ((flags & 0x1000000000000L) != 0L) {
            msg.setVariableInt16(416L, data.getExpectedState());
        }
        if ((flags & 0x10L) != 0L) {
            msg.setVariableInt32(417L, data.getLinkColor());
        }
        if ((flags & 0x2000000000000L) != 0L) {
            msg.setVariableInt32(423L, data.getConnectionRouting());
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setObjectName(long objectId, String name) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setName(name);
        this.modifyObject(data);
    }

    public void setObjectCustomAttributes(long objectId, Map<String, String> attrList) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setCustomAttributes(attrList);
        this.modifyObject(data);
    }

    public void setObjectACL(long objectId, AccessListElement[] acl, boolean inheritAccessRights) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setACL(acl);
        data.setInheritAccessRights(inheritAccessRights);
        this.modifyObject(data);
    }

    public void setReportDefinition(long objectId, String definition) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setReportDefinition(definition);
        this.modifyObject(data);
    }

    public void setReportDefinition(long objectId, File file) throws FileNotFoundException, IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setReportDefinition(file);
        this.modifyObject(data);
    }

    public void changeObjectZone(long objectId, long zoneId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(253);
        msg.setVariableInt32(3L, (int)objectId);
        msg.setVariableInt32(147L, (int)zoneId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void updateObjectComments(long objectId, String comments) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(185);
        msg.setVariableInt32(3L, (int)objectId);
        msg.setVariable(82L, comments);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setObjectManaged(long objectId, boolean isManaged) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(47);
        msg.setVariableInt32(3L, (int)objectId);
        msg.setVariableInt16(49L, isManaged ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    private void changeObjectBinding(long parentId, long childId, boolean bind, boolean removeDci) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(bind ? 58 : 59);
        msg.setVariableInt32(78L, (int)parentId);
        msg.setVariableInt32(79L, (int)childId);
        msg.setVariableInt16(152L, removeDci ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void bindObject(long parentId, long childId) throws IOException, NXCException {
        this.changeObjectBinding(parentId, childId, true, false);
    }

    public void unbindObject(long parentId, long childId) throws IOException, NXCException {
        this.changeObjectBinding(parentId, childId, false, false);
    }

    public void removeTemplate(long templateId, long nodeId, boolean removeDci) throws IOException, NXCException {
        this.changeObjectBinding(templateId, nodeId, false, removeDci);
    }

    public void applyTemplate(long templateId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(122);
        msg.setVariableInt32(109L, (int)templateId);
        msg.setVariableInt32(110L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void addClusterNode(long clusterId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(76);
        msg.setVariableInt32(78L, (int)clusterId);
        msg.setVariableInt32(79L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void removeClusterNode(long clusterId, long nodeId) throws IOException, NXCException {
        this.changeObjectBinding(clusterId, nodeId, false, true);
    }

    public NetworkMapPage queryLayer2Topology(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(205);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(138L);
        long[] idList = response.getVariableAsUInt32Array(139L);
        if (idList.length != count) {
            throw new NXCException(46);
        }
        NetworkMapPage page = new NetworkMapPage();
        for (int i = 0; i < count; ++i) {
            page.addElement(new NetworkMapObject(page.createElementId(), idList[i]));
        }
        count = response.getVariableAsInteger(214L);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            NetworkMapObject obj1 = page.findObjectElement(response.getVariableAsInt64(varId++));
            NetworkMapObject obj2 = page.findObjectElement(response.getVariableAsInt64(varId++));
            int type = response.getVariableAsInteger(varId++);
            String port1 = response.getVariableAsString(varId++);
            String port2 = response.getVariableAsString(varId++);
            if (obj1 != null && obj2 != null) {
                page.addLink(new NetworkMapLink("", type, obj1.getId(), obj2.getId(), port1, port2));
            }
            ++i;
            varId += 5L;
        }
        return page;
    }

    public void executeAction(long nodeId, String action) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(16);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(87L, action);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void wakeupNode(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(92);
        msg.setVariableInt32(3L, (int)objectId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public PhysicalComponent getNodePhysicalComponents(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(257);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new PhysicalComponent(response, 0x20000000L, null);
    }

    public NXCServerJob[] getServerJobList() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(54);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(330L);
        NXCServerJob[] jobList = new NXCServerJob[count];
        long baseVarId = 0x10000000L;
        int i = 0;
        while (i < count) {
            jobList[i] = new NXCServerJob(response, baseVarId);
            ++i;
            baseVarId += 10L;
        }
        return jobList;
    }

    public void cancelServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(137);
        msg.setVariableInt32(331L, (int)jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void holdServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(251);
        msg.setVariableInt32(331L, (int)jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unholdServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(252);
        msg.setVariableInt32(331L, (int)jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deployAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(142);
        msg.setVariableInt32(83L, (int)policyId);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void uninstallAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(60);
        msg.setVariableInt32(83L, (int)policyId);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public EventProcessingPolicy openEventProcessingPolicy() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(20);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int numRules = response.getVariableAsInteger(74L);
        EventProcessingPolicy policy = new EventProcessingPolicy(numRules);
        for (int i = 0; i < numRules; ++i) {
            response = this.waitForMessage(23, msg.getMessageId());
            policy.addRule(new EventProcessingPolicyRule(response));
        }
        return policy;
    }

    public void saveEventProcessingPolicy(EventProcessingPolicy epp) throws IOException, NXCException {
        List<EventProcessingPolicyRule> rules = epp.getRules();
        NXCPMessage msg = this.newMessage(22);
        msg.setVariableInt32(74L, rules.size());
        this.sendMessage(msg);
        long msgId = msg.getMessageId();
        this.waitForRCC(msgId);
        int id = 1;
        for (EventProcessingPolicyRule rule : rules) {
            msg = new NXCPMessage(23);
            msg.setMessageId(msgId);
            msg.setVariableInt32(67L, id++);
            rule.fillMessage(msg);
            this.sendMessage(msg);
        }
        if (rules.size() > 0) {
            this.waitForRCC(msgId);
        }
    }

    public void closeEventProcessingPolicy() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(21);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public DataCollectionConfiguration openDataCollectionConfiguration(long nodeId) throws IOException, NXCException {
        DataCollectionConfiguration cfg = new DataCollectionConfiguration(this, nodeId);
        cfg.open();
        return cfg;
    }

    public Log openServerLog(String logName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(61);
        msg.setVariable(171L, logName);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        Log log = new Log(this, response, logName);
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncEventTemplates() throws IOException, NXCException {
        List<EventTemplate> templates = this.getEventTemplates();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            this.eventTemplates.clear();
            for (EventTemplate t : templates) {
                this.eventTemplates.put(t.getCode(), t);
            }
            this.eventTemplatesNeedSync = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate[] getCachedEventTemplates() {
        EventTemplate[] events = null;
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            events = this.eventTemplates.values().toArray(new EventTemplate[this.eventTemplates.size()]);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate findEventTemplateByCode(long code) {
        EventTemplate e = null;
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            e = this.eventTemplates.get(code);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventTemplate> findMultipleEventTemplates(Long[] codes) {
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            Long[] arr$ = codes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long code = arr$[i$];
                EventTemplate e = this.eventTemplates.get(code);
                if (e == null) continue;
                list.add(e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventTemplate> findMultipleEventTemplates(long[] codes) {
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            for (long code : codes) {
                EventTemplate e = this.eventTemplates.get(code);
                if (e == null) continue;
                list.add(e);
            }
        }
        return list;
    }

    public List<EventTemplate> getEventTemplates() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(28);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        while (!(response = this.waitForMessage(27, msg.getMessageId())).isEndOfSequence()) {
            list.add(new EventTemplate(response));
        }
        return list;
    }

    public long generateEventCode() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(94);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(24L);
    }

    public void deleteEventTemplate(long eventCode) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(93);
        msg.setVariableInt32(24L, (int)eventCode);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyEventTemplate(EventTemplate evt) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(26);
        msg.setVariableInt32(24L, (int)evt.getCode());
        msg.setVariableInt32(25L, evt.getSeverity());
        msg.setVariableInt32(13L, evt.getFlags());
        msg.setVariable(20L, evt.getName());
        msg.setVariable(26L, evt.getMessage());
        msg.setVariable(27L, evt.getDescription());
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void sendEvent(long eventCode, String eventName, long objectId, String[] parameters, String userTag) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(19);
        msg.setVariableInt32(24L, (int)eventCode);
        if (eventName != null) {
            msg.setVariable(169L, eventName);
        }
        msg.setVariableInt32(3L, (int)objectId);
        msg.setVariable(298L, userTag != null ? userTag : "");
        msg.setVariableInt16(88L, parameters.length);
        long varId = 32768L;
        for (int i = 0; i < parameters.length; ++i) {
            msg.setVariable(varId++, parameters[i]);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void sendEvent(long eventCode, String[] parameters) throws IOException, NXCException {
        this.sendEvent(eventCode, null, 0L, parameters, null);
    }

    public void sendEvent(String eventName, String[] parameters) throws IOException, NXCException {
        this.sendEvent(0L, eventName, 0L, parameters, null);
    }

    public List<String> getSnmpCommunities() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(209);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(86L);
        ArrayList<String> list = new ArrayList<String>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            list.add(response.getVariableAsString(varId++));
        }
        return list;
    }

    public void updateSnmpCommunities(List<String> list) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(210);
        msg.setVariableInt32(86L, list.size());
        long varId = 0x10000000L;
        for (int i = 0; i < list.size(); ++i) {
            msg.setVariable(varId++, list.get(i));
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<SnmpUsmCredential> getSnmpUsmCredentials() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(236);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(174L);
        ArrayList<SnmpUsmCredential> list = new ArrayList<SnmpUsmCredential>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new SnmpUsmCredential(response, varId));
            ++i;
            varId += 10L;
        }
        return list;
    }

    public void updateSnmpUsmCredentials(List<SnmpUsmCredential> list) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(237);
        msg.setVariableInt32(174L, list.size());
        long varId = 0x10000000L;
        int i = 0;
        while (i < list.size()) {
            list.get(i).fillMessage(msg, varId);
            ++i;
            varId += 10L;
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public String getAgentConfig(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(116);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsString(159L);
    }

    public void updateAgentConfig(long nodeId, String config, boolean apply) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(117);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(159L, config);
        msg.setVariableInt16(163L, apply ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<AgentParameter> getSupportedParameters(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(118);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(137L);
        ArrayList<AgentParameter> list = new ArrayList<AgentParameter>(count);
        long baseId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            list.add(new AgentParameter(response, baseId));
            baseId += 3L;
        }
        return list;
    }

    public long[] getDataCollectionEvents(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(191);
        msg.setVariableInt32(3L, (int)objectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        if (response.getVariableAsInteger(69L) == 0) {
            return new long[0];
        }
        return response.getVariableAsUInt32Array(255L);
    }

    public String exportConfiguration(String description, long[] events, long[] traps, long[] templates) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(192);
        msg.setVariable(27L, description);
        msg.setVariableInt32(69L, events.length);
        msg.setVariable(255L, events);
        msg.setVariableInt32(138L, templates.length);
        msg.setVariable(139L, templates);
        msg.setVariableInt32(256L, traps.length);
        msg.setVariable(257L, traps);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsString(258L);
    }

    public void importConfiguration(String config, int flags) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(193);
        msg.setVariable(258L, config);
        msg.setVariableInt32(13L, flags);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Map<String, Object> getServerStats() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(151);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("VERSION", response.getVariableAsString(121L));
        stats.put("UPTIME", response.getVariableAsInteger(200L));
        stats.put("SESSION_COUNT", response.getVariableAsInteger(205L));
        stats.put("DCI_COUNT", response.getVariableAsInteger(111L));
        stats.put("OBJECT_COUNT", response.getVariableAsInteger(138L));
        stats.put("NODE_COUNT", response.getVariableAsInteger(179L));
        stats.put("PHYSICAL_MEMORY_USED", response.getVariableAsInteger(203L));
        stats.put("VIRTUAL_MEMORY_USED", response.getVariableAsInteger(204L));
        stats.put("QSIZE_CONDITION_POLLER", response.getVariableAsInteger(285L));
        stats.put("QSIZE_CONF_POLLER", response.getVariableAsInteger(286L));
        stats.put("QSIZE_DCI_POLLER", response.getVariableAsInteger(287L));
        stats.put("QSIZE_DBWRITER", response.getVariableAsInteger(288L));
        stats.put("QSIZE_EVENT", response.getVariableAsInteger(289L));
        stats.put("QSIZE_DISCOVERY", response.getVariableAsInteger(290L));
        stats.put("QSIZE_NODE_POLLER", response.getVariableAsInteger(291L));
        stats.put("QSIZE_ROUTE_POLLER", response.getVariableAsInteger(292L));
        stats.put("QSIZE_STATUS_POLLER", response.getVariableAsInteger(293L));
        stats.put("ALARM_COUNT", response.getVariableAsInteger(201L));
        stats.put("ALARMS_BY_SEVERITY", response.getVariableAsUInt32Array(202L));
        return stats;
    }

    public List<ServerAction> getActions() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(78);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<ServerAction> actions = new ArrayList<ServerAction>();
        while ((response = this.waitForMessage(83, msg.getMessageId())).getVariableAsInt64(97L) != 0L) {
            actions.add(new ServerAction(response));
        }
        return actions;
    }

    public long createAction(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(81);
        msg.setVariable(87L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(97L);
    }

    public void modifyAction(ServerAction action) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(80);
        action.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteAction(long actionId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(82);
        msg.setVariableInt32(97L, (int)actionId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<ObjectTool> getObjectTools() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(15);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(164L);
        ArrayList<ObjectTool> list = new ArrayList<ObjectTool>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            list.add(new ObjectTool(response, varId));
            varId += 10L;
        }
        return list;
    }

    public ObjectToolDetails getObjectToolDetails(long toolId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(144);
        msg.setVariableInt32(165L, (int)toolId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new ObjectToolDetails(response);
    }

    public long generateObjectToolId() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(150);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(165L);
    }

    public void modifyObjectTool(ObjectToolDetails tool) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(147);
        tool.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteObjectTool(long toolId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(148);
        msg.setVariableInt32(165L, (int)toolId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Table executeTableTool(long toolId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(135);
        msg.setVariableInt32(165L, (int)toolId);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        NXCPMessage response = this.waitForMessage(136, msg.getMessageId(), 300000);
        return new Table(response);
    }

    public void executeServerCommand(long objectId, String command) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(145);
        msg.setVariableInt32(3L, (int)objectId);
        msg.setVariable(145L, command);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<SnmpTrap> getSnmpTrapsConfigurationSummary() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(194);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(256L);
        ArrayList<SnmpTrap> list = new ArrayList<SnmpTrap>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            list.add(new SnmpTrap(response, varId));
            varId += 10L;
        }
        return list;
    }

    public List<SnmpTrap> getSnmpTrapsConfiguration() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(100);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<SnmpTrap> traps = new ArrayList<SnmpTrap>();
        while ((response = this.waitForMessage(101, msg.getMessageId())).getVariableAsInt64(117L) != 0L) {
            traps.add(new SnmpTrap(response));
        }
        return traps;
    }

    public long createSnmpTrapConfiguration() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(97);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(117L);
    }

    public void deleteSnmpTrapConfiguration(long trapId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(99);
        msg.setVariableInt32(117L, (int)trapId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifySnmpTrapConfiguration(SnmpTrap trap) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(98);
        trap.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Date getMibFileTimestamp() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(51);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Date(response.getVariableAsInt64(94L) * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadMibFile() throws IOException, NXCException {
        NXCReceivedFile file;
        NXCPMessage msg = this.newMessage(52);
        this.sendMessage(msg);
        int ttw = 120;
        do {
            Map<Long, NXCReceivedFile> map = this.receivedFiles;
            synchronized (map) {
                file = this.receivedFiles.get(msg.getMessageId());
                if (file != null && file.getStatus() != 0) {
                    this.receivedFiles.remove(file.getId());
                    break;
                }
                try {
                    this.receivedFiles.wait(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        } while (--ttw > 0);
        if (ttw == 0) {
            throw new NXCException(4);
        }
        if (file.getStatus() == 2) {
            throw file.getException();
        }
        return file.getFile();
    }

    public List<GraphSettings> getPredefinedGraphs() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(197);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(273L);
        ArrayList<GraphSettings> list = new ArrayList<GraphSettings>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            list.add(new GraphSettings(response, varId));
            varId += 10L;
        }
        return list;
    }

    public long modifyPredefinedGraph(GraphSettings graph) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(198);
        msg.setVariableInt32(274L, (int)graph.getId());
        msg.setVariable(20L, graph.getName());
        msg.setVariable(272L, graph.getConfig());
        msg.setVariableInt32(32L, graph.getAccessList().size());
        long varId = 0x20000000L;
        for (AccessListElement e : graph.getAccessList()) {
            msg.setVariableInt32(varId++, (int)e.getUserId());
            msg.setVariableInt32(varId++, e.getAccessRights());
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(274L);
    }

    public void deletePredefinedGraph(long graphId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(199);
        msg.setVariableInt32(274L, (int)graphId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<Script> getScriptLibrary() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(152);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(206L);
        ArrayList<Script> scripts = new ArrayList<Script>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            long id = response.getVariableAsInt64(varId++);
            String name = response.getVariableAsString(varId++);
            scripts.add(new Script(id, name, null));
        }
        return scripts;
    }

    public Script getScript(long scriptId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(153);
        msg.setVariableInt32(207L, (int)scriptId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Script(scriptId, response.getVariableAsString(20L), response.getVariableAsString(208L));
    }

    public long modifyScript(long scriptId, String name, String source) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(154);
        msg.setVariableInt32(207L, (int)scriptId);
        msg.setVariable(20L, name);
        msg.setVariable(208L, source);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(207L);
    }

    public void renameScript(long scriptId, String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(156);
        msg.setVariableInt32(207L, (int)scriptId);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteScript(long scriptId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(155);
        msg.setVariableInt32(207L, (int)scriptId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public ConnectionPoint findConnectionPoint(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(95);
        msg.setVariableInt32(3L, (int)objectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        if (response.getVariableAsInt64(3L) != 0L) {
            return new ConnectionPoint(response);
        }
        return null;
    }

    public ConnectionPoint findConnectionPoint(MacAddress macAddr) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(96);
        msg.setVariable(113L, macAddr.getValue());
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        if (response.getVariableAsInt64(3L) != 0L) {
            return new ConnectionPoint(response);
        }
        return null;
    }

    public ConnectionPoint findConnectionPoint(int zoneId, InetAddress ipAddr) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(264);
        msg.setVariableInt32(147L, zoneId);
        msg.setVariable(8L, ipAddr);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        if (response.getVariableAsInt64(3L) != 0L) {
            return new ConnectionPoint(response);
        }
        return null;
    }

    public void checkConnection() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(3);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<LibraryImage> getImageLibrary() throws IOException, NXCException {
        return this.getImageLibrary(null);
    }

    public List<LibraryImage> getImageLibrary(String category) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(243);
        if (category != null) {
            msg.setVariable(75L, category);
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int numOfImages = response.getVariableAsInteger(174L);
        ArrayList<LibraryImage> ret = new ArrayList<LibraryImage>(numOfImages);
        long varId = 0x10000000L;
        for (int i = 0; i < numOfImages; ++i) {
            UUID imageGuid = response.getVariableAsUUID(varId++);
            String imageName = response.getVariableAsString(varId++);
            String imageCategory = response.getVariableAsString(varId++);
            String imageMimeType = response.getVariableAsString(varId++);
            boolean imageProtected = response.getVariableAsBoolean(varId++);
            ret.add(new LibraryImage(imageGuid, imageName, imageCategory, imageMimeType, imageProtected));
        }
        return ret;
    }

    public LibraryImage getImage(UUID guid) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(239);
        msg.setVariable(222L, guid);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        File imageFile = this.waitForFile(msg.getMessageId(), 600000);
        if (imageFile == null) {
            throw new NXCException(16);
        }
        return new LibraryImage(response, imageFile);
    }

    public LibraryImage createImage(LibraryImage image, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(240);
        image.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        UUID imageGuid = response.getVariableAsUUID(222L);
        image.setGuid(imageGuid);
        this.sendFile(msg.getMessageId(), image.getBinaryData(), listener);
        this.waitForRCC(msg.getMessageId());
        return image;
    }

    public void deleteImage(LibraryImage image) throws IOException, NXCException {
        if (image.isProtected()) {
            throw new NXCException(3);
        }
        NXCPMessage msg = this.newMessage(241);
        image.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyImage(LibraryImage image, ProgressListener listener) throws IOException, NXCException {
        if (image.isProtected()) {
            throw new NXCException(3);
        }
        NXCPMessage msg = this.newMessage(240);
        image.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.sendFile(msg.getMessageId(), image.getBinaryData(), listener);
        this.waitForRCC(msg.getMessageId());
    }

    public void pollNode(long nodeId, int pollType, NodePollListener listener) throws IOException, NXCException {
        int rcc;
        NXCPMessage msg = this.newMessage(89);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariableInt16(107L, pollType);
        this.sendMessage(msg);
        do {
            NXCPMessage response;
            if ((rcc = (response = this.waitForMessage(90, msg.getMessageId(), 120000)).getVariableAsInteger(28L)) != 23 || listener == null) continue;
            listener.onPollerMessage(response.getVariableAsString(108L));
        } while (rcc == 23);
    }

    public List<Situation> getSituations() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(211);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(305L);
        ArrayList<Situation> list = new ArrayList<Situation>(count);
        for (int i = 0; i < count; ++i) {
            response = this.waitForMessage(216, msg.getMessageId());
            list.add(new Situation(response));
        }
        return list;
    }

    public long createSituation(String name, String comments) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(213);
        msg.setVariable(20L, name);
        msg.setVariable(82L, comments);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(301L);
    }

    public void modifySituation(long id, String name, String comments) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(215);
        msg.setVariableInt32(301L, (int)id);
        if (name != null) {
            msg.setVariable(20L, name);
        }
        if (comments != null) {
            msg.setVariable(82L, comments);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteSituation(long id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(212);
        msg.setVariableInt32(301L, (int)id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteSituationInstance(long id, String instance) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(214);
        msg.setVariableInt32(301L, (int)id);
        msg.setVariable(302L, instance);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public ServerFile[] listServerFiles() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(244);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(304L);
        ServerFile[] files = new ServerFile[count];
        long varId = 0x20000000L;
        for (int i = 0; i < count; ++i) {
            files[i] = new ServerFile(response, varId);
            varId += 10L;
        }
        return files;
    }

    public long uploadFileToAgent(long nodeId, String serverFileName, String remoteFileName, boolean jobOnHold) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(146);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(125L, serverFileName);
        if (remoteFileName != null) {
            msg.setVariable(377L, remoteFileName);
        }
        msg.setVariableInt16(383L, jobOnHold ? 1 : 0);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(331L);
    }

    public void uploadFileToServer(File localFile, String serverFileName, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(219);
        msg.setVariable(125L, serverFileName);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.sendFile(msg.getMessageId(), localFile, listener);
    }

    public File downloadFileFromAgent(long nodeId, String remoteFileName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(254);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(125L, remoteFileName);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForRCC(msg.getMessageId());
        return this.waitForFile(msg.getMessageId(), 3600000);
    }

    public void deleteServerFile(String serverFileName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(220);
        msg.setVariable(125L, serverFileName);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void openConsole() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(247);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.serverConsoleConnected = true;
    }

    public void closeConsole() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(248);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.serverConsoleConnected = false;
    }

    public boolean processConsoleCommand(String command) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(128);
        msg.setVariable(145L, command);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId(), 3600000);
        return response.isEndOfSequence();
    }

    public boolean isServerConsoleConnected() {
        return this.serverConsoleConnected;
    }

    public void snmpWalk(long nodeId, String rootOid, SnmpWalkListener listener) throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(161);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(19L, rootOid);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        do {
            response = this.waitForMessage(162, msg.getMessageId());
            int count = response.getVariableAsInteger(144L);
            ArrayList<SnmpValue> data = new ArrayList<SnmpValue>(count);
            long varId = 0x10000000L;
            for (int i = 0; i < count; ++i) {
                String name = response.getVariableAsString(varId++);
                int type = response.getVariableAsInteger(varId++);
                String value = response.getVariableAsString(varId++);
                data.add(new SnmpValue(name, type, value));
            }
            listener.onSnmpWalkData(data);
        } while (!response.isEndOfSequence());
    }

    public List<VlanInfo> getVlans(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(250);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(382L);
        ArrayList<VlanInfo> vlans = new ArrayList<VlanInfo>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            vlans.add(new VlanInfo(response, varId));
            varId += 10L;
        }
        return vlans;
    }

    public boolean isObjectsSynchronized() {
        return this.objectsSynchronized;
    }

    public long executeReport(long reportId, Map<String, String> parameters) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(223);
        msg.setVariableInt32(3L, (int)reportId);
        msg.setVariableInt32(137L, parameters.size());
        long varId = 0x10000000L;
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            msg.setVariable(varId++, e.getKey());
            msg.setVariable(varId++, e.getValue());
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(331L);
    }

    public List<ReportResult> getReportResults(long reportId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(224);
        msg.setVariableInt32(3L, (int)reportId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(167L);
        ArrayList<ReportResult> results = new ArrayList<ReportResult>(count);
        long varId = 0x30000000L;
        for (int i = 0; i < count; ++i) {
            results.add(new ReportResult(response, varId));
            varId += 10L;
        }
        return results;
    }

    public void deleteReportResults(long reportId, Collection<Long> resultIdList) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(221);
        msg.setVariableInt32(3L, (int)reportId);
        msg.setVariableInt32(398L, resultIdList.size());
        msg.setVariable(399L, resultIdList.toArray(new Long[resultIdList.size()]));
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public File renderReport(long jobId, ReportRenderFormat format) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(222);
        msg.setVariableInt32(331L, (int)jobId);
        msg.setVariableInt32(400L, format.getCode());
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        File file = this.waitForFile(msg.getMessageId(), 600000);
        if (file == null) {
            throw new NXCException(16);
        }
        return file;
    }

    public List<IpAddressListElement> getAddressList(int listId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(188);
        msg.setVariableInt32(252L, listId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(174L);
        ArrayList<IpAddressListElement> list = new ArrayList<IpAddressListElement>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            list.add(new IpAddressListElement(response, varId));
            varId += 10L;
        }
        return list;
    }

    public void setAddressList(int listId, List<IpAddressListElement> list) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(189);
        msg.setVariableInt32(252L, listId);
        msg.setVariableInt32(174L, list.size());
        long varId = 0x10000000L;
        for (IpAddressListElement e : list) {
            msg.setVariableInt32(varId++, e.getType());
            msg.setVariable(varId++, e.getAddr1());
            msg.setVariable(varId++, e.getAddr2());
            varId += 7L;
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void resetServerComponent(int component) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(190);
        msg.setVariableInt32(253L, component);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public NetworkPath getNetworkPath(long node1, long node2) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(129);
        msg.setVariableInt32(109L, (int)node1);
        msg.setVariableInt32(110L, (int)node2);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new NetworkPath(response);
    }

    public void removePackage(long packageId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(110);
        msg.setVariableInt32(126L, (int)packageId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public long installPackage(PackageInfo info, File pkgFile, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(111);
        info.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        long id = response.getVariableAsInt64(126L);
        this.sendFile(msg.getMessageId(), pkgFile, listener);
        this.waitForRCC(msg.getMessageId());
        return id;
    }

    public List<PackageInfo> getInstalledPackages() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(108);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
        while ((response = this.waitForMessage(109, msg.getMessageId())).getVariableAsInt64(126L) != 0L) {
            list.add(new PackageInfo(response));
        }
        return list;
    }

    public void deployPackage(long packageId, Long[] nodeList, PackageDeploymentListener listener) throws IOException, NXCException {
        NXCPMessage response;
        int status;
        NXCPMessage msg = this.newMessage(119);
        msg.setVariableInt32(126L, (int)packageId);
        msg.setVariableInt32(138L, nodeList.length);
        msg.setVariable(139L, nodeList);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        if (listener != null) {
            listener.deploymentStarted();
        }
        while ((status = (response = this.waitForMessage(120, msg.getMessageId(), 600000)).getVariableAsInteger(140L)) != 255) {
            if (listener == null) continue;
            if (status == 4) {
                listener.statusUpdate(response.getVariableAsInt64(3L), status, response.getVariableAsString(141L));
                continue;
            }
            listener.statusUpdate(response.getVariableAsInt64(3L), status, "");
        }
        if (listener != null) {
            listener.deploymentComplete();
        }
    }

    public void lockPackageDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(112);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unlockPackageDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(113);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void sendSMS(String phoneNumber, String message) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(208);
        msg.setVariable(102L, phoneNumber);
        msg.setVariable(26L, message);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void pushDciData(DciPushData[] data) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(187);
        msg.setVariableInt32(111L, data.length);
        long varId = 0x10000000L;
        for (DciPushData d : data) {
            msg.setVariableInt32(varId++, (int)d.nodeId);
            if (d.nodeId == 0L) {
                msg.setVariable(varId++, d.nodeName);
            }
            msg.setVariableInt32(varId++, (int)d.dciId);
            if (d.dciId == 0L) {
                msg.setVariable(varId++, d.dciName);
            }
            msg.setVariable(varId++, d.value);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void pushDciData(long nodeId, long dciId, String value) throws IOException, NXCException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeId, dciId, value)});
    }

    public void pushDciData(String nodeName, String dciName, String value) throws IOException, NXCException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeName, dciName, value)});
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    private class HousekeeperThread
    extends Thread {
        private boolean stopFlag = false;

        HousekeeperThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopFlag) {
                try {
                    HousekeeperThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Map map = NXCSession.this.receivedFiles;
                synchronized (map) {
                    long currTime = System.currentTimeMillis();
                    Iterator it = NXCSession.this.receivedFiles.values().iterator();
                    while (it.hasNext()) {
                        NXCReceivedFile file = (NXCReceivedFile)it.next();
                        if (file.getTimestamp() + 300000L >= currTime) continue;
                        file.getFile().delete();
                        it.remove();
                    }
                }
            }
        }

        public void setStopFlag(boolean stopFlag) {
            this.stopFlag = stopFlag;
        }
    }

    private class ReceiverThread
    extends Thread {
        ReceiverThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream in;
            NXCPMessageReceiver receiver = new NXCPMessageReceiver(NXCSession.this.recvBufferSize);
            try {
                in = NXCSession.this.connSocket.getInputStream();
            }
            catch (IOException e) {
                return;
            }
            block38: while (NXCSession.this.connSocket.isConnected()) {
                try {
                    NXCPMessage msg = receiver.receiveMessage(in, NXCSession.this.encryptionContext);
                    switch (msg.getMessageCode()) {
                        case 130: {
                            NXCSession.this.setupEncryption(msg);
                            break;
                        }
                        case 6: 
                        case 10: {
                            GenericObject obj = NXCSession.this.createObjectFromMessage(msg);
                            Map map = NXCSession.this.objectList;
                            synchronized (map) {
                                if (obj.isDeleted()) {
                                    NXCSession.this.objectList.remove(obj.getObjectId());
                                } else {
                                    NXCSession.this.objectList.put(obj.getObjectId(), obj);
                                }
                            }
                            if (msg.getMessageCode() != 10) continue block38;
                            if (obj.isDeleted()) {
                                NXCSession.this.sendNotification(new NXCNotification(99, obj.getObjectId()));
                                break;
                            }
                            NXCSession.this.sendNotification(new NXCNotification(4, obj.getObjectId(), obj));
                            break;
                        }
                        case 9: {
                            NXCSession.this.completeSync(NXCSession.this.syncObjects);
                            break;
                        }
                        case 31: {
                            User user = new User(msg);
                            Map map = NXCSession.this.userDB;
                            synchronized (map) {
                                if (user.isDeleted()) {
                                    NXCSession.this.userDB.remove(user.getId());
                                } else {
                                    NXCSession.this.userDB.put(user.getId(), user);
                                }
                                break;
                            }
                        }
                        case 32: {
                            UserGroup group = new UserGroup(msg);
                            Map map = NXCSession.this.userDB;
                            synchronized (map) {
                                if (group.isDeleted()) {
                                    NXCSession.this.userDB.remove(group.getId());
                                } else {
                                    NXCSession.this.userDB.put(group.getId(), group);
                                }
                                break;
                            }
                        }
                        case 33: {
                            NXCSession.this.completeSync(NXCSession.this.syncUserDB);
                            break;
                        }
                        case 39: {
                            this.processUserDBUpdate(msg);
                            break;
                        }
                        case 73: {
                            NXCSession.this.sendNotification(new NXCNotification(msg.getVariableAsInteger(23L) + 1000, new Alarm(msg)));
                            break;
                        }
                        case 141: {
                            NXCSession.this.sendNotification(new NXCNotification(10, new NXCServerJob(msg)));
                            break;
                        }
                        case 105: {
                            this.processFileData(msg);
                            break;
                        }
                        case 114: {
                            this.processFileTransferError(msg);
                            break;
                        }
                        case 18: {
                            this.processNotificationMessage(msg);
                            break;
                        }
                        case 12: {
                            this.processNewEvents(msg);
                            break;
                        }
                        case 160: {
                            this.processNewTraps(msg);
                            break;
                        }
                        case 140: {
                            this.processSyslogRecords(msg);
                            break;
                        }
                        case 79: {
                            this.processActionConfigChange(msg);
                            break;
                        }
                        case 24: {
                            this.processEventConfigChange(msg);
                            break;
                        }
                        case 25: {
                            this.processTrapConfigChange(msg);
                            break;
                        }
                        case 217: {
                            this.processSituationChange(msg);
                            break;
                        }
                        case 127: {
                            this.processConsoleOutput(msg);
                            break;
                        }
                        case 256: {
                            this.processImageLibraryUpdate(msg);
                            break;
                        }
                        default: {
                            if (msg.getMessageCode() >= 4096) {
                                NXCSession.this.sendNotification(new NXCNotification(2000, msg));
                            }
                            NXCSession.this.msgWaitQueue.putMessage(msg);
                        }
                    }
                }
                catch (IOException e) {
                    break;
                }
                catch (NXCPException e) {
                    if (e.getErrorCode() != 2) continue;
                    break;
                }
                catch (NXCException e) {
                    if (e.getErrorCode() != 98) continue;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processConsoleOutput(NXCPMessage msg) {
            String text = msg.getVariableAsString(26L);
            Set set = NXCSession.this.consoleListeners;
            synchronized (set) {
                for (ServerConsoleListener l : NXCSession.this.consoleListeners) {
                    l.onConsoleOutput(text);
                }
            }
        }

        private void processNewEvents(NXCPMessage msg) {
            int count = msg.getVariableAsInteger(174L);
            int order = msg.getVariableAsInteger(210L);
            long varId = 0x10000000L;
            for (int i = 0; i < count; ++i) {
                Event event = new Event(msg, varId);
                NXCSession.this.sendNotification(new NXCNotification(2, order, event));
            }
        }

        private void processNewTraps(NXCPMessage msg) {
            int count = msg.getVariableAsInteger(174L);
            int order = msg.getVariableAsInteger(210L);
            long varId = 0x10000000L;
            for (int i = 0; i < count; ++i) {
                SnmpTrapLogRecord trap = new SnmpTrapLogRecord(msg, varId);
                NXCSession.this.sendNotification(new NXCNotification(8, order, trap));
            }
        }

        private void processSyslogRecords(NXCPMessage msg) {
            int count = msg.getVariableAsInteger(174L);
            int order = msg.getVariableAsInteger(210L);
            long varId = 0x10000000L;
            for (int i = 0; i < count; ++i) {
                SyslogRecord record = new SyslogRecord(msg, varId);
                NXCSession.this.sendNotification(new NXCNotification(7, order, record));
            }
        }

        private void processNotificationMessage(NXCPMessage msg) {
            int code = msg.getVariableAsInteger(23L) + 1000;
            int data = msg.getVariableAsInteger(92L);
            NXCSession.this.sendNotification(new NXCNotification(code, data));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileData(NXCPMessage msg) {
            NXCReceivedFile file;
            long id = msg.getMessageId();
            Map map = NXCSession.this.receivedFiles;
            synchronized (map) {
                file = (NXCReceivedFile)NXCSession.this.receivedFiles.get(id);
                if (file == null) {
                    file = new NXCReceivedFile(id);
                    NXCSession.this.receivedFiles.put(id, file);
                }
            }
            file.writeData(msg.getBinaryData());
            if (msg.isEndOfFile()) {
                file.close();
                map = NXCSession.this.receivedFiles;
                synchronized (map) {
                    NXCSession.this.receivedFiles.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileTransferError(NXCPMessage msg) {
            long id = msg.getMessageId();
            Map map = NXCSession.this.receivedFiles;
            synchronized (map) {
                NXCReceivedFile file = (NXCReceivedFile)NXCSession.this.receivedFiles.get(id);
                if (file == null) {
                    file = new NXCReceivedFile(id);
                    NXCSession.this.receivedFiles.put(id, file);
                }
                file.close();
                NXCSession.this.receivedFiles.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUserDBUpdate(NXCPMessage msg) {
            int code = msg.getVariableAsInteger(42L);
            long id = msg.getVariableAsInt64(35L);
            UserGroup object = null;
            switch (code) {
                case 0: 
                case 2: {
                    object = (id & Integer.MIN_VALUE) != 0L ? new UserGroup(msg) : new User(msg);
                    Map map = NXCSession.this.userDB;
                    synchronized (map) {
                        NXCSession.this.userDB.put(id, object);
                        break;
                    }
                }
                case 1: {
                    Map map = NXCSession.this.userDB;
                    synchronized (map) {
                        object = (AbstractUserObject)NXCSession.this.userDB.get(id);
                        if (object != null) {
                            NXCSession.this.userDB.remove(id);
                        }
                        break;
                    }
                }
            }
            if (object != null) {
                NXCSession.this.sendNotification(new NXCNotification(3, code, object));
            }
        }

        private void processTrapConfigChange(NXCPMessage msg) {
            int code = msg.getVariableAsInteger(23L) + 1000;
            long id = msg.getVariableAsInt64(117L);
            SnmpTrap trap = code != 1018 ? new SnmpTrap(msg) : null;
            NXCSession.this.sendNotification(new NXCNotification(code, id, trap));
        }

        private void processSituationChange(NXCPMessage msg) {
            int code = msg.getVariableAsInteger(23L) + 100;
            Situation s = new Situation(msg);
            NXCSession.this.sendNotification(new NXCNotification(code, s.getId(), s));
        }

        private void processActionConfigChange(NXCPMessage msg) {
            int code = msg.getVariableAsInteger(23L) + 1000;
            long id = msg.getVariableAsInt64(97L);
            ServerAction action = code != 1008 ? new ServerAction(msg) : null;
            NXCSession.this.sendNotification(new NXCNotification(code, id, action));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEventConfigChange(NXCPMessage msg) {
            EventTemplate et;
            int code = msg.getVariableAsInteger(23L) + 1000;
            long eventCode = msg.getVariableAsInt64(24L);
            EventTemplate eventTemplate = et = code != 1014 ? new EventTemplate(msg) : null;
            if (NXCSession.this.eventTemplatesNeedSync) {
                Map map = NXCSession.this.eventTemplates;
                synchronized (map) {
                    if (code == 1014) {
                        NXCSession.this.eventTemplates.remove(eventCode);
                    } else {
                        NXCSession.this.eventTemplates.put(eventCode, et);
                    }
                }
            }
            NXCSession.this.sendNotification(new NXCNotification(code, eventCode, et));
        }

        public void processImageLibraryUpdate(NXCPMessage msg) {
            UUID imageGuid = msg.getVariableAsUUID(222L);
            NXCSession.this.sendNotification(new NXCNotification(1019, imageGuid));
        }
    }
}

