/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;

public class Node
extends GenericObject {
    public static final int SNMP_VERSION_1 = 0;
    public static final int SNMP_VERSION_2C = 1;
    public static final int SNMP_VERSION_3 = 3;
    public static final int AGENT_AUTH_NONE = 0;
    public static final int AGENT_AUTH_PLAINTEXT = 1;
    public static final int AGENT_AUTH_MD5 = 2;
    public static final int AGENT_AUTH_SHA1 = 3;
    public static final int NF_IS_SNMP = 1;
    public static final int NF_IS_NATIVE_AGENT = 2;
    public static final int NF_IS_BRIDGE = 4;
    public static final int NF_IS_ROUTER = 8;
    public static final int NF_IS_LOCAL_MGMT = 16;
    public static final int NF_IS_PRINTER = 32;
    public static final int NF_IS_OSPF = 64;
    public static final int NF_BEHIND_NAT = 128;
    public static final int NF_IS_CPSNMP = 256;
    public static final int NF_IS_CDP = 512;
    public static final int NF_IS_SONMP = 1024;
    public static final int NF_IS_LLDP = 2048;
    public static final int NF_IS_VRRP = 4096;
    public static final int NF_HAS_VLANS = 8192;
    public static final int NF_IS_8021X = 16384;
    public static final int NF_IS_STP = 32768;
    public static final int NF_HAS_ENTITY_MIB = 65536;
    public static final int NF_HAS_IFXTABLE = 131072;
    public static final int NF_DISABLE_DISCOVERY_POLL = 0x400000;
    public static final int NF_DISABLE_TOPOLOGY_POLL = 0x800000;
    public static final int NF_DISABLE_SNMP = 0x1000000;
    public static final int NF_DISABLE_NXCP = 0x2000000;
    public static final int NF_DISABLE_ICMP = 0x4000000;
    public static final int NF_FORCE_ENCRYPTION = 0x8000000;
    public static final int NF_DISABLE_STATUS_POLL = 0x10000000;
    public static final int NF_DISABLE_CONF_POLL = 0x20000000;
    public static final int NF_DISABLE_ROUTE_POLL = 0x40000000;
    public static final int NF_DISABLE_DATA_COLLECT = Integer.MIN_VALUE;
    public static final int NDF_UNREACHABLE = 4;
    public static final int NDF_AGENT_UNREACHABLE = 8;
    public static final int NDF_SNMP_UNREACHABLE = 16;
    public static final int NDF_CPSNMP_UNREACHABLE = 512;
    public static final int NDF_POLLING_DISABLED = 2048;
    public static final int IFXTABLE_DEFAULT = 0;
    public static final int IFXTABLE_ENABLED = 1;
    public static final int IFXTABLE_DISABLED = 2;
    private String primaryName;
    private int flags;
    private int runtimeFlags;
    private int nodeType;
    private int requredPollCount;
    private long pollerNodeId;
    private long proxyNodeId;
    private long snmpProxyId;
    private int agentPort;
    private int agentAuthMethod;
    private String agentSharedSecret;
    private String agentVersion;
    private String platformName;
    private String snmpAuthName;
    private String snmpAuthPassword;
    private String snmpPrivPassword;
    private int snmpAuthMethod;
    private int snmpPrivMethod;
    private String snmpOID;
    private int snmpVersion;
    private int snmpPort;
    private String snmpSysName;
    private String systemDescription;
    private String lldpNodeId;
    private int vrrpVersion;
    private String driverName;
    private String driverVersion;
    private long zoneId;
    private MacAddress bridgeBaseAddress;
    private int ifXTablePolicy;

    public Node(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.primaryName = msg.getVariableAsString(397L);
        this.flags = msg.getVariableAsInteger(13L);
        this.runtimeFlags = msg.getVariableAsInteger(355L);
        this.nodeType = msg.getVariableAsInteger(115L);
        this.requredPollCount = msg.getVariableAsInteger(299L);
        this.pollerNodeId = msg.getVariableAsInt64(135L);
        this.proxyNodeId = msg.getVariableAsInt64(195L);
        this.snmpProxyId = msg.getVariableAsInt64(267L);
        this.agentPort = msg.getVariableAsInteger(15L);
        this.agentAuthMethod = msg.getVariableAsInteger(16L);
        this.agentSharedSecret = msg.getVariableAsString(17L);
        this.agentVersion = msg.getVariableAsString(124L);
        this.platformName = msg.getVariableAsString(128L);
        this.snmpAuthName = msg.getVariableAsString(18L);
        this.snmpAuthPassword = msg.getVariableAsString(89L);
        this.snmpPrivPassword = msg.getVariableAsString(91L);
        int methods = msg.getVariableAsInteger(84L);
        this.snmpAuthMethod = methods & 0xFF;
        this.snmpPrivMethod = methods >> 8;
        this.snmpOID = msg.getVariableAsString(19L);
        this.snmpPort = msg.getVariableAsInteger(80L);
        this.snmpVersion = msg.getVariableAsInteger(6L);
        this.systemDescription = msg.getVariableAsString(300L);
        this.snmpSysName = msg.getVariableAsString(365L);
        this.lldpNodeId = msg.getVariableAsString(366L);
        this.vrrpVersion = msg.getVariableAsInteger(375L);
        this.driverName = msg.getVariableAsString(380L);
        this.driverVersion = msg.getVariableAsString(381L);
        this.zoneId = msg.getVariableAsInt64(147L);
        this.bridgeBaseAddress = new MacAddress(msg.getVariableAsBinary(388L));
        this.ifXTablePolicy = msg.getVariableAsInteger(318L);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getRuntimeFlags() {
        return this.runtimeFlags;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public int getRequredPollCount() {
        return this.requredPollCount;
    }

    public long getPollerNodeId() {
        return this.pollerNodeId;
    }

    public long getProxyNodeId() {
        return this.proxyNodeId;
    }

    public long getSnmpProxyId() {
        return this.snmpProxyId;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public int getAgentAuthMethod() {
        return this.agentAuthMethod;
    }

    public String getAgentSharedSecret() {
        return this.agentSharedSecret;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getSnmpAuthName() {
        return this.snmpAuthName;
    }

    public String getSnmpOID() {
        return this.snmpOID;
    }

    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    @Override
    public String getObjectClassName() {
        return "Node";
    }

    public String getSnmpAuthPassword() {
        return this.snmpAuthPassword;
    }

    public String getSnmpPrivPassword() {
        return this.snmpPrivPassword;
    }

    public int getSnmpAuthMethod() {
        return this.snmpAuthMethod;
    }

    public int getSnmpPrivMethod() {
        return this.snmpPrivMethod;
    }

    public boolean hasAgent() {
        return (this.flags & 2) != 0;
    }

    public boolean hasSnmpAgent() {
        return (this.flags & 1) != 0;
    }

    public boolean isManagementServer() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isVrrpSupported() {
        return (this.flags & 0x1000) != 0;
    }

    public boolean is8021xSupported() {
        return (this.flags & 0x4000) != 0;
    }

    public boolean isSpanningTreeSupported() {
        return (this.flags & 0x8000) != 0;
    }

    public boolean isEntityMibSupported() {
        return (this.flags & 0x10000) != 0;
    }

    public boolean isIfXTableSupported() {
        return (this.flags & 0x20000) != 0;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public String getSnmpSysName() {
        return this.snmpSysName;
    }

    public String getLldpNodeId() {
        return this.lldpNodeId;
    }

    protected int getVrrpVersion() {
        return this.vrrpVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public MacAddress getBridgeBaseAddress() {
        return this.bridgeBaseAddress;
    }

    public int getIfXTablePolicy() {
        return this.ifXTablePolicy;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }
}

