/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import com.jcraft.jzlib.ZInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.client.NXCException;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpObjectId;

public class MibTree {
    private static final byte[] MIB_FILE_MAGIC_NUMBER = new byte[]{78, 88, 77, 73, 66, 32};
    protected static final int SMT_COMPRESS_DATA = 1;
    protected static final int SMT_SKIP_DESCRIPTIONS = 2;
    private MibObject root;

    public MibTree() {
        this.root = new MibObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MibTree(File file) throws IOException, NXCException {
        block8: {
            NXCPDataInputStream in = new NXCPDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
            try {
                byte[] magic = new byte[6];
                int bytes = in.read(magic);
                if (bytes != 6 || !Arrays.equals(magic, MIB_FILE_MAGIC_NUMBER)) {
                    throw new NXCException(1001);
                }
                int headerSize = in.readUnsignedByte();
                in.skipBytes(1);
                int flags = in.readUnsignedShort();
                if ((flags & 1) != 0) {
                    in.close();
                    in = null;
                    BufferedInputStream bufferedInput = new BufferedInputStream(new FileInputStream(file));
                    bufferedInput.skip(headerSize);
                    in = new NXCPDataInputStream((InputStream)new ZInputStream(bufferedInput));
                } else {
                    in.skipBytes(headerSize - 10);
                }
                int tag = in.readUnsignedByte();
                if (tag == 1) {
                    this.root = new MibObject(in, null);
                    break block8;
                }
                throw new NXCException(1002);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public MibObject getRootObject() {
        return this.root;
    }

    public MibObject findObject(SnmpObjectId oid, boolean exactMatch) {
        MibObject result = this.root.findChildObject(oid);
        if (result != null && exactMatch && !oid.equals(result.getObjectId())) {
            return null;
        }
        return result;
    }
}

