/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.widgets.GeoMapViewer;
import org.netxms.ui.eclipse.osm.widgets.helpers.GeoMapListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public abstract class AbstractGeolocationView
extends ViewPart {
    public static final String JOB_FAMILY = "MapViewJob";
    protected GeoMapViewer map;
    private MapAccessor mapAccessor;
    private int zoomLevel = 15;
    private Action actionZoomIn;
    private Action actionZoomOut;

    protected abstract GeoLocation getInitialCenterPoint();

    protected abstract int getInitialZoomLevel();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            Platform.getAdapterManager().loadAdapter((Object)((NXCSession)ConsoleSharedData.getSession()).getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
    }

    public void createPartControl(Composite parent) {
        this.map = new GeoMapViewer(parent, 2048);
        this.map.setViewPart((IViewPart)this);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.mapAccessor = new MapAccessor(this.getInitialCenterPoint());
        this.zoomLevel = this.getInitialZoomLevel();
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.map.addMapListener(new GeoMapListener(){

            @Override
            public void onZoom(int zoomLevel) {
                AbstractGeolocationView.this.zoomLevel = zoomLevel;
                AbstractGeolocationView.this.mapAccessor.setZoom(zoomLevel);
                AbstractGeolocationView.this.actionZoomIn.setEnabled(zoomLevel < 18);
                AbstractGeolocationView.this.actionZoomOut.setEnabled(zoomLevel > 0);
            }

            @Override
            public void onPan(GeoLocation centerPoint) {
                AbstractGeolocationView.this.mapAccessor.setLatitude(centerPoint.getLatitude());
                AbstractGeolocationView.this.mapAccessor.setLongitude(centerPoint.getLongitude());
            }
        });
    }

    protected void createActions() {
        this.actionZoomIn = new Action(Messages.AbstractGeolocationView_ZoomIn){

            public void run() {
                AbstractGeolocationView.this.setZoomLevel(AbstractGeolocationView.this.zoomLevel + 1);
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        this.actionZoomOut = new Action(Messages.AbstractGeolocationView_ZoomOut){

            public void run() {
                AbstractGeolocationView.this.setZoomLevel(AbstractGeolocationView.this.zoomLevel - 1);
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractGeolocationView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.map);
        this.map.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    public void setFocus() {
        this.map.setFocus();
    }

    private void setZoomLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 18) {
            return;
        }
        this.zoomLevel = newLevel;
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.actionZoomIn.setEnabled(this.zoomLevel < 18);
        this.actionZoomOut.setEnabled(this.zoomLevel > 0);
    }

    protected MapAccessor getMapAccessor() {
        return this.mapAccessor;
    }
}

