/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.widgets.helpers;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserRule;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DashboardComposite;
import org.netxms.ui.eclipse.widgets.DashboardElement;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LogParserRuleEditor
extends DashboardComposite {
    private static final Color CONDITION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 198, 214, 172);
    private static final Color ACTION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 186, 176, 201);
    private static final Color TITLE_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private FormToolkit toolkit;
    private LogParserRule rule;
    private LabeledText regexp;
    private LabeledText severity;
    private LabeledText facility;
    private LabeledText tag;
    private EventSelector event;
    private Spinner eventParamCount;
    private LabeledText context;

    public LogParserRuleEditor(Composite parent, FormToolkit toolkit, LogParserRule rule) {
        super(parent, 2048);
        this.toolkit = toolkit;
        this.rule = rule;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)layout);
        DashboardElement condition = new DashboardElement((Composite)this, "Condition"){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(CONDITION_BORDER_COLOR);
                this.setTitleColor(TITLE_COLOR);
                return LogParserRuleEditor.this.createMatchingArea(parent);
            }
        };
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        condition.setLayoutData((Object)gd);
        DashboardElement action = new DashboardElement((Composite)this, "Action"){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(ACTION_BORDER_COLOR);
                this.setTitleColor(TITLE_COLOR);
                return LogParserRuleEditor.this.createActionArea(parent);
            }
        };
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        action.setLayoutData((Object)gd);
    }

    private Composite createMatchingArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        this.regexp = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.regexp);
        this.regexp.setLabel("Matching regular expression");
        this.regexp.setText(this.rule.getMatch());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.regexp.setLayoutData((Object)gd);
        this.severity = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.severity);
        this.severity.setLabel("Severity");
        this.severity.setText(Integer.toString(this.rule.getSeverity()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.severity.setLayoutData((Object)gd);
        this.facility = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.facility);
        this.facility.setLabel("Facility");
        this.facility.setText(Integer.toString(this.rule.getFacility()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.facility.setLayoutData((Object)gd);
        this.tag = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.tag);
        this.tag.setLabel("Syslog tag");
        this.tag.setText(this.rule.getTag());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.tag.setLayoutData((Object)gd);
        return area;
    }

    private Composite createActionArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        long eventCode = 0L;
        try {
            eventCode = Long.parseLong(this.rule.getEvent().getEvent());
        }
        catch (NumberFormatException numberFormatException) {}
        this.event = new EventSelector(area, 0, true);
        this.toolkit.adapt((Composite)this.event);
        this.event.setLabel("Generate event");
        this.event.setEventCode(eventCode);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.event.setLayoutData((Object)gd);
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new Spinner(parent, style);
            }
        };
        this.eventParamCount = (Spinner)WidgetHelper.createLabeledControl((Composite)area, (int)2048, (WidgetFactory)factory, (String)"Parameters", (Object)"WidgetHelper::default_layout_data");
        this.eventParamCount.setMinimum(0);
        this.eventParamCount.setMaximum(32);
        this.eventParamCount.setSelection(this.rule.getEvent().getParameterCount());
        this.context = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.context);
        this.context.setLabel("Activate context");
        this.context.setText(this.rule.getContextDefinition().getData());
        return area;
    }

    public void save() {
        this.rule.setMatch(this.regexp.getText());
        this.rule.setFacility(Integer.parseInt(this.facility.getText()));
        this.rule.setSeverity(Integer.parseInt(this.severity.getText()));
        this.rule.setTag(this.tag.getText());
        this.rule.getEvent().setEvent(Long.toString(this.event.getEventCode()));
        this.rule.getEvent().setParameterCount(this.eventParamCount.getSelection());
    }
}

