/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;
import org.netxms.ui.eclipse.objecttools.views.BrowserView;
import org.netxms.ui.eclipse.objecttools.views.FileViewer;
import org.netxms.ui.eclipse.objecttools.views.LocalCommandResults;
import org.netxms.ui.eclipse.objecttools.views.TableToolResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectToolsDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public ObjectToolsDynamicMenu() {
    }

    public ObjectToolsDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void fill(Menu menu, int index) {
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        final Set<Node> nodes = this.buildNodeSet((IStructuredSelection)selection);
        Menu toolsMenu = new Menu(menu);
        ObjectTool[] tools = ObjectToolsCache.getTools();
        Arrays.sort(tools, new Comparator<ObjectTool>(){

            @Override
            public int compare(ObjectTool arg0, ObjectTool arg1) {
                return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
            }
        });
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        int added = 0;
        int i = 0;
        while (i < tools.length) {
            boolean allowed = ObjectToolsDynamicMenu.isToolAllowed(tools[i], nodes);
            if (allowed && ObjectToolsDynamicMenu.isToolApplicable(tools[i], nodes)) {
                String[] path = tools[i].getName().split("\\-\\>");
                Menu rootMenu = toolsMenu;
                int j = 0;
                while (j < path.length - 1) {
                    String key = path[j].replace("&", "");
                    Menu currMenu = (Menu)menus.get(key);
                    if (currMenu == null) {
                        currMenu = new Menu(rootMenu);
                        MenuItem item = new MenuItem(rootMenu, 64);
                        item.setText(path[j]);
                        item.setMenu(currMenu);
                        menus.put(key, currMenu);
                    }
                    rootMenu = currMenu;
                    ++j;
                }
                final MenuItem item = new MenuItem(rootMenu, 8);
                item.setText(path[path.length - 1]);
                item.setData((Object)tools[i]);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ObjectToolsDynamicMenu.this.executeObjectTool(nodes, (ObjectTool)item.getData());
                    }
                });
                ++added;
            }
            ++i;
        }
        if (added > 0) {
            MenuItem toolsMenuItem = new MenuItem(menu, 64, index);
            toolsMenuItem.setText("&Tools");
            toolsMenuItem.setMenu(toolsMenu);
        } else {
            toolsMenu.dispose();
        }
    }

    private Set<Node> buildNodeSet(IStructuredSelection selection) {
        HashSet<Node> nodes = new HashSet<Node>();
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        for (Object o : selection.toList()) {
            GenericObject n2;
            if (o instanceof Node) {
                nodes.add((Node)o);
                continue;
            }
            if (o instanceof Container || o instanceof ServiceRoot || o instanceof Subnet || o instanceof Cluster) {
                for (GenericObject n2 : ((GenericObject)o).getAllChilds(2)) {
                    nodes.add((Node)n2);
                }
                continue;
            }
            if (!(o instanceof Alarm) || (n2 = (Node)session.findObjectById(((Alarm)o).getSourceObjectId(), Node.class)) == null) continue;
            nodes.add((Node)n2);
        }
        return nodes;
    }

    private static boolean isToolAllowed(ObjectTool tool, Set<Node> nodes) {
        if (tool.getType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            for (Node n : nodes) {
                if (handler.canExecuteOnNode(n, tool)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isToolApplicable(ObjectTool tool, Set<Node> nodes) {
        for (Node n : nodes) {
            if (tool.isApplicableForNode(n)) continue;
            return false;
        }
        return true;
    }

    private void executeObjectTool(Set<Node> nodes, ObjectTool tool) {
        if ((tool.getFlags() & 8) != 0) {
            String message = tool.getConfirmationText();
            if (nodes.size() == 1) {
                Node node = nodes.iterator().next();
                message = message.replace("%OBJECT_IP_ADDR%", node.getPrimaryIP().getHostAddress());
                message = message.replace("%OBJECT_NAME%", node.getObjectName());
                message = message.replace("%OBJECT_ID%", Long.toString(node.getObjectId()));
            } else {
                message = message.replace("%OBJECT_IP_ADDR%", "<multiple nodes>");
                message = message.replace("%OBJECT_NAME%", "<multiple nodes>");
                message = message.replace("%OBJECT_ID%", "<multiple nodes>");
            }
            if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm Tool Execution", (String)message)) {
                return;
            }
        }
        for (Node n : nodes) {
            this.executeObjectToolOnNode(n, tool);
        }
    }

    private void executeObjectToolOnNode(Node node, ObjectTool tool) {
        switch (tool.getType()) {
            case 0: {
                this.executeInternalTool(node, tool);
                break;
            }
            case 5: {
                this.executeLocalCommand(node, tool);
                break;
            }
            case 6: {
                this.executeServerCommand(node, tool);
                break;
            }
            case 1: {
                this.executeAgentAction(node, tool);
                break;
            }
            case 2: 
            case 3: {
                this.executeTableTool(node, tool);
                break;
            }
            case 4: {
                this.openURL(node, tool);
                break;
            }
            case 7: {
                this.executeFileDownload(node, tool);
            }
        }
    }

    private void executeTableTool(Node node, ObjectTool tool) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page = window.getActivePage();
            TableToolResults view = (TableToolResults)page.showView("org.netxms.ui.eclipse.objecttools.views.TableToolResults", String.valueOf(Long.toString(tool.getId())) + "&" + Long.toString(node.getObjectId()), 1);
            view.refreshTable();
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Error opening view: " + e.getMessage()));
        }
    }

    private void executeAgentAction(final Node node, final ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Execute action on node " + node.getObjectName(), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                return "Cannot execute action on node " + node.getObjectName();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeAction(node.getObjectId(), tool.getData());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation(null, (String)"Tool Execution", (String)("Action " + tool.getData() + " executed successfully on node " + node.getObjectName()));
                    }
                });
            }
        }.start();
    }

    private void executeServerCommand(final Node node, final ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Execute server command", null, "org.netxms.ui.eclipse.objecttools", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeServerCommand(node.getObjectId(), tool.getData());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation(null, (String)"Information", (String)"Server command executed successfully");
                    }
                });
            }

            protected String getErrorMessage() {
                return "Canot execute command on server";
            }
        }.start();
    }

    private void executeLocalCommand(Node node, ObjectTool tool) {
        String temp = tool.getData();
        temp = temp.replace("%OBJECT_IP_ADDR%", node.getPrimaryIP().getHostAddress());
        temp = temp.replace("%OBJECT_NAME%", node.getObjectName());
        String command = temp.replace("%OBJECT_ID%", Long.toString(node.getObjectId()));
        if ((tool.getFlags() & 0x10) == 0) {
            String os = Platform.getOS();
            command = os.equals("win32") ? "CMD.EXE /C START \"NetXMS\" " + command : "/bin/sh -c \"" + command.replaceAll("\"", Matcher.quoteReplacement("\\\"")) + "\"";
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            String secondaryId = String.valueOf(Long.toString(node.getObjectId())) + "&" + Long.toString(tool.getId());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                LocalCommandResults view = (LocalCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.LocalCommandResults", secondaryId, 1);
                view.runCommand(command);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Error opening view: " + e.getMessage()));
            }
        }
    }

    private void executeFileDownload(final Node node, final ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob("Download file from agent", null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                return "Cannot download file " + tool.getData() + " from node " + node.getObjectName();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final File file = session.downloadFileFromAgent(node.getObjectId(), tool.getData());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            String secondaryId = String.valueOf(Long.toString(node.getObjectId())) + "&" + URLEncoder.encode(tool.getData(), "UTF-8");
                            FileViewer view = (FileViewer)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.FileViewer", secondaryId, 1);
                            view.showFile(file);
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Error opening view: " + e.getMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private void executeInternalTool(Node node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            handler.execute(node, tool);
        } else {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"Cannot execute object tool: handler not defined");
        }
    }

    private void openURL(Node node, ObjectTool tool) {
        String temp = tool.getData();
        temp = temp.replace("%OBJECT_IP_ADDR%", node.getPrimaryIP().getHostAddress());
        temp = temp.replace("%OBJECT_NAME%", node.getObjectName());
        String url = temp.replace("%OBJECT_ID%", Long.toString(node.getObjectId()));
        String sid = String.valueOf(Long.toString(node.getObjectId())) + "&" + Long.toString(tool.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            BrowserView view = (BrowserView)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.BrowserView", sid, 1);
            view.openUrl(url);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Cannot open web browser: " + e.getLocalizedMessage()));
        }
    }
}

