/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.AlarmComparator;
import org.netxms.ui.eclipse.alarmviewer.AlarmListFilter;
import org.netxms.ui.eclipse.alarmviewer.AlarmListLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AlarmList
extends Composite {
    public static final String JOB_FAMILY = "AlarmViewJob";
    public static final int COLUMN_SEVERITY = 0;
    public static final int COLUMN_STATE = 1;
    public static final int COLUMN_SOURCE = 2;
    public static final int COLUMN_MESSAGE = 3;
    public static final int COLUMN_COUNT = 4;
    public static final int COLUMN_COMMENTS = 5;
    public static final int COLUMN_ACK_BY = 6;
    public static final int COLUMN_CREATED = 7;
    public static final int COLUMN_LASTCHANGE = 8;
    private final IViewPart viewPart;
    private NXCSession session = null;
    private NXCListener clientListener = null;
    private SortableTableViewer alarmViewer;
    private AlarmListFilter alarmFilter;
    private Map<Long, Alarm> alarmList = new HashMap<Long, Alarm>();
    private Action actionCopy;
    private Action actionCopyMessage;
    private Action actionComments;
    private Action actionAcknowledge;
    private Action actionResolve;
    private Action actionStickyAcknowledge;
    private Action actionTerminate;

    public AlarmList(IViewPart viewPart, Composite parent, int style, final String configPrefix) {
        super(parent, style);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.viewPart = viewPart;
        String[] names = new String[]{Messages.AlarmList_ColumnSeverity, Messages.AlarmList_ColumnState, Messages.AlarmList_ColumnSource, Messages.AlarmList_ColumnMessage, Messages.AlarmList_ColumnCount, Messages.AlarmList_Comments, Messages.AlarmList_AckBy, Messages.AlarmList_ColumnCreated, Messages.AlarmList_ColumnLastChange};
        int[] widths = new int[]{100, 100, 150, 300, 70, 70, 100, 100, 100};
        this.alarmViewer = new SortableTableViewer((Composite)this, names, widths, 0, 1024, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
        this.alarmViewer.setLabelProvider((IBaseLabelProvider)new AlarmListLabelProvider());
        this.alarmViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.alarmViewer.setComparator((ViewerComparator)new AlarmComparator());
        this.alarmFilter = new AlarmListFilter();
        this.alarmViewer.addFilter((ViewerFilter)this.alarmFilter);
        this.alarmViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)AlarmList.this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
            }
        });
        this.createActions();
        this.createPopupMenu();
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                AlarmList.this.alarmViewer.getControl().setBounds(AlarmList.this.getClientArea());
            }
        });
        this.refresh();
        this.clientListener = new NXCListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1004: 
                    case 1005: {
                        Map map = AlarmList.this.alarmList;
                        synchronized (map) {
                            AlarmList.this.alarmList.put(((Alarm)n.getObject()).getId(), (Alarm)n.getObject());
                        }
                        AlarmList.this.scheduleAlarmViewerUpdate();
                        break;
                    }
                    case 1003: 
                    case 1011: {
                        Map map = AlarmList.this.alarmList;
                        synchronized (map) {
                            AlarmList.this.alarmList.remove(((Alarm)n.getObject()).getId());
                        }
                        AlarmList.this.scheduleAlarmViewerUpdate();
                        break;
                    }
                }
            }
        };
        this.session.addListener((SessionListener)this.clientListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AlarmList.this.session != null && AlarmList.this.clientListener != null) {
                    AlarmList.this.session.removeListener((SessionListener)AlarmList.this.clientListener);
                }
            }
        });
        final Runnable blinkTimer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AlarmList.this.isDisposed()) {
                    return;
                }
                int count = 0;
                Map map = AlarmList.this.alarmList;
                synchronized (map) {
                    for (Alarm a : AlarmList.this.alarmList.values()) {
                        if (a.getState() != 0) continue;
                        ++count;
                    }
                }
                if (count > 0) {
                    ((AlarmListLabelProvider)AlarmList.this.alarmViewer.getLabelProvider()).toggleBlinkState();
                    AlarmList.this.alarmViewer.refresh();
                }
                AlarmList.this.getDisplay().timerExec(500, (Runnable)this);
            }
        };
        final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        if (ps.getBoolean("BLINK_OUTSTANDING_ALARMS")) {
            this.getDisplay().timerExec(500, blinkTimer);
        }
        ps.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("BLINK_OUTSTANDING_ALARMS")) {
                    if (ps.getBoolean("BLINK_OUTSTANDING_ALARMS")) {
                        AlarmList.this.getDisplay().timerExec(500, blinkTimer);
                    } else {
                        AlarmList.this.getDisplay().timerExec(-1, blinkTimer);
                    }
                }
            }
        });
    }

    public ISelectionProvider getSelectionProvider() {
        return this.alarmViewer;
    }

    private void scheduleAlarmViewerUpdate() {
        this.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!AlarmList.this.alarmViewer.getControl().isDisposed()) {
                    Map map = AlarmList.this.alarmList;
                    synchronized (map) {
                        AlarmList.this.alarmViewer.refresh();
                    }
                }
            }
        });
    }

    private void createActions() {
        this.actionCopy = new Action(Messages.AlarmList_CopyToClipboard){

            public void run() {
                TableItem[] selection = AlarmList.this.alarmViewer.getTable().getSelection();
                if (selection.length > 0) {
                    String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append('[');
                        sb.append(selection[i].getText(0));
                        sb.append("]\t");
                        sb.append(selection[i].getText(2));
                        sb.append('\t');
                        sb.append(selection[i].getText(3));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        this.actionCopyMessage = new Action(Messages.AlarmList_CopyMsgToClipboard){

            public void run() {
                TableItem[] selection = AlarmList.this.alarmViewer.getTable().getSelection();
                if (selection.length > 0) {
                    String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append(selection[i].getText(3));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        this.actionComments = new Action(Messages.AlarmList_Comments, Activator.getImageDescriptor("icons/comments.png")){

            public void run() {
                AlarmList.this.openComments();
            }
        };
        this.actionAcknowledge = new Action(Messages.AlarmList_Acknowledge, Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                AlarmList.this.acknowledgeAlarms(false);
            }
        };
        this.actionStickyAcknowledge = new Action(Messages.AlarmList_StickyAck, Activator.getImageDescriptor("icons/acknowledged_sticky.png")){

            public void run() {
                AlarmList.this.acknowledgeAlarms(true);
            }
        };
        this.actionResolve = new Action(Messages.AlarmList_Resolve, Activator.getImageDescriptor("icons/resolved.png")){

            public void run() {
                AlarmList.this.resolveAlarms();
            }
        };
        this.actionTerminate = new Action(Messages.AlarmList_Terminate, Activator.getImageDescriptor("icons/terminated.png")){

            public void run() {
                AlarmList.this.terminateAlarms();
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AlarmList.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.alarmViewer.getControl());
        this.alarmViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.alarmViewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAcknowledge);
        manager.add((IAction)this.actionStickyAcknowledge);
        manager.add((IAction)this.actionResolve);
        manager.add((IAction)this.actionTerminate);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 1) {
            manager.add((IContributionItem)new GroupMarker("objectmgmt"));
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyMessage);
        if (selection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionComments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootObject(long objectId) {
        this.alarmFilter.setRootObject(objectId);
        Map<Long, Alarm> map = this.alarmList;
        synchronized (map) {
            this.alarmViewer.refresh();
        }
    }

    public void refresh() {
        new ConsoleJob(Messages.AlarmList_SyncJobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final HashMap list = AlarmList.this.session.getAlarms();
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (!AlarmList.this.alarmViewer.getControl().isDisposed()) {
                            Map map = AlarmList.this.alarmList;
                            synchronized (map) {
                                AlarmList.this.alarmList.clear();
                                AlarmList.this.alarmList.putAll(list);
                                AlarmList.this.alarmViewer.setInput(AlarmList.this.alarmList.values());
                            }
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.AlarmList_SyncJobError;
            }
        }.start();
    }

    private void openComments() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String secondaryId = Long.toString(((Alarm)selection.getFirstElement()).getId());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.alarmviewer.views.AlarmComments", secondaryId, 1);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AlarmList_Error, (String)(String.valueOf(Messages.AlarmList_ErrorText) + e.getLocalizedMessage()));
        }
    }

    public void setStateFilter(int filter) {
        this.alarmFilter.setStateFilter(filter);
    }

    private void acknowledgeAlarms(final boolean sticky) {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        final Object[] alarms = selection.toArray();
        new ConsoleJob(Messages.AcknowledgeAlarm_JobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(Messages.AcknowledgeAlarm_TaskName, alarms.length);
                Object[] objectArray = alarms;
                int n = alarms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monitor.isCanceled()) break;
                    if (o instanceof Alarm) {
                        AlarmList.this.session.acknowledgeAlarm(((Alarm)o).getId(), sticky);
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                return Messages.AcknowledgeAlarm_ErrorMessage;
            }
        }.start();
    }

    private void resolveAlarms() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        final Object[] alarms = selection.toArray();
        new ConsoleJob(Messages.AlarmList_Resolving, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(Messages.AlarmList_ResolveAlarm, alarms.length);
                Object[] objectArray = alarms;
                int n = alarms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monitor.isCanceled()) break;
                    if (o instanceof Alarm) {
                        AlarmList.this.session.resolveAlarm(((Alarm)o).getId());
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                return Messages.AlarmList_CannotResoveAlarm;
            }
        }.start();
    }

    private void terminateAlarms() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        final Object[] alarms = selection.toArray();
        new ConsoleJob(Messages.TerminateAlarm_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(Messages.TerminateAlarm_TaskName, alarms.length);
                Object[] objectArray = alarms;
                int n = alarms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monitor.isCanceled()) break;
                    if (o instanceof Alarm) {
                        AlarmList.this.session.terminateAlarm(((Alarm)o).getId());
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                return Messages.TerminateAlarm_ErrorMessage;
            }
        }.start();
    }
}

