/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.widgets;

import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class LocalFileSelector
extends AbstractSelector {
    private File file = null;
    private String[] filterExtensions = new String[]{"*.*"};
    private String[] filterNames = new String[]{Messages.LocalFileSelector_AllFiles};

    public LocalFileSelector(Composite parent, int style, boolean useHyperlink) {
        super(parent, style, useHyperlink);
        this.setImage(null);
        this.setText(Messages.LocalFileSelector_None);
    }

    protected void selectionButtonHandler() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setText(Messages.LocalFileSelector_SelectFile);
        fd.setFilterExtensions(this.filterExtensions);
        fd.setFilterNames(this.filterNames);
        String selected = fd.open();
        if (selected != null) {
            this.setFile(new File(selected));
        } else {
            this.setFile(null);
        }
    }

    protected String getButtonToolTip() {
        return Messages.LocalFileSelector_Tooltip;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        if (file != null) {
            this.setText(file.getAbsolutePath());
        } else {
            this.setImage(null);
            this.setText(Messages.LocalFileSelector_None);
        }
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }
}

