/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.PredefinedChartConfig;
import org.netxms.ui.eclipse.perfview.views.HistoricalGraphView;
import org.netxms.ui.eclipse.perfview.views.helpers.GraphTreeContentProvider;
import org.netxms.ui.eclipse.perfview.views.helpers.GraphTreeLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class PredefinedGraphTree
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.PredefinedGraphTree";
    private TreeViewer viewer;
    private NXCSession session;
    private RefreshAction actionRefresh;
    private Action actionOpen;
    private Action actionProperties;
    private Action actionDelete;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new GraphTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GraphTreeLabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PredefinedGraphTree.this.actionOpen.run();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PredefinedGraphTree.this.viewer.getSelection();
                Iterator it = selection.iterator();
                boolean enabled = false;
                while (it.hasNext()) {
                    if (!(it.next() instanceof GraphSettings)) continue;
                    enabled = true;
                    break;
                }
                PredefinedGraphTree.this.actionOpen.setEnabled(enabled);
                PredefinedGraphTree.this.actionDelete.setEnabled(enabled);
                PredefinedGraphTree.this.actionProperties.setEnabled(enabled);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.reloadGraphList();
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                PredefinedGraphTree.this.reloadGraphList();
            }
        };
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                PredefinedGraphTree.this.deletePredefinedGraph();
            }
        };
        this.actionOpen = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)PredefinedGraphTree.this.viewer.getSelection();
                for (Object o : selection) {
                    if (!(o instanceof GraphSettings)) continue;
                    PredefinedGraphTree.this.showPredefinedGraph((GraphSettings)o);
                }
            }
        };
        this.actionOpen.setText("&Open");
        this.actionProperties = new Action("Properties"){

            public void run() {
                PredefinedGraphTree.this.editPredefinedGraph();
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PredefinedGraphTree.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionOpen);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionProperties);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionOpen);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void reloadGraphList() {
        new ConsoleJob("Load list of predefined graphs", (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", "org.netxms.ui.eclipse.perfview"){

            protected String getErrorMessage() {
                return "Cannot get list of predefined graphs";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = PredefinedGraphTree.this.session.getPredefinedGraphs();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PredefinedGraphTree.this.viewer.setInput((Object)list);
                    }
                });
            }
        }.start();
    }

    private void showPredefinedGraph(GraphSettings gs) {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(gs.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            encodedName = "___ERROR___";
        }
        String id = "org.netxms.ui.eclipse.charts.predefinedGraph&" + encodedName;
        try {
            HistoricalGraphView g = (HistoricalGraphView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", id, 1);
            if (g != null) {
                g.initPredefinedGraph(gs);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("Error opening graph view: " + e.getMessage()));
        }
    }

    private void editPredefinedGraph() {
        PredefinedChartConfig config;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        GraphSettings settings = (GraphSettings)selection.getFirstElement();
        try {
            config = PredefinedChartConfig.createFromServerConfig(settings);
        }
        catch (Exception exception) {
            config = new PredefinedChartConfig();
        }
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)config);
        if (dlg != null) {
            if (dlg.open() == 0) {
                try {
                    final GraphSettings s = config.createServerSettings();
                    new ConsoleJob("Update predefined graph", null, "org.netxms.ui.eclipse.perfview", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            PredefinedGraphTree.this.session.modifyPredefinedGraph(s);
                        }

                        protected String getErrorMessage() {
                            return "Cannot update predefined graph";
                        }
                    }.start();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Internal Error", (String)("Unexpected exception: " + e.getLocalizedMessage()));
                }
            }
            settings.setName(config.getName());
            settings.getAccessList().clear();
            settings.getAccessList().addAll(config.getAccessList());
            try {
                settings.setConfig(config.createXml());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Internal Error", (String)("Unexpected exception: " + e.getLocalizedMessage()));
            }
            this.viewer.update((Object)settings, null);
        }
    }

    private void deletePredefinedGraph() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Predefined Graphs", (String)"Selected predefined graphs will be deleted. Are you sure?")) {
            return;
        }
        final ArrayList list = new ArrayList((List)this.viewer.getInput());
        for (final Object o : selection.toList()) {
            if (!(o instanceof GraphSettings)) continue;
            new ConsoleJob("Delete predefined graph \"" + ((GraphSettings)o).getShortName() + "\"", null, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    PredefinedGraphTree.this.session.deletePredefinedGraph(((GraphSettings)o).getId());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            list.remove(o);
                            PredefinedGraphTree.this.viewer.setInput((Object)list);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot delete predefined graph";
                }
            }.start();
        }
    }
}

