/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.internal.DciListComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.DciListLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DciList
extends Composite {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_PARAMETER = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private final ViewPart viewPart;
    private Node node;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private SortableTableViewer viewer;
    private int dcObjectType;

    public DciList(ViewPart viewPart, Composite parent, int style, Node _node, final String configPrefix, int dcObjectType) {
        super(parent, style);
        this.viewPart = viewPart;
        this.node = _node;
        this.dcObjectType = dcObjectType;
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        String[] names = new String[]{Messages.DciList_ColID, Messages.DciList_ColParam, Messages.DciList_ColDescr};
        int[] widths = new int[]{70, 150, 250};
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 2, 1024, 65540);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DciListLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new DciListComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)ds, (String)configPrefix);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                DciList.this.viewer.getControl().setBounds(DciList.this.getClientArea());
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)DciList.this.viewer, (IDialogSettings)ds, (String)configPrefix);
            }
        });
        this.getDataFromServer();
    }

    private void getDataFromServer() {
        if (this.node == null) {
            this.viewer.setInput((Object)new DciValue[0]);
            return;
        }
        ConsoleJob job = new ConsoleJob(String.valueOf(Messages.DciList_JobTitle) + this.node.getObjectName(), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                return String.valueOf(Messages.DciList_JobError) + DciList.this.node.getObjectName();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List<DciValue> data;
                List<DciValue> list = data = DciList.this.dcObjectType == -1 ? Arrays.asList(DciList.this.session.getLastValues(DciList.this.node.getObjectId())) : new ArrayList<DciValue>(Arrays.asList(DciList.this.session.getLastValues(DciList.this.node.getObjectId())));
                if (DciList.this.dcObjectType != -1) {
                    Iterator<DciValue> it = data.iterator();
                    while (it.hasNext()) {
                        DciValue dci = it.next();
                        if (dci.getDcObjectType() == DciList.this.dcObjectType) continue;
                        it.remove();
                    }
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DciList.this.viewer.setInput((Object)data.toArray());
                    }
                });
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setNode(Node _node) {
        this.node = _node;
        this.getDataFromServer();
    }

    public void refresh() {
        this.getDataFromServer();
    }

    public DciValue getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return (DciValue)selection.getFirstElement();
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        this.getDataFromServer();
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.addDoubleClickListener(listener);
    }
}

