/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesFilter;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class LastValuesWidget
extends Composite {
    public static final String JOB_FAMILY = "LastValuesViewJob";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_VALUE = 2;
    public static final int COLUMN_TIMESTAMP = 3;
    public static final int COLUMN_THRESHOLD = 4;
    private final ViewPart viewPart;
    private Node node;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private boolean filterEnabled = false;
    private FilterText filterText;
    private SortableTableViewer dataViewer;
    private LastValuesLabelProvider labelProvider;
    private LastValuesFilter filter;
    private boolean autoRefreshEnabled = false;
    private int autoRefreshInterval = 30000;
    private Runnable refreshTimer;
    private Action actionUseMultipliers;
    private Action actionShowErrors;
    private Action actionShowUnsupported;

    public LastValuesWidget(ViewPart viewPart, Composite parent, int style, Node _node, final String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        this.node = _node;
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (LastValuesWidget.this.isDisposed()) {
                    return;
                }
                LastValuesWidget.this.getDataFromServer();
                LastValuesWidget.this.getDisplay().timerExec(LastValuesWidget.this.autoRefreshInterval, (Runnable)this);
            }
        };
        this.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText((Composite)this, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LastValuesWidget.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                LastValuesWidget.this.enableFilter(false);
            }
        });
        String[] names = new String[]{Messages.LastValuesWidget_ColID, Messages.LastValuesWidget_ColDescr, Messages.LastValuesWidget_ColValue, Messages.LastValuesWidget_ColTime, Messages.LastValuesWidget_ColThreshold};
        int[] widths = new int[]{70, 250, 150, 120, 150};
        this.dataViewer = new SortableTableViewer((Composite)this, names, widths, 0, 1024, -1);
        this.labelProvider = new LastValuesLabelProvider();
        this.filter = new LastValuesFilter();
        this.dataViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.dataViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataViewer.setComparator((ViewerComparator)new LastValuesComparator());
        this.dataViewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
        this.dataViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)LastValuesWidget.this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
                ds.put(String.valueOf(configPrefix) + ".autoRefresh", LastValuesWidget.this.autoRefreshEnabled);
                ds.put(String.valueOf(configPrefix) + ".autoRefreshInterval", LastValuesWidget.this.autoRefreshEnabled);
                ds.put(String.valueOf(configPrefix) + ".useMultipliers", LastValuesWidget.this.labelProvider.areMultipliersUsed());
                ds.put(String.valueOf(configPrefix) + ".showErrors", LastValuesWidget.this.isShowErrors());
                ds.put(String.valueOf(configPrefix) + ".showUnsupported", LastValuesWidget.this.isShowUnsupported());
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.dataViewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        try {
            ds.getInt(String.valueOf(configPrefix) + ".autoRefreshInterval");
        }
        catch (NumberFormatException numberFormatException) {}
        this.setAutoRefreshEnabled(ds.getBoolean(String.valueOf(configPrefix) + ".autoRefresh"));
        if (ds.get(String.valueOf(configPrefix) + ".useMultipliers") != null) {
            this.labelProvider.setUseMultipliers(ds.getBoolean(String.valueOf(configPrefix) + ".useMultipliers"));
        } else {
            this.labelProvider.setUseMultipliers(true);
        }
        if (ds.get(String.valueOf(configPrefix) + ".showErrors") != null) {
            this.labelProvider.setShowErrors(ds.getBoolean(String.valueOf(configPrefix) + ".showErrors"));
        } else {
            this.labelProvider.setShowErrors(true);
        }
        this.filter.setShowUnsupported(ds.getBoolean(String.valueOf(configPrefix) + ".showUnsupported"));
        this.createActions();
        this.createPopupMenu();
        this.getDataFromServer();
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    private void createActions() {
        this.actionUseMultipliers = new Action(Messages.LastValuesWidget_UseMultipliers, 2){

            public void run() {
                LastValuesWidget.this.setUseMultipliers(LastValuesWidget.this.actionUseMultipliers.isChecked());
            }
        };
        this.actionUseMultipliers.setChecked(this.areMultipliersUsed());
        this.actionShowErrors = new Action(Messages.LastValuesWidget_ShowErrors, 2){

            public void run() {
                LastValuesWidget.this.setShowErrors(LastValuesWidget.this.actionShowErrors.isChecked());
            }
        };
        this.actionShowErrors.setChecked(this.isShowErrors());
        this.actionShowUnsupported = new Action(Messages.LastValuesWidget_ShowUnsupported, 2){

            public void run() {
                LastValuesWidget.this.setShowUnsupported(LastValuesWidget.this.actionShowUnsupported.isChecked());
            }
        };
        this.actionShowUnsupported.setChecked(this.isShowUnsupported());
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LastValuesWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.dataViewer.getControl());
        this.dataViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.dataViewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("secondary"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IAction)this.actionShowErrors);
        manager.add((IAction)this.actionShowUnsupported);
    }

    private void getDataFromServer() {
        if (this.node == null) {
            this.dataViewer.setInput((Object)new DciValue[0]);
            return;
        }
        ConsoleJob job = new ConsoleJob(String.valueOf(Messages.LastValuesWidget_JobTitle) + this.node.getObjectName(), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", JOB_FAMILY){

            protected String getErrorMessage() {
                return String.valueOf(Messages.LastValuesWidget_JobError) + LastValuesWidget.this.node.getObjectName();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DciValue[] data = LastValuesWidget.this.session.getLastValues(LastValuesWidget.this.node.getObjectId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!LastValuesWidget.this.isDisposed()) {
                            LastValuesWidget.this.dataViewer.setInput((Object)data);
                        }
                    }
                });
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setNode(Node _node) {
        this.node = _node;
        this.getDataFromServer();
    }

    public void refresh() {
        this.getDataFromServer();
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public void setAutoRefreshEnabled(boolean autoRefreshEnabled) {
        this.autoRefreshEnabled = autoRefreshEnabled;
        this.getDisplay().timerExec(autoRefreshEnabled ? this.autoRefreshInterval : -1, this.refreshTimer);
    }

    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }

    public boolean areMultipliersUsed() {
        return this.labelProvider != null ? this.labelProvider.areMultipliersUsed() : false;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        if (this.labelProvider != null) {
            this.labelProvider.setUseMultipliers(useMultipliers);
            if (this.dataViewer != null) {
                this.dataViewer.refresh(true);
            }
        }
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.dataViewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.dataViewer.refresh(false);
    }

    public void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }

    public boolean isShowErrors() {
        return this.labelProvider != null ? this.labelProvider.isShowErrors() : false;
    }

    public void setShowErrors(boolean show) {
        this.labelProvider.setShowErrors(show);
        if (this.dataViewer != null) {
            this.dataViewer.refresh(true);
        }
    }

    public boolean isShowUnsupported() {
        return this.filter != null ? this.filter.isShowUnsupported() : false;
    }

    public void setShowUnsupported(boolean show) {
        this.filter.setShowUnsupported(show);
        if (this.dataViewer != null) {
            this.dataViewer.refresh(true);
        }
    }
}

