/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.library.Messages;
import org.netxms.ui.eclipse.shared.SharedColors;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class WidgetHelper {
    public static final int INNER_SPACING = 2;
    public static final int OUTER_SPACING = 4;
    public static final int DIALOG_WIDTH_MARGIN = 10;
    public static final int DIALOG_HEIGHT_MARGIN = 10;
    public static final int DIALOG_SPACING = 5;
    public static final int BUTTON_WIDTH_HINT = 90;
    public static final int WIDE_BUTTON_WIDTH_HINT = 120;
    public static final String DEFAULT_LAYOUT_DATA = "WidgetHelper::default_layout_data";

    public static Text createLabeledText(Composite parent, int flags, int widthHint, String labelText, String initialText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Text text = new Text(group, flags);
        if (initialText != null) {
            text.setText(initialText);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = widthHint;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static StyledText createLabeledStyledText(Composite parent, int flags, String labelText, String initialText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        StyledText text = new StyledText(group, flags);
        if (initialText != null) {
            text.setText(initialText);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static Combo createLabeledCombo(Composite parent, int flags, String labelText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Combo combo = new Combo(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    public static Spinner createLabeledSpinner(Composite parent, int flags, String labelText, int minVal, int maxVal, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Spinner spinner = new Spinner(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        spinner.setLayoutData((Object)gridData);
        spinner.setMinimum(minVal);
        spinner.setMaximum(maxVal);
        return spinner;
    }

    public static ColorSelector createLabeledColorSelector(Composite parent, String labelText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        ColorSelector cs = new ColorSelector(group);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        cs.getButton().setLayoutData((Object)gridData);
        return cs;
    }

    public static Control createLabeledControl(Composite parent, int flags, WidgetFactory factory, String labelText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Control widget = factory.createControl(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)gridData);
        return widget;
    }

    public static void saveColumnSettings(Table table, IDialogSettings settings, String prefix) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            settings.put(String.valueOf(prefix) + "." + i + ".width", columns[i].getWidth());
            ++i;
        }
    }

    public static void restoreColumnSettings(Table table, IDialogSettings settings, String prefix) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            try {
                int w = settings.getInt(String.valueOf(prefix) + "." + i + ".width");
                columns[i].setWidth(w);
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
    }

    public static void saveColumnSettings(Tree tree, IDialogSettings settings, String prefix) {
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            settings.put(String.valueOf(prefix) + "." + i + ".width", columns[i].getWidth());
            ++i;
        }
    }

    public static void restoreColumnSettings(Tree tree, IDialogSettings settings, String prefix) {
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            try {
                int w = settings.getInt(String.valueOf(prefix) + "." + i + ".width");
                columns[i].setWidth(w);
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
    }

    public static void saveTableViewerSettings(SortableTableViewer viewer, IDialogSettings settings, String prefix) {
        Table table = viewer.getTable();
        WidgetHelper.saveColumnSettings(table, settings, prefix);
        TableColumn column = table.getSortColumn();
        settings.put(String.valueOf(prefix) + ".sortColumn", column != null ? (Integer)column.getData("ID") : -1);
        settings.put(String.valueOf(prefix) + ".sortDirection", table.getSortDirection());
    }

    public static void restoreTableViewerSettings(SortableTableViewer viewer, IDialogSettings settings, String prefix) {
        Table table = viewer.getTable();
        WidgetHelper.restoreColumnSettings(table, settings, prefix);
        try {
            table.setSortDirection(settings.getInt(String.valueOf(prefix) + ".sortDirection"));
            int column = settings.getInt(String.valueOf(prefix) + ".sortColumn");
            if (column >= 0) {
                table.setSortColumn(viewer.getColumnById(column));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public static void copyToClipboard(String text) {
        Clipboard cb = new Clipboard(Display.getCurrent());
        TextTransfer transfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{text != null ? text : ""}, new Transfer[]{transfer});
        cb.dispose();
    }

    public static void addStyledTextEditorActions(IMenuManager manager, final StyledText control, boolean readOnly) {
        if (!readOnly) {
            Action cut = new Action(Messages.WidgetHelper_Action_Cut){

                public void run() {
                    control.cut();
                }
            };
            cut.setImageDescriptor(SharedIcons.CUT);
            manager.add((IAction)cut);
        }
        Action copy = new Action(Messages.WidgetHelper_Action_Copy){

            public void run() {
                control.copy();
            }
        };
        copy.setImageDescriptor(SharedIcons.COPY);
        manager.add((IAction)copy);
        if (!readOnly) {
            Action paste = new Action(Messages.WidgetHelper_Action_Paste){

                public void run() {
                    control.paste();
                }
            };
            paste.setImageDescriptor(SharedIcons.PASTE);
            manager.add((IAction)paste);
            Action delete = new Action(Messages.WidgetHelper_Action_Delete){

                public void run() {
                    control.invokeAction(127);
                }
            };
            manager.add((IAction)delete);
            manager.add((IContributionItem)new Separator());
        }
        Action selectAll = new Action(Messages.WidgetHelper_Action_SelectAll){

            public void run() {
                control.selectAll();
            }
        };
        manager.add((IAction)selectAll);
    }

    public static Font getBestFittingFont(GC gc, Font[] fonts, String text, int width, int height) {
        int first = 0;
        int last = fonts.length - 1;
        int curr = last / 2;
        Font font = null;
        while (last > first) {
            gc.setFont(fonts[curr]);
            Point ext = gc.textExtent(text);
            if (ext.x <= width && ext.y <= height) {
                font = fonts[curr];
                first = curr + 1;
                curr = first + (last - first) / 2;
                continue;
            }
            last = curr - 1;
            curr = first + (last - first) / 2;
        }
        if (font == null) {
            font = fonts[0];
        }
        return font;
    }

    public static Font getMatchingSizeFont(Font[] fonts, Font sourceFont) {
        float h = sourceFont.getFontData()[0].height;
        int i = 0;
        while (i < fonts.length) {
            if (fonts[i].getFontData()[0].height == h) {
                return fonts[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean validateTextInputInternal(Control control, String text, String label, TextFieldValidator validator, PropertyPage page) {
        if (!control.isEnabled()) {
            return true;
        }
        boolean ok = validator.validate(text);
        control.setBackground(ok ? null : SharedColors.RED);
        if (ok) {
            if (page != null) {
                page.setErrorMessage(null);
            }
        } else if (page != null) {
            page.setErrorMessage(validator.getErrorMessage(text, label));
        } else {
            MessageDialog.openError((Shell)control.getShell(), (String)Messages.WidgetHelper_InputValidationError, (String)validator.getErrorMessage(text, label));
        }
        return ok;
    }

    public static boolean validateTextInput(Text text, String label, TextFieldValidator validator, PropertyPage page) {
        return WidgetHelper.validateTextInputInternal((Control)text, text.getText(), label, validator, page);
    }

    public static boolean validateTextInput(LabeledText text, TextFieldValidator validator, PropertyPage page) {
        return WidgetHelper.validateTextInputInternal((Control)text.getTextControl(), text.getText(), text.getLabel(), validator, page);
    }
}

