/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class CommandBox
extends Composite
implements DisposeListener {
    private static final Color FOREGROUND_COLOR = new Color((Device)Display.getDefault(), 0, 0, 96);
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 255, 255, 255);
    private List<Action> actions = new ArrayList<Action>();
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();
    private Cursor cursor;
    private Font font;

    public CommandBox(Composite parent, int style) {
        super(parent, style);
        this.setBackground(BACKGROUND_COLOR);
        this.cursor = new Cursor((Device)this.getDisplay(), 21);
        this.font = new Font((Device)this.getDisplay(), "Verdana", 9, 0);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        this.setLayout((Layout)layout);
        this.addDisposeListener(this);
    }

    public void rebuild() {
        for (final Action a : this.actions) {
            CLabel label = new CLabel((Composite)this, 16384);
            label.setText(a.getText());
            label.setImage(this.getImage(a));
            label.setCursor(this.cursor);
            label.setForeground(FOREGROUND_COLOR);
            label.setBackground(BACKGROUND_COLOR);
            label.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1) {
                        a.run();
                    }
                }
            });
        }
        this.layout();
    }

    private Image getImage(Action action) {
        ImageDescriptor d = action.getImageDescriptor();
        Image img = null;
        if (d != null && (img = this.imageCache.get(d)) == null) {
            img = d.createImage();
            this.imageCache.put(d, img);
        }
        return img;
    }

    public void add(Action action, boolean doRebuild) {
        this.actions.add(action);
        if (doRebuild) {
            this.rebuild();
        }
    }

    public void deleteAll(boolean doRebuild) {
        this.actions.clear();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (doRebuild) {
            this.rebuild();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        for (Image i : this.imageCache.values()) {
            i.dispose();
        }
        this.cursor.dispose();
        this.font.dispose();
    }
}

