/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.objects.GenericObject;

public class NetworkMap
extends GenericObject {
    public static final UUID GEOMAP_BACKGROUND = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_LAYER2_TOPOLOGY = 1;
    public static final int TYPE_IP_TOPOLOGY = 2;
    public static final int LAYOUT_MANUAL = Short.MAX_VALUE;
    public static final int LAYOUT_SPRING = 0;
    public static final int LAYOUT_RADIAL = 1;
    public static final int LAYOUT_HTREE = 2;
    public static final int LAYOUT_VTREE = 3;
    public static final int LAYOUT_SPARSE_VTREE = 4;
    public static final int MF_SHOW_STATUS_ICON = 1;
    public static final int MF_SHOW_STATUS_FRAME = 2;
    public static final int MF_SHOW_STATUS_BKGND = 4;
    public static final int MF_SHOW_END_NODES = 8;
    private int mapType;
    private int layout;
    private int flags;
    private UUID background;
    private GeoLocation backgroundLocation;
    private int backgroundZoom;
    private long seedObjectId;
    private int defaultLinkColor;
    private int defaultLinkRouting;
    private int backgroundColor;
    private int discoveryRadius;
    private List<NetworkMapElement> elements;
    private List<NetworkMapLink> links;

    public NetworkMap(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        int i;
        this.mapType = msg.getVariableAsInteger(357L);
        this.layout = msg.getVariableAsInteger(358L);
        this.flags = msg.getVariableAsInteger(13L);
        this.background = msg.getVariableAsUUID(360L);
        this.backgroundLocation = new GeoLocation(msg.getVariableAsReal(385L), msg.getVariableAsReal(386L));
        this.backgroundZoom = msg.getVariableAsInteger(387L);
        this.seedObjectId = msg.getVariableAsInt64(359L);
        this.defaultLinkColor = msg.getVariableAsInteger(417L);
        this.defaultLinkRouting = msg.getVariableAsInteger(423L);
        this.backgroundColor = msg.getVariableAsInteger(424L);
        this.discoveryRadius = msg.getVariableAsInteger(426L);
        int count = msg.getVariableAsInteger(361L);
        this.elements = new ArrayList<NetworkMapElement>(count);
        long varId = 0x10000000L;
        for (i = 0; i < count; ++i) {
            this.elements.add(NetworkMapElement.createMapElement(msg, varId));
            varId += 100L;
        }
        count = msg.getVariableAsInteger(214L);
        this.links = new ArrayList<NetworkMapLink>(count);
        varId = 0x40000000L;
        for (i = 0; i < count; ++i) {
            this.links.add(new NetworkMapLink(msg, varId));
            varId += 10L;
        }
    }

    @Override
    public String getObjectClassName() {
        return "NetworkMap";
    }

    public int getMapType() {
        return this.mapType;
    }

    public int getLayout() {
        return this.layout;
    }

    public UUID getBackground() {
        return this.background;
    }

    public long getSeedObjectId() {
        return this.seedObjectId;
    }

    public NetworkMapPage createMapPage() {
        NetworkMapPage page = new NetworkMapPage(this.getObjectName());
        page.addAllElements(this.elements);
        page.addAllLinks(this.links);
        return page;
    }

    public GeoLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    public int getBackgroundZoom() {
        return this.backgroundZoom;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDefaultLinkColor() {
        return this.defaultLinkColor;
    }

    public int getDefaultLinkRouting() {
        return this.defaultLinkRouting;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final int getDiscoveryRadius() {
        return this.discoveryRadius;
    }
}

