/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpTrapParameterMapping;

public class SnmpTrap {
    private long id;
    private String description;
    private SnmpObjectId objectId;
    private int eventCode;
    private String userTag;
    private List<SnmpTrapParameterMapping> parameterMapping;

    public SnmpTrap() {
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>();
    }

    public SnmpTrap(NXCPMessage msg) {
        this.id = msg.getVariableAsInt64(117L);
        this.description = msg.getVariableAsString(27L);
        this.objectId = new SnmpObjectId(msg.getVariableAsUInt32Array(118L));
        this.eventCode = msg.getVariableAsInteger(24L);
        this.userTag = msg.getVariableAsString(298L);
        int count = msg.getVariableAsInteger(120L);
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>(count);
        for (int i = 0; i < count; ++i) {
            long oidLen = msg.getVariableAsInt64(36864L + (long)i);
            SnmpTrapParameterMapping pm = (oidLen & Integer.MIN_VALUE) == 0L ? new SnmpTrapParameterMapping(new SnmpObjectId(msg.getVariableAsUInt32Array(37888L + (long)i))) : new SnmpTrapParameterMapping((int)(oidLen & Integer.MAX_VALUE));
            pm.setDescription(msg.getVariableAsString(38912L + (long)i));
            pm.setFlags(msg.getVariableAsInteger(39936L + (long)i));
            this.parameterMapping.add(pm);
        }
    }

    public SnmpTrap(NXCPMessage msg, long baseId) {
        this.id = msg.getVariableAsInt64(baseId);
        this.description = msg.getVariableAsString(baseId + 4L);
        this.objectId = new SnmpObjectId(msg.getVariableAsUInt32Array(baseId + 2L));
        this.eventCode = msg.getVariableAsInteger(baseId + 3L);
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>(0);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariableInt32(117L, (int)this.id);
        msg.setVariableInt32(24L, this.eventCode);
        msg.setVariable(27L, this.description);
        msg.setVariable(298L, this.userTag);
        msg.setVariableInt32(119L, this.objectId.getLength());
        this.objectId.setNXCPVariable(msg, 118L);
        msg.setVariableInt32(120L, this.parameterMapping.size());
        for (int i = 0; i < this.parameterMapping.size(); ++i) {
            this.parameterMapping.get(i).fillMessage(msg, i);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SnmpObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(SnmpObjectId objectId) {
        this.objectId = objectId;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    public List<SnmpTrapParameterMapping> getParameterMapping() {
        return this.parameterMapping;
    }
}

