/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.widgets;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.ui.eclipse.networkmaps.algorithms.ManualLayout;
import org.netxms.ui.eclipse.networkmaps.algorithms.SparseTree;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;

public class NetworkMapWidget
extends Composite {
    protected static final int LAYOUT_SPRING = 0;
    protected static final int LAYOUT_RADIAL = 1;
    protected static final int LAYOUT_HTREE = 2;
    protected static final int LAYOUT_VTREE = 3;
    protected static final int LAYOUT_SPARSE_VTREE = 4;
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;

    public NetworkMapWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.viewer = new ExtendedGraphViewer(this, 0);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider());
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    public void setContent(NetworkMapPage page) {
        this.viewer.setInput(page);
    }

    public void setMapLayout(int layout) {
        if (layout == Short.MAX_VALUE) {
            this.viewer.setLayoutAlgorithm(new ManualLayout());
        } else {
            this.setLayoutAlgorithm(layout);
        }
    }

    private void setLayoutAlgorithm(int alg) {
        SpringLayoutAlgorithm algorithm;
        switch (alg) {
            case 0: {
                algorithm = new SpringLayoutAlgorithm();
                break;
            }
            case 1: {
                algorithm = new RadialLayoutAlgorithm();
                break;
            }
            case 2: {
                algorithm = new TreeLayoutAlgorithm(3);
                break;
            }
            case 3: {
                algorithm = new TreeLayoutAlgorithm(1);
                break;
            }
            case 4: {
                TreeLayoutAlgorithm mainLayoutAlgorithm = new TreeLayoutAlgorithm(1);
                this.viewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        return e1.toString().compareToIgnoreCase(e2.toString());
                    }
                });
                algorithm = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{mainLayoutAlgorithm, new SparseTree()});
                break;
            }
            default: {
                algorithm = new GridLayoutAlgorithm();
            }
        }
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)algorithm);
    }
}

