/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.alarmviewer.Messages;

public class ShowObjectAlarms
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private GenericObject object;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        if (this.object != null) {
            try {
                this.window.getActivePage().showView("org.netxms.ui.eclipse.alarmviewer.views.ObjectAlarmBrowser", Long.toString(this.object.getObjectId()), 1);
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)Messages.ShowObjectAlarms_Error, (String)(String.valueOf(Messages.ShowObjectAlarms_ErrorOpeningView) + e.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Node || obj instanceof Container || obj instanceof Subnet || obj instanceof Cluster || obj instanceof EntireNetwork || obj instanceof ServiceRoot || obj instanceof Zone) {
                this.object = (GenericObject)obj;
            }
        } else {
            this.object = null;
        }
        action.setEnabled(this.object != null);
    }
}

