/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenHandler;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenListener;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectBrowser
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.view.navigation.objectbrowser";
    private ObjectTree objectTree;
    private Action actionShowFilter;
    private Action actionShowStatusIndicator;
    private Action actionHideUnmanaged;
    private Action actionHideTemplateChecks;
    private Action actionMoveObject;
    private Action actionMoveTemplate;
    private Action actionMoveBusinessService;
    private Action actionRefresh;
    private Action actionProperties;
    private boolean initHideUnmanaged = false;
    private boolean initHideTemplateChecks = false;
    private boolean initShowFilter = true;
    private boolean initShowStatus = true;
    private List<OpenHandlerData> openHandlers = new ArrayList<OpenHandlerData>(0);

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.initHideUnmanaged = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideUnmanaged"), false);
            this.initHideTemplateChecks = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideTemplateChecks"), false);
            this.initShowFilter = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.showFilter"), true);
            this.initShowStatus = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.showStatusIndicator"), false);
        }
        this.registerOpenHandlers();
    }

    private static boolean safeCast(Boolean b, boolean defval) {
        return b != null ? b : defval;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putBoolean("ObjectBrowser.hideUnmanaged", this.objectTree.isHideUnmanaged());
        memento.putBoolean("ObjectBrowser.hideTemplateChecks", this.objectTree.isHideTemplateChecks());
        memento.putBoolean("ObjectBrowser.showFilter", this.objectTree.isFilterEnabled());
        memento.putBoolean("ObjectBrowser.showStatusIndicator", this.objectTree.isStatusIndicatorEnabled());
    }

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        long[] rootObjects = null;
        Object value = ConsoleSharedData.getProperty((String)"ObjectBrowser.rootObjects");
        if (value != null && value instanceof long[]) {
            rootObjects = (long[])value;
        }
        this.objectTree = new ObjectTree(parent, 0, 2, rootObjects, null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.setLayoutData(fd);
        this.objectTree.setHideTemplateChecks(this.initHideTemplateChecks);
        this.objectTree.setHideUnmanaged(this.initHideUnmanaged);
        this.objectTree.enableFilter(this.initShowFilter);
        this.objectTree.enableStatusIndicator(this.initShowStatus);
        this.objectTree.addOpenListener(new ObjectOpenListener(){

            @Override
            public boolean openObject(GenericObject object) {
                return ObjectBrowser.this.callOpenObjectHandler(object);
            }
        });
        this.createActions();
        this.createMenu();
        this.createToolBar();
        this.createPopupMenu();
        this.objectTree.enableDragSupport();
        this.getSite().setSelectionProvider((ISelectionProvider)this.objectTree.getTreeViewer());
        this.objectTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)ObjectBrowser.this.objectTree.getTreeViewer().getSelection()).size();
                ObjectBrowser.this.actionMoveObject.setEnabled(size == 1);
                ObjectBrowser.this.actionProperties.setEnabled(size == 1);
            }
        });
        this.objectTree.setFilterCloseAction(this.actionShowFilter);
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objectbrowser.context.ObjectBrowser");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectBrowser.this.objectTree.refresh();
            }
        };
        this.actionMoveObject = new Action(Messages.ObjectBrowser_MoveObject){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.INFRASTRUCTURE);
            }
        };
        this.actionMoveTemplate = new Action(Messages.ObjectBrowser_MoveTemplate){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.TEMPLATES);
            }
        };
        this.actionMoveBusinessService = new Action(Messages.ObjectBrowser_MoveService){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.BUSINESS_SERVICES);
            }
        };
        this.actionHideUnmanaged = new Action(Messages.ObjectBrowser_HideUnmanaged, 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideUnmanaged(!ObjectBrowser.this.objectTree.isHideUnmanaged());
                ObjectBrowser.this.actionHideUnmanaged.setChecked(ObjectBrowser.this.objectTree.isHideUnmanaged());
            }
        };
        this.actionHideUnmanaged.setChecked(this.objectTree.isHideUnmanaged());
        this.actionHideTemplateChecks = new Action(Messages.ObjectBrowser_HideCheckTemplates, 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideTemplateChecks(!ObjectBrowser.this.objectTree.isHideTemplateChecks());
                ObjectBrowser.this.actionHideTemplateChecks.setChecked(ObjectBrowser.this.objectTree.isHideTemplateChecks());
            }
        };
        this.actionHideTemplateChecks.setChecked(this.objectTree.isHideTemplateChecks());
        this.actionShowFilter = new Action(Messages.ObjectBrowser_ShowFilter, 2){

            public void run() {
                ObjectBrowser.this.objectTree.enableFilter(!ObjectBrowser.this.objectTree.isFilterEnabled());
                ObjectBrowser.this.actionShowFilter.setChecked(ObjectBrowser.this.objectTree.isFilterEnabled());
            }
        };
        this.actionShowFilter.setChecked(this.objectTree.isFilterEnabled());
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.show_object_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
        this.actionShowStatusIndicator = new Action(Messages.ObjectBrowser_ShowStatusIndicator, 2){

            public void run() {
                ObjectBrowser.this.objectTree.enableStatusIndicator(ObjectBrowser.this.actionShowStatusIndicator.isChecked());
            }
        };
        this.actionShowStatusIndicator.setChecked(this.objectTree.isStatusIndicatorEnabled());
        this.actionShowStatusIndicator.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.show_status_indicator");
        ActionHandler showStatusIndicatorHandler = new ActionHandler((IAction)this.actionShowStatusIndicator);
        handlerService.activateHandler(this.actionShowStatusIndicator.getActionDefinitionId(), (IHandler)showStatusIndicatorHandler);
        this.actionProperties = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionShowStatusIndicator);
        manager.add((IAction)this.actionHideUnmanaged);
        manager.add((IAction)this.actionHideTemplateChecks);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createToolBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectBrowser.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.objectTree.getTreeControl());
        this.objectTree.getTreeControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        if (this.isValidSelectionForMove(SubtreeType.INFRASTRUCTURE)) {
            manager.add((IAction)this.actionMoveObject);
        }
        if (this.isValidSelectionForMove(SubtreeType.TEMPLATES)) {
            manager.add((IAction)this.actionMoveTemplate);
        }
        if (this.isValidSelectionForMove(SubtreeType.BUSINESS_SERVICES)) {
            manager.add((IAction)this.actionMoveBusinessService);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("properties"));
        manager.add((IAction)this.actionProperties);
    }

    public void setFocus() {
        this.objectTree.setFocus();
    }

    public void dispose() {
        super.dispose();
    }

    private boolean isValidSelectionForMove(SubtreeType subtree) {
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        if (selection.length != 1) {
            return false;
        }
        if (selection[0].getParentItem() == null) {
            return false;
        }
        Object currentObject = selection[0].getData();
        Object parentObject = selection[0].getParentItem().getData();
        switch (subtree) {
            case INFRASTRUCTURE: {
                return !(!(currentObject instanceof Node) && !(currentObject instanceof Cluster) && !(currentObject instanceof Subnet) && !(currentObject instanceof Condition) && !(currentObject instanceof Container) || !(parentObject instanceof Container) && !(parentObject instanceof ServiceRoot));
            }
            case TEMPLATES: {
                return !(!(currentObject instanceof Template) && !(currentObject instanceof TemplateGroup) || !(parentObject instanceof TemplateGroup) && !(parentObject instanceof TemplateRoot));
            }
            case BUSINESS_SERVICES: {
                return currentObject instanceof BusinessService && (parentObject instanceof BusinessService || parentObject instanceof BusinessServiceRoot);
            }
        }
        return false;
    }

    private void moveObject(SubtreeType subtree) {
        Set<Integer> filter;
        if (!this.isValidSelectionForMove(subtree)) {
            return;
        }
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        final Object currentObject = selection[0].getData();
        final Object parentObject = selection[0].getParentItem().getData();
        switch (subtree) {
            case INFRASTRUCTURE: {
                filter = ObjectSelectionDialog.createContainerSelectionFilter();
                break;
            }
            case TEMPLATES: {
                filter = ObjectSelectionDialog.createTemplateSelectionFilter();
                break;
            }
            case BUSINESS_SERVICES: {
                filter = ObjectSelectionDialog.createBusinessServiceSelectionFilter();
                break;
            }
            default: {
                filter = null;
            }
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, filter);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            final GenericObject target = dlg.getSelectedObjects().get(0);
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob(String.valueOf(Messages.ObjectBrowser_MoveJob_Title) + ((GenericObject)currentObject).getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long objectId = ((GenericObject)currentObject).getObjectId();
                    session.bindObject(target.getObjectId(), objectId);
                    session.unbindObject(((GenericObject)parentObject).getObjectId(), objectId);
                }

                protected String getErrorMessage() {
                    return String.valueOf(Messages.ObjectBrowser_MoveJob_Error) + ((GenericObject)currentObject).getObjectName();
                }
            }.start();
        }
    }

    private void registerOpenHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectbrowser.objectOpenHandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                OpenHandlerData h = new OpenHandlerData();
                h.handler = (ObjectOpenHandler)elements[i].createExecutableExtension("class");
                h.priority = ObjectBrowser.safeParseInt(elements[i].getAttribute("priority"));
                String className = elements[i].getAttribute("enabledFor");
                try {
                    h.enabledFor = className != null ? Class.forName(className) : null;
                }
                catch (Exception exception) {
                    h.enabledFor = null;
                }
                this.openHandlers.add(h);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(this.openHandlers, new Comparator<OpenHandlerData>(){

            @Override
            public int compare(OpenHandlerData arg0, OpenHandlerData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    private static int safeParseInt(String s) {
        if (s == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 65535;
        }
    }

    private boolean callOpenObjectHandler(GenericObject object) {
        for (OpenHandlerData h : this.openHandlers) {
            if (h.enabledFor != null && !h.enabledFor.isInstance(object) || !h.handler.openObject(object)) continue;
            return true;
        }
        return false;
    }

    private class OpenHandlerData {
        ObjectOpenHandler handler;
        int priority;
        Class<?> enabledFor;

        private OpenHandlerData() {
        }
    }

    private static enum SubtreeType {
        NETWORK,
        INFRASTRUCTURE,
        TEMPLATES,
        DASHBOARDS,
        MAPS,
        BUSINESS_SERVICES;

    }
}

