/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.ComponentTreeContentProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.ComponentTreeLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ComponentsTab
extends ObjectTab {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_CLASS = 1;
    public static final int COLUMN_MODEL = 2;
    public static final int COLUMN_FIRMWARE = 3;
    public static final int COLUMN_SERIAL = 4;
    public static final int COLUMN_VENDOR = 5;
    private TreeViewer viewer;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopyModel;
    private Action actionCopySerial;
    private Action actionCollapeAll;
    private Action actionExpandAll;

    @Override
    protected void createTabContent(Composite parent) {
        this.viewer = new TreeViewer(parent, 65538);
        this.addColumn("Name", 200);
        this.addColumn("Class", 100);
        this.addColumn("Model", 150);
        this.addColumn("Firmware", 100);
        this.addColumn("Serial Number", 150);
        this.addColumn("Vendor", 150);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ComponentTreeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ComponentTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        WidgetHelper.restoreColumnSettings((Tree)this.viewer.getTree(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ComponentTree");
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Tree)ComponentsTab.this.viewer.getTree(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ComponentTree");
            }
        });
        this.createActions();
        this.createPopupMenu();
    }

    private void addColumn(String name, int width) {
        TreeViewerColumn tc = new TreeViewerColumn(this.viewer, 16384);
        tc.getColumn().setText(name);
        tc.getColumn().setWidth(width);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ComponentsTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.getViewPart() != null) {
            this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopyModel);
        manager.add((IAction)this.actionCopySerial);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCollapeAll);
        manager.add((IAction)this.actionExpandAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createActions() {
        this.actionCopy = new Action("&Copy to clipboard", SharedIcons.COPY){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(-1);
            }
        };
        this.actionCopyName = new Action("Copy &name to clipboard"){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(0);
            }
        };
        this.actionCopyModel = new Action("Copy &model to clipboard"){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(2);
            }
        };
        this.actionCopySerial = new Action("Copy &serial number to clipboard"){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(4);
            }
        };
        this.actionCollapeAll = new Action("C&ollapse all", SharedIcons.COLLAPSE_ALL){

            public void run() {
                ComponentsTab.this.viewer.collapseAll();
            }
        };
        this.actionExpandAll = new Action("&Expand all", SharedIcons.EXPAND_ALL){

            public void run() {
                ComponentsTab.this.viewer.expandAll();
            }
        };
    }

    private void copySelectionToClipboard(int column) {
        TreeItem[] selection = this.viewer.getTree().getSelection();
        if (selection.length > 0) {
            String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    sb.append(selection[i].getText(0));
                    int j = 1;
                    while (j < this.viewer.getTree().getColumnCount()) {
                        sb.append("\t");
                        sb.append(selection[i].getText(j));
                        ++j;
                    }
                } else {
                    sb.append(selection[i].getText(column));
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    @Override
    public void objectChanged(final GenericObject object) {
        this.viewer.setInput((Object)new Object[0]);
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob("Get node components", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final PhysicalComponent root = session.getNodePhysicalComponents(object.getObjectId());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ComponentsTab.this.viewer.getTree().isDisposed()) {
                                return;
                            }
                            if (ComponentsTab.this.getObject() != null && ComponentsTab.this.getObject().getObjectId() == object.getObjectId()) {
                                ComponentsTab.this.viewer.setInput((Object)new Object[]{root});
                                ComponentsTab.this.viewer.expandAll();
                            }
                        }
                    });
                }
                catch (NXCException e) {
                    if (e.getErrorCode() != 96) {
                        throw e;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ComponentsTab.this.viewer.getTree().isDisposed()) {
                                return;
                            }
                            if (ComponentsTab.this.getObject() != null && ComponentsTab.this.getObject().getObjectId() == object.getObjectId()) {
                                ComponentsTab.this.viewer.setInput((Object)new Object[0]);
                            }
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot get component information for node " + object.getObjectName();
            }
        };
        job.setUser(false);
        job.start();
    }

    @Override
    public boolean showForObject(GenericObject object) {
        if (object instanceof Node) {
            return (((Node)object).getFlags() & 0x10000) != 0;
        }
        return false;
    }
}

