/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.console.tools.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class AlarmListLabelProvider
implements ITableLabelProvider {
    private static final String[] stateText = new String[]{Messages.AlarmListLabelProvider_AlarmState_Outstanding, Messages.AlarmListLabelProvider_AlarmState_Acknowledged, Messages.AlarmListLabelProvider_AlarmState_Resolved, Messages.AlarmListLabelProvider_AlarmState_Terminated};
    private NXCSession session;
    private Image[] severityImages = new Image[5];
    private Image[] stateImages = new Image[5];
    private Image commentsImage;
    private boolean blinkState = true;

    public AlarmListLabelProvider() {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.severityImages[0] = StatusDisplayInfo.getStatusImage((int)0);
        this.severityImages[1] = StatusDisplayInfo.getStatusImage((int)1);
        this.severityImages[2] = StatusDisplayInfo.getStatusImage((int)2);
        this.severityImages[3] = StatusDisplayInfo.getStatusImage((int)3);
        this.severityImages[4] = StatusDisplayInfo.getStatusImage((int)4);
        this.stateImages[0] = Activator.getImageDescriptor("icons/outstanding.png").createImage();
        this.stateImages[1] = Activator.getImageDescriptor("icons/acknowledged.png").createImage();
        this.stateImages[2] = Activator.getImageDescriptor("icons/resolved.png").createImage();
        this.stateImages[3] = Activator.getImageDescriptor("icons/terminated.png").createImage();
        this.stateImages[4] = Activator.getImageDescriptor("icons/acknowledged_sticky.png").createImage();
        this.commentsImage = Activator.getImageDescriptor("icons/comments.png").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.severityImages[((Alarm)element).getCurrentSeverity()];
            }
            case 1: {
                if (((Alarm)element).getState() == 0) {
                    return this.blinkState ? this.stateImages[0] : SharedIcons.IMG_EMPTY;
                }
                if (((Alarm)element).getState() == 1 && ((Alarm)element).isSticky()) {
                    return this.stateImages[4];
                }
                return this.stateImages[((Alarm)element).getState()];
            }
            case 5: {
                return ((Alarm)element).getCommentsCount() > 0 ? this.commentsImage : null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return StatusDisplayInfo.getStatusText((int)((Alarm)element).getCurrentSeverity());
            }
            case 1: {
                return stateText[((Alarm)element).getState()];
            }
            case 2: {
                GenericObject object = this.session.findObjectById(((Alarm)element).getSourceObjectId());
                return object != null ? object.getObjectName() : "[" + Long.toString(((Alarm)element).getSourceObjectId()) + "]";
            }
            case 3: {
                return ((Alarm)element).getMessage();
            }
            case 4: {
                return Integer.toString(((Alarm)element).getRepeatCount());
            }
            case 5: {
                return ((Alarm)element).getCommentsCount() > 0 ? Integer.toString(((Alarm)element).getCommentsCount()) : null;
            }
            case 6: {
                if (((Alarm)element).getState() == 0) {
                    return null;
                }
                long userId = ((Alarm)element).getState() == 1 ? ((Alarm)element).getAckByUser() : ((Alarm)element).getResolvedByUser();
                AbstractUserObject user = this.session.findUserDBObjectById(userId);
                return user != null ? user.getName() : "[" + Long.toString(((Alarm)element).getAckByUser()) + "]";
            }
            case 7: {
                return RegionalSettings.getDateTimeFormat().format(((Alarm)element).getCreationTime());
            }
            case 8: {
                return RegionalSettings.getDateTimeFormat().format(((Alarm)element).getLastChangeTime());
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.stateImages.length) {
            this.stateImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void toggleBlinkState() {
        this.blinkState = !this.blinkState;
    }
}

