/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogColumn;
import org.netxms.ui.eclipse.logviewer.widgets.AlarmHDStateConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.AlarmStateConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.EventConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.FilterBuilder;
import org.netxms.ui.eclipse.logviewer.widgets.IntegerConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.ObjectConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.SeverityConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.TextConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.TimestampConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.UserConditionEditor;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class ColumnFilterEditor
extends DashboardComposite {
    private FormToolkit toolkit;
    private LogColumn column;
    private FilterBuilder filterBuilder;
    private List<ConditionEditor> conditions = new ArrayList<ConditionEditor>();
    private int booleanOperation = 1;

    public ColumnFilterEditor(Composite parent, FormToolkit toolkit, LogColumn column, final Runnable deleteHandler) {
        super(parent, 2048);
        this.toolkit = toolkit;
        this.column = column;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        Composite header = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 5;
        header.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        header.setLayoutData((Object)gd);
        Label title = new Label(header, 0);
        title.setText(column.getDescription());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        title.setLayoutData((Object)gd);
        Composite buttons = new Composite(header, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)gd);
        Button radioAnd = toolkit.createButton(buttons, "&AND condition", 16);
        radioAnd.setSelection(this.booleanOperation == 0);
        radioAnd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnFilterEditor.this.setBooleanOperation(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button radioOr = toolkit.createButton(buttons, "&OR condition", 16);
        radioOr.setSelection(this.booleanOperation == 1);
        radioOr.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnFilterEditor.this.setBooleanOperation(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        ImageHyperlink link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ColumnFilterEditor.this.addCondition();
            }
        });
        link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ColumnFilterEditor.this.dispose();
                deleteHandler.run();
            }
        });
    }

    private void setBooleanOperation(int op) {
        this.booleanOperation = op;
        String opName = op == 0 ? "AND" : "OR";
        int i = 1;
        while (i < this.conditions.size()) {
            this.conditions.get(i).setLogicalOperation(opName);
            ++i;
        }
    }

    private void addCondition() {
        final ConditionEditor ce = this.createConditionEditor();
        ce.setDeleteHandler(new Runnable(){

            @Override
            public void run() {
                ColumnFilterEditor.this.conditions.remove((Object)ce);
                if (ColumnFilterEditor.this.conditions.size() > 0) {
                    ((ConditionEditor)((Object)ColumnFilterEditor.this.conditions.get(0))).setLogicalOperation("");
                }
                ColumnFilterEditor.this.filterBuilder.updateLayout();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        ce.setLayoutData(gd);
        this.conditions.add(ce);
        if (this.conditions.size() > 1) {
            ce.setLogicalOperation(this.booleanOperation == 0 ? "AND" : "OR");
        }
        this.filterBuilder.updateLayout();
    }

    private ConditionEditor createConditionEditor() {
        switch (this.column.getType()) {
            case 8: {
                return new AlarmHDStateConditionEditor((Composite)this, this.toolkit);
            }
            case 7: {
                return new AlarmStateConditionEditor((Composite)this, this.toolkit);
            }
            case 4: {
                return new EventConditionEditor((Composite)this, this.toolkit);
            }
            case 6: {
                return new IntegerConditionEditor((Composite)this, this.toolkit);
            }
            case 2: {
                return new ObjectConditionEditor((Composite)this, this.toolkit);
            }
            case 1: {
                return new SeverityConditionEditor((Composite)this, this.toolkit);
            }
            case 5: {
                return new TimestampConditionEditor((Composite)this, this.toolkit);
            }
            case 3: {
                return new UserConditionEditor((Composite)this, this.toolkit);
            }
        }
        return new TextConditionEditor((Composite)this, this.toolkit);
    }

    public void attachFilterBuilder(FilterBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        this.addCondition();
    }

    public ColumnFilter buildFilterTree() {
        if (this.conditions.size() == 0) {
            return null;
        }
        if (this.conditions.size() > 1) {
            ColumnFilter root = new ColumnFilter();
            root.setOperation(this.booleanOperation);
            for (ConditionEditor e : this.conditions) {
                ColumnFilter filter = e.createFilter();
                root.addSubFilter(filter);
            }
            return root;
        }
        return this.conditions.get(0).createFilter();
    }
}

