/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.views;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.ServiceContainer;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedColors;
import org.netxms.ui.eclipse.slm.Messages;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class ServiceAvailability
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.slm.views.ServiceAvailability";
    private ServiceContainer object;
    private DataComparisonChart dayChart;
    private DataComparisonChart weekChart;
    private DataComparisonChart monthChart;
    private ColorCache colors;
    private SessionListener listener;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            this.object = (ServiceContainer)session.findObjectById(Long.parseLong(site.getSecondaryId()), ServiceContainer.class);
        }
        catch (Exception e) {
            throw new PartInitException(Messages.ServiceAvailability_InternalError, (Throwable)e);
        }
        if (this.object == null) {
            throw new PartInitException(String.valueOf(Messages.ServiceAvailability_InitErrorPart1) + site.getSecondaryId() + Messages.ServiceAvailability_InitErrorPart2);
        }
        this.setPartName(String.valueOf(Messages.ServiceAvailability_PartNamePrefix) + this.object.getObjectName());
    }

    public void createPartControl(Composite parent) {
        final Composite clientArea = new Composite(parent, 0);
        this.colors = new ColorCache((Control)clientArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        clientArea.setLayout((Layout)layout);
        this.dayChart = this.createChart(clientArea, Messages.ServiceAvailability_Today);
        this.weekChart = this.createChart(clientArea, Messages.ServiceAvailability_ThisWeek);
        this.monthChart = this.createChart(clientArea, Messages.ServiceAvailability_ThisMonth);
        Canvas legend = new Canvas(clientArea, 0);
        legend.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ServiceAvailability.this.paintLegend(e.gc);
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        legend.setLayoutData((Object)gd);
        this.listener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 4 && n.getSubCode() == ServiceAvailability.this.object.getObjectId()) {
                    clientArea.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ServiceAvailability.this.object = (ServiceContainer)n.getObject();
                            ServiceAvailability.this.refresh();
                        }
                    });
                }
            }
        };
        ConsoleSharedData.getSession().addListener(this.listener);
    }

    private DataComparisonChart createChart(Composite parent, String title) {
        DataComparisonChart chart = ChartFactory.createPieChart((Composite)parent, (int)0);
        chart.setTitleVisible(true);
        chart.set3DModeEnabled(true);
        chart.setChartTitle(title);
        chart.setLegendVisible(false);
        chart.setLabelsVisible(true);
        chart.setRotation(225.0);
        chart.addParameter(new GraphItem(0L, 0L, 0, 0, Messages.ServiceAvailability_Up, Messages.ServiceAvailability_Up), 100.0);
        chart.addParameter(new GraphItem(0L, 0L, 0, 0, Messages.ServiceAvailability_Down, Messages.ServiceAvailability_Down), 0.0);
        chart.setPaletteEntry(0, new ChartColor(127, 154, 72));
        chart.setPaletteEntry(1, new ChartColor(158, 65, 62));
        chart.initializationComplete();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        ((Control)chart).setLayoutData((Object)gd);
        return chart;
    }

    private void paintLegend(GC gc) {
        int th = gc.textExtent((String)Messages.ServiceAvailability_UptimeDowntime).y;
        gc.setBackground(this.colors.create(127, 154, 72));
        gc.setForeground(ColorConverter.adjustColor((Color)gc.getBackground(), (Color)SharedColors.BLACK, (float)0.2f, (ColorCache)this.colors));
        gc.fillRectangle(5, 10, th, th);
        gc.drawRectangle(5, 10, th, th);
        gc.setBackground(this.colors.create(158, 65, 62));
        gc.setForeground(ColorConverter.adjustColor((Color)gc.getBackground(), (Color)SharedColors.BLACK, (float)0.2f, (ColorCache)this.colors));
        gc.fillRectangle(5, 40, th, th);
        gc.drawRectangle(5, 40, th, th);
        gc.setForeground(SharedColors.BLACK);
        gc.drawText(Messages.ServiceAvailability_Uptime, 10 + th, 10, true);
        gc.drawText(Messages.ServiceAvailability_Downtime, 10 + th, 40, true);
    }

    public void setFocus() {
    }

    private void refresh() {
        this.dayChart.updateParameter(0, this.object.getUptimeForDay(), false);
        this.dayChart.updateParameter(1, 100.0 - this.object.getUptimeForDay(), true);
        this.weekChart.updateParameter(0, this.object.getUptimeForWeek(), false);
        this.weekChart.updateParameter(1, 100.0 - this.object.getUptimeForWeek(), true);
        this.monthChart.updateParameter(0, this.object.getUptimeForMonth(), false);
        this.monthChart.updateParameter(1, 100.0 - this.object.getUptimeForMonth(), true);
    }
}

