/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.HashMap;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.AlgorithmHelper;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.LayoutListener;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class SpringLayoutAlgorithm
implements LayoutAlgorithm {
    public static final int DEFAULT_SPRING_ITERATIONS = 1000;
    public static final long MAX_SPRING_TIME = 10000L;
    public static final boolean DEFAULT_SPRING_RANDOM = true;
    public static final double DEFAULT_SPRING_MOVE = 1.0;
    public static final double DEFAULT_SPRING_STRAIN = 1.0;
    public static final double DEFAULT_SPRING_LENGTH = 3.0;
    public static final double DEFAULT_SPRING_GRAVITATION = 2.0;
    protected static final double MIN_DISTANCE = 1.0;
    protected static final double EPSILON = 0.001;
    private int sprIterations = 1000;
    private long maxTimeMS = 10000L;
    private boolean sprRandom = true;
    private double sprMove = 1.0;
    private double sprStrain = 1.0;
    private double sprLength = 3.0;
    private double sprGravitation = 2.0;
    private boolean resize = false;
    private int iteration;
    private double[][] srcDestToSumOfWeights;
    private EntityLayout[] entities;
    private double[] forcesX;
    private double[] forcesY;
    private double[] locationsX;
    private double[] locationsY;
    private double[] sizeW;
    private double[] sizeH;
    private DisplayIndependentRectangle bounds;
    private double boundsScaleX = 0.2;
    private double boundsScaleY = 0.2;
    public boolean fitWithinBounds = true;
    private LayoutContext context;
    private long startTime = 0L;
    private int[] counter;
    private int[] counterX;
    private int[] counterY;

    public SpringLayoutAlgorithm(int style) {
        this();
        this.setResizing(style != 1);
    }

    public SpringLayoutAlgorithm() {
    }

    /*
     * Unable to fully structure code
     */
    public void applyLayout(boolean clean) {
        this.initLayout();
        if (clean) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.computeOneIteration();
lbl5:
            // 2 sources

            ** while (this.performAnotherNonContinuousIteration())
        }
lbl6:
        // 1 sources

        this.saveLocations();
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(this.entities);
        }
        if (this.fitWithinBounds) {
            bounds2 = new DisplayIndependentRectangle(this.bounds);
            insets = 4;
            bounds2.x += (double)insets;
            bounds2.y += (double)insets;
            bounds2.width -= (double)(2 * insets);
            bounds2.height -= (double)(2 * insets);
            AlgorithmHelper.fitWithinBounds(this.entities, bounds2, this.resize);
        }
    }

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
        this.context.addLayoutListener(new SpringLayoutListener());
        this.initLayout();
    }

    public void performNIteration(int n) {
        if (this.iteration == 0) {
            this.entities = this.context.getEntities();
            this.loadLocations();
            this.initLayout();
        }
        this.bounds = this.context.getBounds();
        int i = 0;
        while (i < n) {
            this.computeOneIteration();
            this.saveLocations();
            ++i;
        }
        this.context.flushChanges(false);
    }

    public void performOneIteration() {
        if (this.iteration == 0) {
            this.entities = this.context.getEntities();
            this.loadLocations();
            this.initLayout();
        }
        this.bounds = this.context.getBounds();
        this.computeOneIteration();
        this.saveLocations();
        this.context.flushChanges(false);
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }

    public void setSpringMove(double move) {
        this.sprMove = move;
    }

    public double getSpringMove() {
        return this.sprMove;
    }

    public void setSpringStrain(double strain) {
        this.sprStrain = strain;
    }

    public double getSpringStrain() {
        return this.sprStrain;
    }

    public void setSpringLength(double length) {
        this.sprLength = length;
    }

    public long getSpringTimeout() {
        return this.maxTimeMS;
    }

    public void setSpringTimeout(long timeout) {
        this.maxTimeMS = timeout;
    }

    public double getSpringLength() {
        return this.sprLength;
    }

    public void setSpringGravitation(double gravitation) {
        this.sprGravitation = gravitation;
    }

    public double getSpringGravitation() {
        return this.sprGravitation;
    }

    public void setIterations(int iterations) {
        this.sprIterations = iterations;
    }

    public int getIterations() {
        return this.sprIterations;
    }

    public void setRandom(boolean random) {
        this.sprRandom = random;
    }

    public boolean getRandom() {
        return this.sprRandom;
    }

    private void initLayout() {
        this.entities = this.context.getEntities();
        this.bounds = this.context.getBounds();
        this.loadLocations();
        this.srcDestToSumOfWeights = new double[this.entities.length][this.entities.length];
        HashMap<EntityLayout, Integer> entityToPosition = new HashMap<EntityLayout, Integer>();
        int i = 0;
        while (i < this.entities.length) {
            entityToPosition.put(this.entities[i], new Integer(i));
            ++i;
        }
        ConnectionLayout[] connections = this.context.getConnections();
        int i2 = 0;
        while (i2 < connections.length) {
            ConnectionLayout connection = connections[i2];
            Integer source = (Integer)entityToPosition.get(this.getEntity(connection.getSource()));
            Integer target = (Integer)entityToPosition.get(this.getEntity(connection.getTarget()));
            if (source != null && target != null) {
                double weight = connection.getWeight();
                weight = weight <= 0.0 ? 0.1 : weight;
                double[] dArray = this.srcDestToSumOfWeights[source];
                int n = target;
                dArray[n] = dArray[n] + weight;
                double[] dArray2 = this.srcDestToSumOfWeights[target];
                int n2 = source;
                dArray2[n2] = dArray2[n2] + weight;
            }
            ++i2;
        }
        if (this.sprRandom) {
            this.placeRandomly();
        }
        this.iteration = 1;
        this.startTime = System.currentTimeMillis();
    }

    private EntityLayout getEntity(NodeLayout node) {
        if (!node.isPruned()) {
            return node;
        }
        SubgraphLayout subgraph = node.getSubgraph();
        if (subgraph.isGraphEntity()) {
            return subgraph;
        }
        return null;
    }

    private void loadLocations() {
        if (this.locationsX == null || this.locationsX.length != this.entities.length) {
            int length = this.entities.length;
            this.locationsX = new double[length];
            this.locationsY = new double[length];
            this.sizeW = new double[length];
            this.sizeH = new double[length];
            this.forcesX = new double[length];
            this.forcesY = new double[length];
            this.counterX = new int[length];
            this.counterY = new int[length];
        }
        int i = 0;
        while (i < this.entities.length) {
            DisplayIndependentPoint location = this.entities[i].getLocation();
            this.locationsX[i] = location.x;
            this.locationsY[i] = location.y;
            DisplayIndependentDimension size = this.entities[i].getSize();
            this.sizeW[i] = size.width;
            this.sizeH[i] = size.height;
            ++i;
        }
    }

    private void saveLocations() {
        if (this.entities == null) {
            return;
        }
        int i = 0;
        while (i < this.entities.length) {
            this.entities[i].setLocation(this.locationsX[i], this.locationsY[i]);
            ++i;
        }
    }

    private void setSprIterationsBasedOnTime() {
        if (this.maxTimeMS <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        double fractionComplete = (double)(currentTime - this.startTime) / (double)this.maxTimeMS;
        int currentIteration = (int)(fractionComplete * (double)this.sprIterations);
        if (currentIteration > this.iteration) {
            this.iteration = currentIteration;
        }
    }

    protected boolean performAnotherNonContinuousIteration() {
        this.setSprIterationsBasedOnTime();
        return this.iteration <= this.sprIterations;
    }

    protected int getCurrentLayoutStep() {
        return this.iteration;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return this.sprIterations;
    }

    protected void computeOneIteration() {
        this.computeForces();
        this.computePositions();
        DisplayIndependentRectangle currentBounds = this.getLayoutBounds();
        this.improveBoundScaleX(currentBounds);
        this.improveBoundScaleY(currentBounds);
        this.moveToCenter(currentBounds);
        ++this.iteration;
    }

    public void placeRandomly() {
        if (this.locationsX.length == 0) {
            return;
        }
        if (this.locationsX.length == 1) {
            this.locationsX[0] = this.bounds.x + 0.5 * this.bounds.width;
            this.locationsY[0] = this.bounds.y + 0.5 * this.bounds.height;
        } else {
            this.locationsX[0] = this.bounds.x;
            this.locationsY[0] = this.bounds.y;
            this.locationsX[1] = this.bounds.x + this.bounds.width;
            this.locationsY[1] = this.bounds.y + this.bounds.height;
            int i = 2;
            while (i < this.locationsX.length) {
                this.locationsX[i] = this.bounds.x + Math.random() * this.bounds.width;
                this.locationsY[i] = this.bounds.y + Math.random() * this.bounds.height;
                ++i;
            }
        }
    }

    protected void computeForces() {
        int i;
        double[][] forcesX = new double[2][this.forcesX.length];
        double[][] forcesY = new double[2][this.forcesX.length];
        double[] locationsX = new double[this.forcesX.length];
        double[] locationsY = new double[this.forcesX.length];
        int j = 0;
        while (j < 2) {
            i = 0;
            while (i < this.forcesX.length) {
                forcesX[j][i] = 0.0;
                forcesY[j][i] = 0.0;
                locationsX[i] = this.locationsX[i];
                locationsY[i] = this.locationsY[i];
                ++i;
            }
            ++j;
        }
        int k = 0;
        while (k < 2) {
            i = 0;
            while (i < this.locationsX.length) {
                int j2 = i + 1;
                while (j2 < locationsX.length) {
                    double dx = (locationsX[i] - locationsX[j2]) / this.bounds.width / this.boundsScaleX;
                    double dy = (locationsY[i] - locationsY[j2]) / this.bounds.height / this.boundsScaleY;
                    double distance_sq = dx * dx + dy * dy;
                    distance_sq = Math.max(1.0, distance_sq);
                    double distance = Math.sqrt(distance_sq);
                    double sumOfWeights = this.srcDestToSumOfWeights[i][j2];
                    double f = sumOfWeights > 0.0 ? -this.sprStrain * Math.log(distance / this.sprLength) * sumOfWeights : this.sprGravitation / distance_sq;
                    double dfx = f * dx / distance;
                    double dfy = f * dy / distance;
                    double[] dArray = forcesX[k];
                    int n = i;
                    dArray[n] = dArray[n] + dfx;
                    double[] dArray2 = forcesY[k];
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + dfy;
                    double[] dArray3 = forcesX[k];
                    int n3 = j2;
                    dArray3[n3] = dArray3[n3] - dfx;
                    double[] dArray4 = forcesY[k];
                    int n4 = j2++;
                    dArray4[n4] = dArray4[n4] - dfy;
                }
                ++i;
            }
            i = 0;
            while (i < this.entities.length) {
                if (this.entities[i].isMovable()) {
                    double maxMovement;
                    double deltaX = this.sprMove * forcesX[k][i];
                    double deltaY = this.sprMove * forcesY[k][i];
                    double dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                    if (dist > (maxMovement = 0.2 * this.sprMove)) {
                        deltaX *= maxMovement / dist;
                        deltaY *= maxMovement / dist;
                    }
                    int n = i;
                    locationsX[n] = locationsX[n] + deltaX * this.bounds.width * this.boundsScaleX;
                    int n5 = i;
                    locationsY[n5] = locationsY[n5] + deltaY * this.bounds.height * this.boundsScaleY;
                }
                ++i;
            }
            ++k;
        }
        int i2 = 0;
        while (i2 < this.entities.length) {
            this.forcesX[i2] = forcesX[0][i2] * forcesX[1][i2] < 0.0 ? 0.0 : forcesX[1][i2];
            this.forcesY[i2] = forcesY[0][i2] * forcesY[1][i2] < 0.0 ? 0.0 : forcesY[1][i2];
            ++i2;
        }
    }

    protected void computePositions() {
        int i = 0;
        while (i < this.entities.length) {
            if (this.entities[i].isMovable()) {
                double maxMovement;
                double deltaX = this.sprMove * this.forcesX[i];
                double deltaY = this.sprMove * this.forcesY[i];
                double dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                if (dist > (maxMovement = 0.2 * this.sprMove)) {
                    deltaX *= maxMovement / dist;
                    deltaY *= maxMovement / dist;
                }
                int n = i;
                this.locationsX[n] = this.locationsX[n] + deltaX * this.bounds.width * this.boundsScaleX;
                int n2 = i;
                this.locationsY[n2] = this.locationsY[n2] + deltaY * this.bounds.height * this.boundsScaleY;
            }
            ++i;
        }
    }

    private DisplayIndependentRectangle getLayoutBounds() {
        double minY = Double.POSITIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.locationsX.length) {
            maxX = Math.max(maxX, this.locationsX[i] + this.sizeW[i] / 2.0);
            minX = Math.min(minX, this.locationsX[i] - this.sizeW[i] / 2.0);
            maxY = Math.max(maxY, this.locationsY[i] + this.sizeH[i] / 2.0);
            minY = Math.min(minY, this.locationsY[i] - this.sizeH[i] / 2.0);
            ++i;
        }
        return new DisplayIndependentRectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private void improveBoundScaleX(DisplayIndependentRectangle currentBounds) {
        double boundaryProportionX = currentBounds.width / this.bounds.width;
        if (boundaryProportionX < 0.9) {
            this.boundsScaleX *= 1.01;
        } else if (boundaryProportionX > 1.0) {
            if (this.boundsScaleX < 0.01) {
                return;
            }
            this.boundsScaleX /= 1.01;
        }
    }

    private void improveBoundScaleY(DisplayIndependentRectangle currentBounds) {
        double boundaryProportionY = currentBounds.height / this.bounds.height;
        if (boundaryProportionY < 0.9) {
            this.boundsScaleY *= 1.01;
        } else if (boundaryProportionY > 1.0) {
            if (this.boundsScaleY < 0.01) {
                return;
            }
            this.boundsScaleY /= 1.01;
        }
    }

    private void moveToCenter(DisplayIndependentRectangle currentBounds) {
        double moveX = currentBounds.x + currentBounds.width / 2.0 - (this.bounds.x + this.bounds.width / 2.0);
        double moveY = currentBounds.y + currentBounds.height / 2.0 - (this.bounds.y + this.bounds.height / 2.0);
        int i = 0;
        while (i < this.locationsX.length) {
            int n = i;
            this.locationsX[n] = this.locationsX[n] - moveX;
            int n2 = i++;
            this.locationsY[n2] = this.locationsY[n2] - moveY;
        }
    }

    class SpringLayoutListener
    implements LayoutListener {
        SpringLayoutListener() {
        }

        public boolean nodeMoved(LayoutContext context, NodeLayout node) {
            int i = 0;
            while (i < SpringLayoutAlgorithm.this.entities.length) {
                if (SpringLayoutAlgorithm.this.entities[i] == node) {
                    ((SpringLayoutAlgorithm)SpringLayoutAlgorithm.this).locationsX[i] = ((SpringLayoutAlgorithm)SpringLayoutAlgorithm.this).entities[i].getLocation().x;
                    ((SpringLayoutAlgorithm)SpringLayoutAlgorithm.this).locationsY[i] = ((SpringLayoutAlgorithm)SpringLayoutAlgorithm.this).entities[i].getLocation().y;
                }
                ++i;
            }
            return false;
        }

        public boolean nodeResized(LayoutContext context, NodeLayout node) {
            return false;
        }

        public boolean subgraphMoved(LayoutContext context, SubgraphLayout subgraph) {
            return false;
        }

        public boolean subgraphResized(LayoutContext context, SubgraphLayout subgraph) {
            return false;
        }
    }
}

