/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventLabelProvider;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventMonitorFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.views.AbstractTraceView;

public class EventMonitor
extends AbstractTraceView
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.eventmanager.views.EventMonitor";
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_EVENT = 3;
    public static final int COLUMN_MESSAGE = 4;
    private NXCSession session;
    private Action actionShowColor;
    private Action actionShowIcons;
    private EventLabelProvider labelProvider;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.session.addListener((SessionListener)this);
    }

    protected void setupViewer(TableViewer viewer) {
        this.labelProvider = new EventLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.labelProvider.setShowColor(ps.getBoolean("EventMonitor.showColor"));
        this.labelProvider.setShowIcons(ps.getBoolean("EventMonitor.showIcons"));
        this.addColumn(Messages.EventMonitor_ColTimestamp, 150);
        this.addColumn(Messages.EventMonitor_ColSource, 200);
        this.addColumn(Messages.EventMonitor_ColSeverity, 90);
        this.addColumn(Messages.EventMonitor_ColEvent, 200);
        this.addColumn(Messages.EventMonitor_ColMessage, 600);
        this.setFilter(new EventMonitorFilter());
    }

    protected void createActions() {
        super.createActions();
        this.actionShowColor = new Action(Messages.EventMonitor_ShowStatusColors, 2){

            public void run() {
                EventMonitor.this.labelProvider.setShowColor(EventMonitor.this.actionShowColor.isChecked());
                EventMonitor.this.refresh();
            }
        };
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        this.actionShowIcons = new Action(Messages.EventMonitor_ShowStatusIcons, 2){

            public void run() {
                EventMonitor.this.labelProvider.setShowIcons(EventMonitor.this.actionShowIcons.isChecked());
                EventMonitor.this.refresh();
            }
        };
        this.actionShowIcons.setChecked(this.labelProvider.isShowIcons());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        super.fillLocalPullDown(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowColor);
        manager.add((IAction)this.actionShowIcons);
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 2) {
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    EventMonitor.this.addElement(n.getObject());
                }
            });
        }
    }

    public void dispose() {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        ps.setValue("EventMonitor.showColor", this.labelProvider.isShowColor());
        ps.setValue("EventMonitor.showIcons", this.labelProvider.isShowIcons());
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected String getConfigPrefix() {
        return "EventMonitor";
    }
}

