/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class InterfaceListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final String[] ifaceExpectedState = new String[]{"UP", "DOWN", "IGNORE"};
    private Node node = null;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.node == null) {
            return null;
        }
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 17: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xBackendStateAsText();
                }
                return null;
            }
            case 16: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xPaeStateAsText();
                }
                return null;
            }
            case 12: {
                return iface.getAdminStateAsText();
            }
            case 6: {
                return iface.getDescription();
            }
            case 14: {
                try {
                    return ifaceExpectedState[iface.getExpectedState()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return null;
                }
            }
            case 0: {
                return Long.toString(iface.getObjectId());
            }
            case 3: {
                return Integer.toString(iface.getIfIndex());
            }
            case 1: {
                return iface.getObjectName();
            }
            case 13: {
                return iface.getOperStateAsText();
            }
            case 5: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getPort());
                }
                return null;
            }
            case 4: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getSlot());
                }
                return null;
            }
            case 15: {
                return StatusDisplayInfo.getStatusText((int)iface.getStatus());
            }
            case 2: {
                return Integer.toString(iface.getIfType());
            }
            case 7: {
                return iface.getMacAddress().toString();
            }
            case 8: {
                return iface.getPrimaryIP().isAnyLocalAddress() ? null : iface.getPrimaryIP().getHostAddress();
            }
            case 9: {
                return this.getPeerName(iface);
            }
            case 10: {
                return this.getPeerMacAddress(iface);
            }
            case 11: {
                return this.getPeerIpAddress(iface);
            }
        }
        return null;
    }

    private String getPeerIpAddress(Interface iface) {
        Node peer = (Node)this.session.findObjectById(iface.getPeerNodeId(), Node.class);
        if (peer == null) {
            return null;
        }
        if (peer.getPrimaryIP().isAnyLocalAddress()) {
            return null;
        }
        return peer.getPrimaryIP().getHostAddress();
    }

    private String getPeerMacAddress(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? peer.getMacAddress().toString() : null;
    }

    private String getPeerName(Interface iface) {
        Node peer = (Node)this.session.findObjectById(iface.getPeerNodeId(), Node.class);
        return peer != null ? peer.getObjectName() : null;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Color getForeground(Object element, int columnIndex) {
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 15: {
                return StatusDisplayInfo.getStatusColor((int)iface.getStatus());
            }
            case 13: {
                switch (iface.getOperState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((int)0);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((int)(iface.getAdminState() == 2 ? 7 : 4));
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((int)8);
                    }
                }
                return StatusDisplayInfo.getStatusColor((int)5);
            }
            case 12: {
                switch (iface.getAdminState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((int)0);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((int)7);
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((int)8);
                    }
                }
                return StatusDisplayInfo.getStatusColor((int)5);
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

