/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.services.SourceProvider;
import org.netxms.ui.eclipse.shared.SharedColors;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;

public class TabbedObjectView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectview.view.tabbed_object_view";
    private CLabel header;
    private CTabFolder tabFolder;
    private Font headerFont;
    private Color headerColor;
    private List<ObjectTab> tabs;
    private ISelectionService selectionService = null;
    private ISelectionListener selectionListener = null;
    private IntermediateSelectionProvider selectionProvider;
    private Action actionRefresh;
    private SourceProvider sourceProvider;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.sourceProvider = Activator.getDefault().getSourceProvider();
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.headerFont = new Font((Device)parent.getDisplay(), "Verdana", 11, 1);
        this.headerColor = new Color((Device)parent.getDisplay(), 153, 180, 209);
        this.header = new CLabel(parent, 2048);
        this.header.setLayoutData((Object)new GridData(4, 4, true, false));
        this.header.setFont(this.headerFont);
        this.header.setBackground(this.headerColor);
        this.header.setForeground(SharedColors.WHITE);
        this.tabFolder = new CTabFolder(parent, 0x800082);
        this.tabFolder.setUnselectedImageVisible(true);
        this.tabFolder.setSimple(true);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ObjectTab tab = null;
                if (e.item != null) {
                    tab = (ObjectTab)((CTabItem)e.item).getData();
                    tab.selected();
                    TabbedObjectView.this.selectionProvider.setSelectionProviderDelegate(tab.getSelectionProvider());
                }
                TabbedObjectView.this.sourceProvider.updateProperty("nxmcObjectViewActiveTab", tab);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tabs = new ArrayList<ObjectTab>();
        this.addTabs();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object object;
                if (selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof GenericObject) {
                    TabbedObjectView.this.setObject((GenericObject)object);
                }
            }
        };
        this.selectionService.addPostSelectionListener(this.selectionListener);
        this.createActions();
        this.contributeToActionBars();
        this.selectionProvider = new IntermediateSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                TabbedObjectView.this.refreshCurrentTab();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void refreshCurrentTab() {
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            ((ObjectTab)item.getData()).refresh();
        }
    }

    public void setObject(GenericObject object) {
        this.header.setText(object.getObjectName());
        for (ObjectTab tab : this.tabs) {
            if (tab.showForObject(object)) {
                tab.show();
                tab.changeObject(object);
                continue;
            }
            tab.hide();
        }
        if (this.tabFolder.getSelection() == null) {
            try {
                this.tabFolder.setSelection(this.tabFolder.getItem(0));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            ((ObjectTab)item.getData()).selected();
        }
    }

    private void addTabs() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectview.tabs");
        int i = 0;
        while (i < elements.length) {
            try {
                ObjectTab tab = (ObjectTab)elements[i].createExecutableExtension("class");
                tab.configure(elements[i], this);
                this.tabs.add(tab);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(this.tabs, new Comparator<ObjectTab>(){

            @Override
            public int compare(ObjectTab arg0, ObjectTab arg1) {
                return arg0.getOrder() - arg1.getOrder();
            }
        });
        for (ObjectTab tab : this.tabs) {
            tab.create(this.tabFolder);
        }
    }

    public void dispose() {
        this.sourceProvider.updateProperty("nxmcObjectViewActiveTab", null);
        this.getSite().setSelectionProvider(null);
        if (this.selectionService != null && this.selectionListener != null) {
            this.selectionService.removePostSelectionListener(this.selectionListener);
        }
        for (ObjectTab tab : this.tabs) {
            tab.dispose();
        }
        this.headerFont.dispose();
        this.headerColor.dispose();
        super.dispose();
    }
}

